/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Expression;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.element.ParameterElement;
import com.google.dart.engine.scanner.Token;
import java.util.List;

public class ArgumentList
extends AstNode {
    private Token leftParenthesis;
    private NodeList<Expression> arguments = new NodeList(this);
    private Token rightParenthesis;
    private ParameterElement[] correspondingStaticParameters;
    private ParameterElement[] correspondingPropagatedParameters;

    public ArgumentList(Token token, List<Expression> list, Token token2) {
        this.leftParenthesis = token;
        this.arguments.addAll(list);
        this.rightParenthesis = token2;
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitArgumentList(this);
    }

    public NodeList<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public Token getBeginToken() {
        return this.leftParenthesis;
    }

    @Override
    public Token getEndToken() {
        return this.rightParenthesis;
    }

    public Token getLeftParenthesis() {
        return this.leftParenthesis;
    }

    public Token getRightParenthesis() {
        return this.rightParenthesis;
    }

    public void setCorrespondingPropagatedParameters(ParameterElement[] parameterElementArray) {
        if (parameterElementArray.length != this.arguments.size()) {
            throw new IllegalArgumentException("Expected " + this.arguments.size() + " parameters, not " + parameterElementArray.length);
        }
        this.correspondingPropagatedParameters = parameterElementArray;
    }

    public void setCorrespondingStaticParameters(ParameterElement[] parameterElementArray) {
        if (parameterElementArray.length != this.arguments.size()) {
            throw new IllegalArgumentException("Expected " + this.arguments.size() + " parameters, not " + parameterElementArray.length);
        }
        this.correspondingStaticParameters = parameterElementArray;
    }

    public void setLeftParenthesis(Token token) {
        this.leftParenthesis = token;
    }

    public void setRightParenthesis(Token token) {
        this.rightParenthesis = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.arguments.accept(astVisitor);
    }

    protected ParameterElement getPropagatedParameterElementFor(Expression expression) {
        if (this.correspondingPropagatedParameters == null) {
            return null;
        }
        int n = this.arguments.indexOf(expression);
        if (n < 0) {
            return null;
        }
        return this.correspondingPropagatedParameters[n];
    }

    protected ParameterElement getStaticParameterElementFor(Expression expression) {
        if (this.correspondingStaticParameters == null) {
            return null;
        }
        int n = this.arguments.indexOf(expression);
        if (n < 0) {
            return null;
        }
        return this.correspondingStaticParameters[n];
    }
}

