/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.ArgumentList;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Identifier;
import com.google.dart.engine.ast.SimpleIdentifier;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.ElementAnnotation;
import com.google.dart.engine.scanner.Token;

public class Annotation
extends AstNode {
    private Token atSign;
    private Identifier name;
    private Token period;
    private SimpleIdentifier constructorName;
    private ArgumentList arguments;
    private Element element;
    private ElementAnnotation elementAnnotation;

    public Annotation(Token token, Identifier identifier, Token token2, SimpleIdentifier simpleIdentifier, ArgumentList argumentList) {
        this.atSign = token;
        this.name = this.becomeParentOf(identifier);
        this.period = token2;
        this.constructorName = this.becomeParentOf(simpleIdentifier);
        this.arguments = this.becomeParentOf(argumentList);
    }

    @Override
    public <R> R accept(AstVisitor<R> astVisitor) {
        return astVisitor.visitAnnotation(this);
    }

    public ArgumentList getArguments() {
        return this.arguments;
    }

    public Token getAtSign() {
        return this.atSign;
    }

    @Override
    public Token getBeginToken() {
        return this.atSign;
    }

    public SimpleIdentifier getConstructorName() {
        return this.constructorName;
    }

    public Element getElement() {
        if (this.element != null) {
            return this.element;
        }
        if (this.name != null) {
            return this.name.getStaticElement();
        }
        return null;
    }

    public ElementAnnotation getElementAnnotation() {
        return this.elementAnnotation;
    }

    @Override
    public Token getEndToken() {
        if (this.arguments != null) {
            return this.arguments.getEndToken();
        }
        if (this.constructorName != null) {
            return this.constructorName.getEndToken();
        }
        return this.name.getEndToken();
    }

    public Identifier getName() {
        return this.name;
    }

    public Token getPeriod() {
        return this.period;
    }

    public void setArguments(ArgumentList argumentList) {
        this.arguments = this.becomeParentOf(argumentList);
    }

    public void setAtSign(Token token) {
        this.atSign = token;
    }

    public void setConstructorName(SimpleIdentifier simpleIdentifier) {
        this.constructorName = this.becomeParentOf(simpleIdentifier);
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public void setElementAnnotation(ElementAnnotation elementAnnotation) {
        this.elementAnnotation = elementAnnotation;
    }

    public void setName(Identifier identifier) {
        this.name = this.becomeParentOf(identifier);
    }

    public void setPeriod(Token token) {
        this.period = token;
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        this.safelyVisitChild(this.name, astVisitor);
        this.safelyVisitChild(this.constructorName, astVisitor);
        this.safelyVisitChild(this.arguments, astVisitor);
    }
}

