/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine.ast;

import com.google.dart.engine.ast.Annotation;
import com.google.dart.engine.ast.AstNode;
import com.google.dart.engine.ast.AstVisitor;
import com.google.dart.engine.ast.Comment;
import com.google.dart.engine.ast.NodeList;
import com.google.dart.engine.scanner.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AnnotatedNode
extends AstNode {
    private Comment comment;
    private NodeList<Annotation> metadata = new NodeList(this);

    public AnnotatedNode(Comment comment, List<Annotation> list) {
        this.comment = this.becomeParentOf(comment);
        this.metadata.addAll(list);
    }

    @Override
    public final Token getBeginToken() {
        if (this.comment == null) {
            if (this.metadata.isEmpty()) {
                return this.getFirstTokenAfterCommentAndMetadata();
            }
            return this.metadata.getBeginToken();
        }
        if (this.metadata.isEmpty()) {
            return this.comment.getBeginToken();
        }
        Token token = this.comment.getBeginToken();
        Token token2 = this.metadata.getBeginToken();
        if (token.getOffset() < token2.getOffset()) {
            return token;
        }
        return token2;
    }

    public Comment getDocumentationComment() {
        return this.comment;
    }

    public NodeList<Annotation> getMetadata() {
        return this.metadata;
    }

    public void setDocumentationComment(Comment comment) {
        this.comment = this.becomeParentOf(comment);
    }

    public void setMetadata(List<Annotation> list) {
        this.metadata.clear();
        this.metadata.addAll(list);
    }

    @Override
    public void visitChildren(AstVisitor<?> astVisitor) {
        if (this.commentIsBeforeAnnotations()) {
            this.safelyVisitChild(this.comment, astVisitor);
            this.metadata.accept(astVisitor);
        } else {
            for (AstNode astNode : this.getSortedCommentAndAnnotations()) {
                astNode.accept(astVisitor);
            }
        }
    }

    protected abstract Token getFirstTokenAfterCommentAndMetadata();

    private boolean commentIsBeforeAnnotations() {
        if (this.comment == null || this.metadata.isEmpty()) {
            return true;
        }
        Annotation annotation = (Annotation)this.metadata.get(0);
        return this.comment.getOffset() < annotation.getOffset();
    }

    private AstNode[] getSortedCommentAndAnnotations() {
        ArrayList<AstNode> arrayList = new ArrayList<AstNode>();
        arrayList.add(this.comment);
        arrayList.addAll(this.metadata);
        AstNode[] astNodeArray = arrayList.toArray(new AstNode[arrayList.size()]);
        Arrays.sort(astNodeArray, AstNode.LEXICAL_ORDER);
        return astNodeArray;
    }
}

