/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.engine;

import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.internal.context.DelegatingAnalysisContextImpl;
import com.google.dart.engine.internal.context.InstrumentedAnalysisContextImpl;
import com.google.dart.engine.utilities.instrumentation.Instrumentation;
import com.google.dart.engine.utilities.io.FileUtilities;
import com.google.dart.engine.utilities.logging.Logger;

public final class AnalysisEngine {
    public static final String SUFFIX_DART = "dart";
    public static final String SUFFIX_HTM = "htm";
    public static final String SUFFIX_HTML = "html";
    private static final AnalysisEngine UniqueInstance = new AnalysisEngine();
    private Logger logger = Logger.NULL;

    public static AnalysisEngine getInstance() {
        return UniqueInstance;
    }

    public static boolean isDartFileName(String string) {
        if (string == null) {
            return false;
        }
        return FileUtilities.getExtension(string).equalsIgnoreCase(SUFFIX_DART);
    }

    public static boolean isHtmlFileName(String string) {
        if (string == null) {
            return false;
        }
        String string2 = FileUtilities.getExtension(string);
        return string2.equalsIgnoreCase(SUFFIX_HTML) || string2.equalsIgnoreCase(SUFFIX_HTM);
    }

    private AnalysisEngine() {
    }

    public AnalysisContext createAnalysisContext() {
        if (Instrumentation.isNullLogger()) {
            return new DelegatingAnalysisContextImpl();
        }
        return new InstrumentedAnalysisContextImpl(new DelegatingAnalysisContextImpl());
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger == null ? Logger.NULL : logger;
    }
}

