/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.command.analyze.test;

import com.google.dart.command.analyze.AnalyzerImpl;
import com.google.dart.command.analyze.AnalyzerMain;
import com.google.dart.command.analyze.AnalyzerOptions;
import com.google.dart.command.analyze.test.BackgroundAnalyzerImpl;
import com.google.dart.command.analyze.test.PerformanceMonitor;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeSet;

public class BackgroundAnalyzerPerformanceTest
extends AnalyzerMain {
    private BackgroundAnalyzerImpl analyzer;

    public static void main(String[] stringArray) {
        new BackgroundAnalyzerPerformanceTest().run(stringArray);
    }

    @Override
    protected String getProgramName() {
        return BackgroundAnalyzerPerformanceTest.class.getSimpleName();
    }

    @Override
    protected AnalyzerImpl newAnalyzer(AnalyzerOptions analyzerOptions) {
        this.analyzer = new BackgroundAnalyzerImpl(analyzerOptions);
        return this.analyzer;
    }

    @Override
    protected void showPerformanceResults(long l) {
        super.showPerformanceResults(l);
        Collection<PerformanceMonitor> collection = this.analyzer.getPerformanceMonitors();
        TreeSet<PerformanceMonitor> treeSet = new TreeSet<PerformanceMonitor>(new Comparator<PerformanceMonitor>(){

            @Override
            public int compare(PerformanceMonitor performanceMonitor, PerformanceMonitor performanceMonitor2) {
                return performanceMonitor.getName().compareTo(performanceMonitor2.getName());
            }
        });
        treeSet.addAll(collection);
        for (PerformanceMonitor performanceMonitor : treeSet) {
            System.out.println();
            System.out.println(performanceMonitor.getName() + " Max: " + performanceMonitor.getMax());
            System.out.println(performanceMonitor.getName() + " Average: " + performanceMonitor.getAverage());
            System.out.println(performanceMonitor.getName() + " Min: " + performanceMonitor.getMin());
            System.out.println(performanceMonitor.getName() + " Count: " + performanceMonitor.getCount());
        }
    }
}

