/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.command.analyze.test;

import com.google.dart.command.analyze.AnalyzerImpl;
import com.google.dart.command.analyze.AnalyzerOptions;
import com.google.dart.command.analyze.test.ClientPerformanceTest;
import com.google.dart.command.analyze.test.PerformanceMonitor;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.context.AnalysisResult;
import com.google.dart.engine.context.ChangeNotice;
import com.google.dart.engine.context.ChangeSet;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.general.TimeCounter;
import com.google.dart.engine.utilities.source.LineInfo;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BackgroundAnalyzerImpl
extends AnalyzerImpl {
    private static final String TASK_PACKAGE_NAME = "com.google.dart.engine.internal.task.";
    private final PerformanceMonitor getKindOfPM = new PerformanceMonitor("getKindOf");
    private final PerformanceMonitor getTaskPM = new PerformanceMonitor("getAnalysisTask");
    private final PerformanceMonitor performTaskPM = new PerformanceMonitor("performAnalysisTask");
    private HashMap<String, PerformanceMonitor> allMonitors = new HashMap();
    private final ClientPerformanceTest client;

    public BackgroundAnalyzerImpl(AnalyzerOptions analyzerOptions) {
        super(analyzerOptions);
        this.allMonitors.put(this.getKindOfPM.getName(), this.getKindOfPM);
        this.allMonitors.put(this.getTaskPM.getName(), this.getTaskPM);
        this.allMonitors.put(this.performTaskPM.getName(), this.performTaskPM);
        this.client = new ClientPerformanceTest(this.getKindOfPM);
    }

    public Collection<PerformanceMonitor> getPerformanceMonitors() {
        return this.allMonitors.values();
    }

    @Override
    protected ErrorSeverity performAnalysis(AnalysisContext analysisContext, Source source, File file, Map<Source, LineInfo> map, List<AnalysisError> list) throws AnalysisException {
        ChangeSet changeSet = new ChangeSet();
        changeSet.addedSource(source);
        analysisContext.applyChanges(changeSet);
        this.client.start(analysisContext, source);
        block0: while (true) {
            ChangeNotice[] changeNoticeArray;
            long l;
            TimeCounter.TimeCounterHandle timeCounterHandle = this.performTaskPM.start();
            AnalysisResult analysisResult = analysisContext.performAnalysisTask();
            timeCounterHandle.stop();
            this.getTaskPM.recordElapsedMillis(analysisResult.getGetTime());
            String string = analysisResult.getTaskClassName();
            if (string != null && (l = analysisResult.getPerformTime()) >= 0L) {
                PerformanceMonitor performanceMonitor = this.allMonitors.get(string);
                if (performanceMonitor == null) {
                    String string2 = string;
                    if (string2.startsWith(TASK_PACKAGE_NAME)) {
                        string2 = string2.substring(TASK_PACKAGE_NAME.length());
                    }
                    performanceMonitor = new PerformanceMonitor(string2);
                    this.allMonitors.put(string, performanceMonitor);
                }
                performanceMonitor.recordElapsedMillis(l);
            }
            if ((changeNoticeArray = analysisResult.getChangeNotices()) == null) break;
            ChangeNotice[] changeNoticeArray2 = changeNoticeArray;
            int n = changeNoticeArray2.length;
            int n2 = 0;
            while (true) {
                AnalysisError[] analysisErrorArray;
                if (n2 >= n) continue block0;
                ChangeNotice changeNotice = changeNoticeArray2[n2];
                Source source2 = changeNotice.getSource();
                if (source2 != null && (analysisErrorArray = changeNotice.getLineInfo()) != null) {
                    map.put(source2, (LineInfo)analysisErrorArray);
                }
                if ((analysisErrorArray = changeNotice.getErrors()) != null) {
                    list.addAll(Arrays.asList(analysisErrorArray));
                }
                ++n2;
            }
            break;
        }
        this.client.stop();
        return this.getMaxErrorSeverity(list);
    }
}

