/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.command.analyze;

import com.google.dart.command.analyze.AnalyzerOptions;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.error.ErrorType;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.source.LineInfo;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class ErrorFormatter {
    private PrintStream out;
    private AnalyzerOptions options;
    private Map<Source, LineInfo> lineInfoMap;

    private static String escapePipe(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (char c : string.toCharArray()) {
            if (c == '\\' || c == '|') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static String pluralize(String string, int n) {
        if (n == 1) {
            return string;
        }
        return string + "s";
    }

    public ErrorFormatter(PrintStream printStream, AnalyzerOptions analyzerOptions, Map<Source, LineInfo> map) {
        this.out = printStream;
        this.options = analyzerOptions;
        this.lineInfoMap = map;
    }

    public void formatError(AnalysisError analysisError) {
        Source source = analysisError.getSource();
        LineInfo.Location location = this.getLocation(source, analysisError.getOffset());
        int n = analysisError.getLength();
        if (this.options.getMachineFormat()) {
            this.out.println(String.format("%s|%s|%s|%s|%d|%d|%d|%s", this.getMachineCode(analysisError.getErrorCode().getErrorSeverity(), this.options.getWarningsAreFatal()), ErrorFormatter.escapePipe(analysisError.getErrorCode().getType().toString()), ErrorFormatter.escapePipe(analysisError.getErrorCode().toString()), ErrorFormatter.escapePipe(source.getFullName()), location.getLineNumber(), location.getColumnNumber(), n, ErrorFormatter.escapePipe(analysisError.getMessage())));
        } else {
            String string = analysisError.getErrorCode().getErrorSeverity().getDisplayName();
            if (analysisError.getErrorCode().getType() == ErrorType.HINT) {
                string = analysisError.getErrorCode().getType().getDisplayName();
            }
            this.out.println(String.format("[%s] %s (%s, line %d, col %d)", string, analysisError.getMessage(), source.getFullName(), location.getLineNumber(), location.getColumnNumber()));
        }
    }

    public void formatErrors(List<AnalysisError> list) {
        Collections.sort(list, new AnalysisErrorComparator());
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (AnalysisError analysisError : list) {
            ErrorSeverity errorSeverity = analysisError.getErrorCode().getErrorSeverity();
            if (errorSeverity.equals((Object)ErrorSeverity.ERROR)) {
                ++n;
            } else if (errorSeverity.equals((Object)ErrorSeverity.WARNING)) {
                if (this.options.getWarningsAreFatal()) {
                    ++n;
                } else if (analysisError.getErrorCode().getType() == ErrorType.HINT) {
                    ++n3;
                } else {
                    ++n2;
                }
            } else if (errorSeverity.equals((Object)ErrorSeverity.INFO)) {
                ++n3;
            }
            this.formatError(analysisError);
        }
        if (!this.options.getMachineFormat()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (n != 0) {
                stringBuffer.append(String.format("%d %s", n, ErrorFormatter.pluralize("error", n)));
            }
            if (n2 != 0) {
                if (stringBuffer.length() > 0) {
                    if (n3 == 0) {
                        stringBuffer.append(" and ");
                    } else {
                        stringBuffer.append(", ");
                    }
                }
                stringBuffer.append(String.format("%d %s", n2, ErrorFormatter.pluralize("warning", n2)));
            }
            if (n3 != 0) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", and ");
                }
                stringBuffer.append(String.format("%d %s", n3, ErrorFormatter.pluralize("hint", n3)));
            }
            if (stringBuffer.length() != 0) {
                stringBuffer.append(" found.");
            } else {
                stringBuffer.append("No issues found");
            }
            this.out.println(stringBuffer.toString());
        }
    }

    public void startAnalysis() {
        if (!this.options.getMachineFormat()) {
            this.out.println("Analyzing " + this.options.getSourceFile() + "...");
        }
    }

    LineInfo.Location getLocation(Source source, int n) {
        LineInfo lineInfo = this.lineInfoMap.get(source);
        if (lineInfo == null) {
            return new LineInfo.Location(-1, -1);
        }
        return lineInfo.getLocation(n);
    }

    private String getMachineCode(ErrorSeverity errorSeverity, boolean bl) {
        if (errorSeverity.equals((Object)ErrorSeverity.WARNING) && bl) {
            return ErrorSeverity.ERROR.name();
        }
        return errorSeverity.name();
    }

    static class AnalysisErrorComparator
    implements Comparator<AnalysisError> {
        AnalysisErrorComparator() {
        }

        @Override
        public int compare(AnalysisError analysisError, AnalysisError analysisError2) {
            int n = analysisError.getErrorCode().getErrorSeverity().compareTo(analysisError2.getErrorCode().getErrorSeverity());
            if (n != 0) {
                return -1 * n;
            }
            n = analysisError.getSource().getFullName().compareToIgnoreCase(analysisError2.getSource().getFullName());
            if (n != 0) {
                return n;
            }
            return analysisError.getOffset() - analysisError2.getOffset();
        }
    }
}

