/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.command.analyze;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class AnalyzerOptions {
    @Option(name="--machine", usage="Print errors in a format suitable for parsing")
    private boolean machineFormat = false;
    @Option(name="--format", usage="Print errors in the specified format")
    private AnalyzerOutputFormat outputFormat = null;
    @Option(name="--help", aliases={"-h"}, usage="Prints this help message")
    private boolean showHelp = false;
    @Option(name="--version", usage="Print the analyzer version")
    private boolean showVersion = false;
    @Option(name="--dart-sdk", metaVar="<dir>")
    private File dartSdkPath = null;
    @Option(name="--use-dart2js-libraries")
    private boolean useDart2jsPaths = false;
    @Option(name="--verbose", aliases={"-v"})
    private boolean enableVerbose = false;
    @Option(name="--package-root", aliases={"-p"}, metaVar="<dir>", usage="The path to the package root")
    private File packageRootPath = null;
    @Option(name="--use-package-map")
    private boolean usePackageMap = false;
    @Option(name="--package-warnings", aliases={"--show-package-warnings"}, usage="Show warnings from package: imports")
    private boolean showPackageWarnings = false;
    @Option(name="--batch", aliases={"-batch"})
    private boolean batch = false;
    @Option(name="--warnings", aliases={"--show-sdk-warnings"})
    private boolean showSdkWarnings = false;
    @Option(name="--fatal-warnings")
    private boolean warningsAreFatal = false;
    @Option(name="--fatal-type-errors")
    private boolean fatalTypeError = false;
    @Option(name="--ignore-unrecognized-flags")
    private boolean ignoreUnrecognizedFlags;
    @Option(name="--no-hints", usage="Do not show hint results")
    private boolean disableHints = false;
    @Option(name="--perf", usage="Print performance statistics")
    private boolean perf = false;
    @Option(name="--diagnostic-colors")
    private boolean diagnosticColors = false;
    @Argument
    private final String sourceFile;

    public static AnalyzerOptions createFromArgs(String[] stringArray) {
        stringArray = AnalyzerOptions.processArgs(stringArray);
        AnalyzerOptions analyzerOptions = new AnalyzerOptions();
        CmdLineParser cmdLineParser = new CmdLineParser(analyzerOptions);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            try {
                cmdLineParser.parseArgument(stringArray);
                break;
            }
            catch (CmdLineException cmdLineException) {
                String string = cmdLineException.getMessage();
                if (!cmdLineException.getMessage().endsWith(" is not a valid option")) break;
                String string2 = string.substring(1);
                int n2 = string2.indexOf(34);
                string2 = string2.substring(0, n2);
                ArrayList<String> arrayList = Lists.newArrayList();
                for (String string3 : stringArray) {
                    if (string3.equals(string2)) {
                        System.out.println("Ignoring unrecognized flag: " + string3);
                        continue;
                    }
                    arrayList.add(string3);
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
                cmdLineParser = new CmdLineParser(analyzerOptions);
                continue;
            }
        }
        return analyzerOptions;
    }

    public static void printUsage(PrintStream printStream) {
        AnalyzerOptions analyzerOptions = new AnalyzerOptions();
        CmdLineParser cmdLineParser = new CmdLineParser(analyzerOptions);
        cmdLineParser.setUsageWidth(120);
        cmdLineParser.printUsage(printStream);
    }

    private static String[] processArgs(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string.isEmpty()) continue;
            if (string.indexOf(61) != -1) {
                String[] stringArray2 = string.split("=");
                arrayList.add(stringArray2[0]);
                arrayList.add(stringArray2[1]);
                continue;
            }
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public AnalyzerOptions() {
        this.sourceFile = null;
    }

    public File getDartSdkPath() {
        return this.dartSdkPath;
    }

    public boolean getDisableHints() {
        return this.disableHints;
    }

    public boolean getMachineFormat() {
        return this.machineFormat || this.outputFormat == AnalyzerOutputFormat.MACHINE;
    }

    public File getPackageRootPath() {
        return this.packageRootPath;
    }

    public boolean getPerf() {
        return this.perf;
    }

    public boolean getShowPackageWarnings() {
        return this.showPackageWarnings;
    }

    public boolean getShowSdkWarnings() {
        return this.showSdkWarnings;
    }

    public boolean getShowVersion() {
        return this.showVersion;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public boolean getUseDart2jsPaths() {
        return this.useDart2jsPaths;
    }

    public boolean getUsePackageMap() {
        return this.usePackageMap;
    }

    public boolean getWarningsAreFatal() {
        return this.warningsAreFatal;
    }

    public void initializeSdkPath() {
        String[] stringArray = new String[]{".", "..", "sdk"};
        if (this.dartSdkPath == null) {
            try {
                File file = new File(".").getCanonicalFile();
                for (String string : stringArray) {
                    File file2 = new File(file, string);
                    if (!this.isSDKPath(file2 = file2.getCanonicalFile())) continue;
                    this.dartSdkPath = file2;
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void setDartSdkPath(File file) {
        this.dartSdkPath = file;
    }

    public void setWarningsAreFatal(boolean bl) {
        this.warningsAreFatal = bl;
    }

    public boolean shouldBatch() {
        return this.batch;
    }

    public boolean showHelp() {
        return this.showHelp;
    }

    private boolean isSDKPath(File file) {
        File file2;
        if (!file.exists()) {
            return false;
        }
        if (!file.getName().equals("dart-sdk") && !file.getName().equals("sdk")) {
            return false;
        }
        if (new File(file, "version").exists()) {
            return true;
        }
        File file3 = new File(file, "lib");
        return file3.exists() && (file2 = new File(file3, "_internal")).exists() && new File(file2, "libraries.dart").exists();
    }

    static enum AnalyzerOutputFormat {
        MACHINE;

    }
}

