/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.command.analyze;

import com.google.dart.command.analyze.AnalyzerImpl;
import com.google.dart.command.analyze.AnalyzerOptions;
import com.google.dart.command.analyze.BatchRunner;
import com.google.dart.command.analyze.ErrorFormatter;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.internal.context.PerformanceStatistics;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.utilities.source.LineInfo;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;

public class AnalyzerMain {
    public static String getBuildVersion() {
        Package package_ = AnalyzerMain.class.getPackage();
        if (package_.getImplementationVersion() == null) {
            return "0.0.0";
        }
        return package_.getImplementationVersion();
    }

    public static void main(String[] stringArray) {
        new AnalyzerMain().run(stringArray);
    }

    private static int getReturnCode(ErrorSeverity errorSeverity) {
        if (errorSeverity == ErrorSeverity.WARNING) {
            return 1;
        }
        if (errorSeverity == ErrorSeverity.ERROR) {
            return 2;
        }
        return 0;
    }

    protected void crashAndExit() {
        System.exit(253);
    }

    protected String getProgramName() {
        return "dartanalyzer";
    }

    protected AnalyzerImpl newAnalyzer(AnalyzerOptions analyzerOptions) {
        return new AnalyzerImpl(analyzerOptions);
    }

    protected void run(String[] stringArray) {
        final AnalyzerOptions analyzerOptions = AnalyzerOptions.createFromArgs(stringArray);
        analyzerOptions.initializeSdkPath();
        if (stringArray.length == 0 || analyzerOptions.showHelp()) {
            this.showVersion(analyzerOptions, System.out);
            System.out.println();
            this.showUsage(System.out);
            System.out.println("For more information, see http://www.dartlang.org/tools/analyzer.");
            System.exit(0);
        }
        if (analyzerOptions.getShowVersion()) {
            this.showVersion(analyzerOptions, System.out);
            System.exit(0);
        }
        if (analyzerOptions.getDartSdkPath() == null) {
            System.out.println(this.getProgramName() + ": no Dart SDK found.");
            this.showUsage(System.out);
            System.exit(1);
        }
        if (!analyzerOptions.getDartSdkPath().exists()) {
            System.out.println(this.getProgramName() + ": invalid Dart SDK path: " + analyzerOptions.getDartSdkPath());
            this.showUsage(System.out);
            System.exit(1);
        }
        try {
            if (analyzerOptions.shouldBatch()) {
                ErrorSeverity errorSeverity = BatchRunner.runAsBatch(stringArray, new BatchRunner.BatchRunnerInvocation(){

                    @Override
                    public ErrorSeverity invoke(String[] stringArray) throws Throwable {
                        AnalyzerOptions analyzerOptions2 = AnalyzerOptions.createFromArgs(stringArray);
                        if (analyzerOptions2.getDartSdkPath() == null) {
                            analyzerOptions2.setDartSdkPath(analyzerOptions.getDartSdkPath());
                        }
                        if (analyzerOptions.getWarningsAreFatal()) {
                            analyzerOptions2.setWarningsAreFatal(true);
                        }
                        return AnalyzerMain.this.runAnalyzer(analyzerOptions2);
                    }
                });
                if (errorSeverity != ErrorSeverity.NONE) {
                    System.exit(AnalyzerMain.getReturnCode(errorSeverity));
                }
            } else {
                ErrorSeverity errorSeverity;
                String string = analyzerOptions.getSourceFile();
                if (string == null) {
                    System.out.println(this.getProgramName() + ": no source files were specified.");
                    this.showUsage(System.out);
                    System.exit(1);
                }
                if ((errorSeverity = this.runAnalyzer(analyzerOptions)) != ErrorSeverity.NONE) {
                    System.exit(AnalyzerMain.getReturnCode(errorSeverity));
                }
            }
        }
        catch (AnalysisException analysisException) {
            System.err.println("Error: " + analysisException.getMessage());
            this.crashAndExit();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            this.crashAndExit();
        }
    }

    protected ErrorSeverity runAnalyzer(AnalyzerOptions analyzerOptions) throws IOException, AnalysisException {
        File file = new File(analyzerOptions.getSourceFile());
        if (!file.exists()) {
            System.out.println("File not found: " + file);
            System.out.println();
            this.showUsage(System.out);
            return ErrorSeverity.ERROR;
        }
        if (!AnalysisEngine.isDartFileName(file.getName())) {
            System.out.println(file + " is not a Dart file");
            System.out.println();
            this.showUsage(System.out);
            return ErrorSeverity.ERROR;
        }
        ArrayList<AnalysisError> arrayList = new ArrayList<AnalysisError>();
        HashMap<Source, LineInfo> hashMap = new HashMap<Source, LineInfo>();
        ErrorFormatter errorFormatter = new ErrorFormatter(analyzerOptions.getMachineFormat() ? System.err : System.out, analyzerOptions, hashMap);
        errorFormatter.startAnalysis();
        long l = System.currentTimeMillis();
        AnalyzerImpl analyzerImpl = this.newAnalyzer(analyzerOptions);
        ErrorSeverity errorSeverity = analyzerImpl.analyze(file, arrayList, hashMap);
        errorFormatter.formatErrors(arrayList);
        if (errorSeverity.equals((Object)ErrorSeverity.WARNING) && analyzerOptions.getWarningsAreFatal()) {
            errorSeverity = ErrorSeverity.ERROR;
        }
        if (analyzerOptions.getPerf()) {
            this.showPerformanceResults(l);
        }
        return errorSeverity;
    }

    protected void showPerformanceResults(long l) {
        long l2 = System.currentTimeMillis() - l;
        long l3 = PerformanceStatistics.io.getResult();
        long l4 = PerformanceStatistics.scan.getResult();
        long l5 = PerformanceStatistics.parse.getResult();
        long l6 = PerformanceStatistics.resolve.getResult();
        long l7 = PerformanceStatistics.errors.getResult();
        long l8 = PerformanceStatistics.hints.getResult();
        long l9 = PerformanceStatistics.angular.getResult();
        System.out.println("io:" + l3);
        System.out.println("scan:" + l4);
        System.out.println("parse:" + l5);
        System.out.println("resolve:" + l6);
        System.out.println("errors:" + l7);
        System.out.println("hints:" + l8);
        System.out.println("angular:" + l9);
        System.out.println("other:" + (l2 - (l3 + l4 + l5 + l6 + l7 + l8 + l9)));
        System.out.println("total:" + l2);
    }

    private void showUsage(PrintStream printStream) {
        printStream.println("Usage: " + this.getProgramName() + " [<options>] <dart-script>");
        printStream.println();
        printStream.println("Options:");
        AnalyzerOptions.printUsage(printStream);
        printStream.println();
        printStream.println("Exit codes:");
        printStream.println(" 0: No analysis issues found");
        printStream.println(" 1: Analysis warnings encountered");
        printStream.println(" 2: Analysis errors encountered");
        printStream.println();
    }

    private void showVersion(AnalyzerOptions analyzerOptions, PrintStream printStream) {
        printStream.println(this.getProgramName() + " version " + AnalyzerMain.getBuildVersion());
    }
}

