/*
 * Decompiled with CFR 0.152.
 */
package com.google.dart.command.analyze;

import com.google.dart.command.analyze.AnalyzerOptions;
import com.google.dart.engine.AnalysisEngine;
import com.google.dart.engine.context.AnalysisContext;
import com.google.dart.engine.context.AnalysisException;
import com.google.dart.engine.element.CompilationUnitElement;
import com.google.dart.engine.element.Element;
import com.google.dart.engine.element.LibraryElement;
import com.google.dart.engine.error.AnalysisError;
import com.google.dart.engine.error.ErrorSeverity;
import com.google.dart.engine.error.ErrorType;
import com.google.dart.engine.internal.context.AnalysisOptionsImpl;
import com.google.dart.engine.sdk.DirectoryBasedDartSdk;
import com.google.dart.engine.source.DartUriResolver;
import com.google.dart.engine.source.ExplicitPackageUriResolver;
import com.google.dart.engine.source.FileBasedSource;
import com.google.dart.engine.source.FileUriResolver;
import com.google.dart.engine.source.PackageUriResolver;
import com.google.dart.engine.source.Source;
import com.google.dart.engine.source.SourceFactory;
import com.google.dart.engine.source.SourceKind;
import com.google.dart.engine.source.UriKind;
import com.google.dart.engine.utilities.source.LineInfo;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AnalyzerImpl {
    private static final int MAX_CACHE_SIZE = 256;
    private static final HashMap<File, DirectoryBasedDartSdk> sdkMap = new HashMap();
    private AnalyzerOptions options;
    private DirectoryBasedDartSdk sdk;

    private static DirectoryBasedDartSdk getSdk(File file, boolean bl) {
        DirectoryBasedDartSdk directoryBasedDartSdk = sdkMap.get(file);
        if (directoryBasedDartSdk == null) {
            directoryBasedDartSdk = new DirectoryBasedDartSdk(file, bl);
            sdkMap.put(file, directoryBasedDartSdk);
        }
        return directoryBasedDartSdk;
    }

    public AnalyzerImpl(AnalyzerOptions analyzerOptions) {
        this.options = analyzerOptions;
        this.sdk = AnalyzerImpl.getSdk(analyzerOptions.getDartSdkPath(), analyzerOptions.getUseDart2jsPaths());
    }

    public ErrorSeverity analyze(File file, List<AnalysisError> list, Map<Source, LineInfo> map) throws IOException, AnalysisException {
        if (file == null) {
            throw new IllegalArgumentException("sourceFile cannot be null");
        }
        AnalysisOptionsImpl analysisOptionsImpl = new AnalysisOptionsImpl();
        analysisOptionsImpl.setCacheSize(256);
        analysisOptionsImpl.setHint(!this.options.getDisableHints());
        AnalysisContext analysisContext = AnalysisEngine.getInstance().createAnalysisContext();
        analysisContext.setSourceFactory(this.createSourceFactory(file));
        analysisContext.setAnalysisOptions(analysisOptionsImpl);
        file = file.getAbsoluteFile();
        UriKind uriKind = this.getUriKind(file);
        FileBasedSource fileBasedSource = new FileBasedSource(file, uriKind);
        return this.performAnalysis(analysisContext, fileBasedSource, file, map, list);
    }

    protected ErrorSeverity getMaxErrorSeverity(List<AnalysisError> list) {
        ErrorSeverity errorSeverity = ErrorSeverity.NONE;
        for (AnalysisError analysisError : list) {
            ErrorSeverity errorSeverity2 = analysisError.getErrorCode().getErrorSeverity();
            errorSeverity = errorSeverity.max(errorSeverity2);
        }
        return errorSeverity;
    }

    protected ErrorSeverity performAnalysis(AnalysisContext analysisContext, Source source, File file, Map<Source, LineInfo> map, List<AnalysisError> list) throws AnalysisException {
        if (analysisContext.computeKindOf(source) == SourceKind.PART) {
            System.err.println("Only libraries can be analyzed.");
            System.err.println(file + " is a part and can not be analyzed.");
            return ErrorSeverity.NONE;
        }
        LibraryElement libraryElement = analysisContext.computeLibraryElement(source);
        analysisContext.resolveCompilationUnit(source, libraryElement);
        Set<Source> set = this.getAllSources(libraryElement);
        this.getAllErrors(analysisContext, set, list, map);
        this.filterOutTodos(list);
        if (this.options.getDisableHints()) {
            this.filterOutHints(list);
        }
        return this.getMaxErrorSeverity(list);
    }

    Set<Source> getAllSources(LibraryElement libraryElement) {
        HashSet<CompilationUnitElement> hashSet = new HashSet<CompilationUnitElement>();
        HashSet<LibraryElement> hashSet2 = new HashSet<LibraryElement>();
        HashSet<Source> hashSet3 = new HashSet<Source>();
        this.addLibrary(libraryElement, hashSet2, hashSet, hashSet3);
        return hashSet3;
    }

    private void addCompilationUnit(CompilationUnitElement compilationUnitElement, Set<LibraryElement> set, Set<CompilationUnitElement> set2, Set<Source> set3) {
        if (compilationUnitElement == null || set2.contains(compilationUnitElement)) {
            return;
        }
        set2.add(compilationUnitElement);
        set3.add(compilationUnitElement.getSource());
    }

    private void addLibrary(LibraryElement libraryElement, Set<LibraryElement> set, Set<CompilationUnitElement> set2, Set<Source> set3) {
        if (libraryElement == null || set.contains(libraryElement)) {
            return;
        }
        UriKind uriKind = libraryElement.getSource().getUriKind();
        if (!this.options.getShowPackageWarnings() && uriKind == UriKind.PACKAGE_URI) {
            return;
        }
        if (!this.options.getShowSdkWarnings() && uriKind == UriKind.DART_URI) {
            return;
        }
        set.add(libraryElement);
        this.addCompilationUnit(libraryElement.getDefiningCompilationUnit(), set, set2, set3);
        for (CompilationUnitElement element : libraryElement.getParts()) {
            this.addCompilationUnit(element, set, set2, set3);
        }
        for (Element element : libraryElement.getImportedLibraries()) {
            this.addLibrary((LibraryElement)element, set, set2, set3);
        }
        for (Element element : libraryElement.getExportedLibraries()) {
            this.addLibrary((LibraryElement)element, set, set2, set3);
        }
    }

    private SourceFactory createSourceFactory(File file) {
        File file2 = this.getPackageDirectory(file);
        if (this.options.getUsePackageMap()) {
            return new SourceFactory(new DartUriResolver(this.sdk), new FileUriResolver(), new ExplicitPackageUriResolver(this.sdk, this.getPubDir(file)));
        }
        if (file2 != null) {
            return new SourceFactory(new DartUriResolver(this.sdk), new FileUriResolver(), new PackageUriResolver(file2.getAbsoluteFile()));
        }
        return new SourceFactory(new DartUriResolver(this.sdk), new FileUriResolver());
    }

    private void filterOutHints(List<AnalysisError> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            AnalysisError analysisError = list.get(i);
            if (analysisError.getErrorCode().getType() != ErrorType.HINT) continue;
            list.remove(i);
        }
    }

    private void filterOutTodos(List<AnalysisError> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            AnalysisError analysisError = list.get(i);
            if (analysisError.getErrorCode().getType() != ErrorType.TODO) continue;
            list.remove(i);
        }
    }

    private void getAllErrors(AnalysisContext analysisContext, Set<Source> set, List<AnalysisError> list, Map<Source, LineInfo> map) throws AnalysisException {
        for (Source source : set) {
            AnalysisError[] analysisErrorArray = analysisContext.computeErrors(source);
            if (analysisErrorArray.length <= 0) continue;
            list.addAll(Arrays.asList(analysisErrorArray));
            LineInfo lineInfo = analysisContext.getLineInfo(source);
            if (lineInfo == null) {
                lineInfo = new LineInfo(new int[]{0});
            }
            map.put(source, lineInfo);
        }
    }

    private File getPackageDirectory(File file) {
        if (this.options.getPackageRootPath() != null) {
            return this.options.getPackageRootPath();
        }
        return this.getPackageDirectoryFor(file);
    }

    private File getPackageDirectoryFor(File file) {
        file = file.getAbsoluteFile();
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            File file3 = new File(file2, "packages");
            if (!file3.exists()) continue;
            return file3;
        }
        return null;
    }

    private File getPubDir(File file) {
        file = file.getAbsoluteFile();
        for (File file2 = file.getParentFile(); file2 != null; file2 = file2.getParentFile()) {
            File file3 = new File(file2, "pubspec.yaml");
            if (!file3.exists()) continue;
            return file2;
        }
        return new File(System.getProperty("user.dir"));
    }

    private UriKind getUriKind(File file) {
        if (this.sdk instanceof DirectoryBasedDartSdk) {
            String string;
            DirectoryBasedDartSdk directoryBasedDartSdk = this.sdk;
            File file2 = directoryBasedDartSdk.getLibraryDirectory();
            String string2 = file2.getPath() + File.separator;
            String string3 = file.getPath();
            if (string3.startsWith(string2) && !string3.startsWith(string = new File(file2, "_internal").getPath() + File.separator)) {
                return UriKind.DART_URI;
            }
        }
        return UriKind.FILE_URI;
    }
}

