/**
 *  Copyright 2002-2006 Peter Seiderer <Peter.Seiderer@ciselant.de>
 *
 *  This file is part of SeBIE.
 *
 *  SeBIE is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  SeBIE is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with SeBIE; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef _SEBIE_H_
#define _SEBIE_H_  1

#include <gtk/gtk.h>
#include <gdk/gdk.h>

#include <sys/types.h>
#include <regex.h>

typedef enum sebie_rotation_e {
  SEBIE_ROTATE_000 = 0,
  SEBIE_ROTATE_090 = 1,
  SEBIE_ROTATE_180 = 2,
  SEBIE_ROTATE_270 = 3,
  SEBIE_ROTATE_360 = 4
} sebie_rotation;

typedef enum sebie_dirty_tag_e {
  SEBIE_UPDATE_SCALED_PIXBUF    =    1,
  SEBIE_UPDATE_SELECTION_FAC    =    2,
  SEBIE_UPDATE_SELECTION_FAC_W  =    4,
  SEBIE_UPDATE_SELECTION_FAC_H  =    8,
  SEBIE_UPDATE_SELECTION_RECT   =   16,
  SEBIE_UPDATE_INPUT_PATH       =   32,
  SEBIE_UPDATE_INPUT_REGEX      =   64,
  SEBIE_UPDATE_OUTPUT_FORMAT    =  128,
  SEBIE_UPDATE_OUTPUT_FILE_NAME =  256,
  SEBIE_UPDATE_STATUS_BAR       =  512,
  SEBIE_UPDATE_IMAGE_GAMMA      = 1024
} sebie_dirty_tag;

typedef enum sebie_model_tag_e {
  SEBIE_MODEL_INPUT_PATH             =   1,
  SEBIE_MODEL_INPUT_REGEX            =   2,
  SEBIE_MODEL_OUTPUT_FORMAT          =   4,
  SEBIE_MODEL_UPDATE_SELECTION_FAC   =   8,
  SEBIE_MODEL_UPDATE_GAMMA           =  16,
  SEBIE_MODEL_UPDATE_GRAYSCALE       =  32,
  SEBIE_MODEL_CHANGE_PIXBUF_SIZE     =  64
} sebie_model_tag;

typedef enum sebie_mouse_click_e {
  SEBIE_NOT_CLICKED      = 0,
  SEBIE_RESIZE_SELECTION = 1, 
  SEBIE_MOVE_SELECTION   = 2
} sebie_mouse_click_type;

typedef enum sebie_resize_corner_e {
  SEBIE_UPPER_LEFT_CORNER,
  SEBIE_UPPER_RIGHT_CORNER,
  SEBIE_LOWER_RIGHT_CORNER,
  SEBIE_LOWER_LEFT_CORNER
} sebie_resize_corner_type;

typedef struct sebie_view_s {
  GtkWidget *window1;
  GtkWidget *vbox1;
  GtkWidget *toolbar1;
  GtkWidget *tmp_toolbar_icon;
  GtkWidget *button_quit;
  //GtkWidget *button_load;
  GtkWidget *button_save;
  GtkWidget *button_rotate_left;
  GtkWidget *button_rotate_right;
  GtkWidget *label_selection_fac_width;
  GtkWidget *entry_selection_fac_width;
  GtkWidget *label_selection_fac_height;
  GtkWidget *entry_selection_fac_height;
  GtkWidget *button_fac_swap;
  GtkWidget *label_selection_fac;
  GtkWidget *label_selection_gamma;
  GtkWidget *entry_selection_gamma;
  GtkWidget *button_grayscale;
  GtkWidget *hpaned1;
  GtkWidget *vbox2;
  GtkWidget *label_input_path;
  GtkWidget *entry_input_path;
  GtkWidget *label_input_regex;
  GtkWidget *entry_input_regex;
  GtkWidget *label_output_format;
  GtkWidget *entry_output_format;
  GtkWidget *label_output_file;
  GtkWidget *entry_output_file;
  GtkWidget *scrolledwindow1;
  GtkWidget *treeview_file_list;
  GtkWidget *drawingarea1;
  GtkWidget *statusbar1;
  guint statusbar1_context_id;
} sebie_view;

typedef struct sebie_model_s {
  /* file selector */
  char *input_path;
  char *input_regex;
  char *output_format;
  char *input_file_name;
  char *output_file_name;
  char *input_file_path;
  char *output_file_path;
  regex_t regex;
  int regex_status;
  GtkListStore *file_list;
  /* orig image */
  char *image_file_name;
  GdkPixbuf *image_pixbuf;
  gint image_width;
  gint image_height;
  /* the scaled one for the preview */
  double scaled_scale;
  /* here is the original scaled pixbuf stored */
  GdkPixbuf *scaled_pixbuf_orig;
  gint window1_width;
  gint window1_height;
  gint pixbuf_width;
  gint pixbuf_height;
  /* and here the one with the color corrections applied,
   * which is drawed to the screen */
  GdkPixbuf *scaled_pixbuf;
  gint scaled_width;
  gint scaled_height;
  sebie_rotation scaled_rotation;
  gdouble image_gamma;
  gint image_grayscale;
  /* the selection */
  sebie_mouse_click_type mouse_click_type;
  sebie_resize_corner_type resize_corner;
  gint mouse_pos_lx;
  gint mouse_pos_ly;
  gint selection_x;
  gint selection_y;
  gint selection_width;
  gint selection_height;
  gint selection_fac_width;
  gint selection_fac_height;
  gdouble selection_fac;
  /* the status bar text */
  gchar *statusbar_text;
} sebie_model;


typedef struct sebie_s {
  sebie_view  view;
  sebie_model model;
  sebie_dirty_tag dirty_tags;
  sebie_model_tag model_tags;
  char *config_file;
} struct_sebie;


void sebie_update_view(struct sebie_s *sebie);
void sebie_error_popup(struct sebie_s *sebie, gchar *error_str);
void load_pixbuf (struct sebie_s *sebie);
void sebie_update_file_list(struct sebie_s *sebie);
void rotate_scaled(struct sebie_s *sebie, int direction);
void apply_color_corrections(struct sebie_s *sebie);
void save_sebie_config(struct sebie_s *sebie);

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#endif
