/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.regexp;

import jdk.nashorn.internal.runtime.ParserException;
import jdk.nashorn.internal.runtime.options.Options;
import jdk.nashorn.internal.runtime.regexp.JdkRegExp;
import jdk.nashorn.internal.runtime.regexp.JoniRegExp;
import jdk.nashorn.internal.runtime.regexp.RegExp;

public class RegExpFactory {
    private static final RegExpFactory instance;
    private static final String JDK = "jdk";
    private static final String JONI = "joni";

    public RegExp compile(String pattern, String flags) throws ParserException {
        return new JdkRegExp(pattern, flags);
    }

    public static RegExp create(String pattern, String flags) {
        return instance.compile(pattern, flags);
    }

    public static void validate(String pattern, String flags) throws ParserException {
        instance.compile(pattern, flags);
    }

    public static boolean usesJavaUtilRegex() {
        return instance != null && instance.getClass() == RegExpFactory.class;
    }

    static {
        String impl;
        switch (impl = Options.getStringProperty("nashorn.regexp.impl", JONI)) {
            case "joni": {
                instance = new JoniRegExp.Factory();
                break;
            }
            case "jdk": {
                instance = new RegExpFactory();
                break;
            }
            default: {
                instance = null;
                throw new InternalError("Unsupported RegExp factory: " + impl);
            }
        }
    }
}

