/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.support.CallSiteDescriptorFactory;
import jdk.internal.dynalink.support.Guards;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.DefaultPropertyAccess;
import jdk.nashorn.internal.runtime.ECMAErrors;
import jdk.nashorn.internal.runtime.ECMAException;
import jdk.nashorn.internal.runtime.ScriptRuntime;

public final class Undefined
extends DefaultPropertyAccess {
    private static final Undefined UNDEFINED = new Undefined();
    private static final Undefined EMPTY = new Undefined();
    private static final MethodHandle UNDEFINED_GUARD = Guards.getIdentityGuard(UNDEFINED);

    private Undefined() {
    }

    public static Undefined getUndefined() {
        return UNDEFINED;
    }

    public static Undefined getEmpty() {
        return EMPTY;
    }

    public String getClassName() {
        return "Undefined";
    }

    public String toString() {
        return "undefined";
    }

    public static GuardedInvocation lookup(CallSiteDescriptor desc) {
        String operator;
        switch (operator = CallSiteDescriptorFactory.tokenizeOperators(desc).get(0)) {
            case "new": 
            case "call": {
                throw Undefined.lookupTypeError("cant.call.undefined", desc);
            }
            case "callMethod": {
                throw Undefined.lookupTypeError("cant.read.property.of.undefined", desc);
            }
            case "getProp": 
            case "getElem": 
            case "getMethod": {
                if (desc.getNameTokenCount() < 3) {
                    return Undefined.findGetIndexMethod(desc, new Object[0]);
                }
                throw Undefined.lookupTypeError("cant.read.property.of.undefined", desc);
            }
            case "setProp": 
            case "setElem": {
                if (desc.getNameTokenCount() < 3) {
                    return Undefined.findSetIndexMethod(desc);
                }
                throw Undefined.lookupTypeError("cant.set.property.of.undefined", desc);
            }
        }
        return null;
    }

    private static ECMAException lookupTypeError(String msg, CallSiteDescriptor desc) {
        return ECMAErrors.typeError(msg, desc.getNameTokenCount() > 2 ? desc.getNameToken(2) : null);
    }

    private static GuardedInvocation findGetIndexMethod(CallSiteDescriptor desc, Object ... args) {
        MethodType callType = desc.getMethodType();
        TypeDescriptor.OfField returnClass = callType.returnType();
        TypeDescriptor.OfField keyClass = callType.parameterType(1);
        String name = "get";
        if (((Class)returnClass).isPrimitive()) {
            String returnTypeName = ((Class)returnClass).getName();
            name = name + Character.toUpperCase(returnTypeName.charAt(0)) + returnTypeName.substring(1, returnTypeName.length());
        }
        MethodHandle methodHandle = Undefined.findOwnMH(name, returnClass, new Class[]{keyClass});
        methodHandle = Lookup.MH.asType(methodHandle, methodHandle.type().changeParameterType(0, Object.class));
        return new GuardedInvocation(methodHandle, UNDEFINED_GUARD);
    }

    private static GuardedInvocation findSetIndexMethod(CallSiteDescriptor desc) {
        MethodType callType = desc.getMethodType();
        TypeDescriptor.OfField keyClass = callType.parameterType(1);
        TypeDescriptor.OfField valueClass = callType.parameterType(2);
        MethodHandle methodHandle = Undefined.findOwnMH("set", Void.TYPE, new Class[]{keyClass, valueClass, Boolean.TYPE});
        methodHandle = Lookup.MH.asType(methodHandle, methodHandle.type().changeParameterType(0, Object.class));
        methodHandle = Lookup.MH.insertArguments(methodHandle, 3, false);
        return new GuardedInvocation(methodHandle, UNDEFINED_GUARD);
    }

    @Override
    public Object get(Object key) {
        throw ECMAErrors.typeError("cant.read.property.of.undefined", ScriptRuntime.safeToString(key));
    }

    @Override
    public void set(Object key, Object value, boolean strict) {
        throw ECMAErrors.typeError("cant.set.property.of.undefined", ScriptRuntime.safeToString(key));
    }

    @Override
    public boolean delete(Object key, boolean strict) {
        throw ECMAErrors.typeError("cant.delete.property.of.undefined", ScriptRuntime.safeToString(key));
    }

    @Override
    public boolean has(Object key) {
        return false;
    }

    @Override
    public boolean hasOwnProperty(Object key) {
        return false;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findVirtual(MethodHandles.lookup(), Undefined.class, name, Lookup.MH.type(rtype, types));
    }
}

