/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import jdk.nashorn.internal.codegen.ObjectClassGenerator;
import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.lookup.MethodHandleFactory;
import jdk.nashorn.internal.runtime.Debug;
import jdk.nashorn.internal.runtime.Property;
import jdk.nashorn.internal.runtime.PropertyMap;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.StructureLoader;

public final class AccessorProperty
extends Property
implements Serializable {
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final MethodHandle REPLACE_MAP = AccessorProperty.findOwnMH("replaceMap", Object.class, Object.class, PropertyMap.class, String.class, Class.class, Class.class);
    private static final int NOOF_TYPES = ObjectClassGenerator.getNumberOfAccessorTypes();
    private static final long serialVersionUID = 3371720170182154920L;
    private static ClassValue<GettersSetters> GETTERS_SETTERS = new ClassValue<GettersSetters>(){

        @Override
        protected GettersSetters computeValue(Class<?> structure) {
            return new GettersSetters(structure);
        }
    };
    private transient MethodHandle[] getters = new MethodHandle[NOOF_TYPES];
    private static final MethodType[] ACCESSOR_GETTER_TYPES = new MethodType[NOOF_TYPES];
    private static final MethodType[] ACCESSOR_SETTER_TYPES = new MethodType[NOOF_TYPES];
    private static final MethodType ACCESSOR_GETTER_PRIMITIVE_TYPE;
    private static final MethodType ACCESSOR_SETTER_PRIMITIVE_TYPE;
    private static final MethodHandle SPILL_ELEMENT_GETTER;
    private static final MethodHandle SPILL_ELEMENT_SETTER;
    private static final int SPILL_CACHE_SIZE = 8;
    private static final MethodHandle[] SPILL_ACCESSORS;
    private transient MethodHandle primitiveGetter;
    private transient MethodHandle primitiveSetter;
    private transient MethodHandle objectGetter;
    private transient MethodHandle objectSetter;
    private Class<?> currentType;

    public static AccessorProperty create(String key, int propertyFlags, MethodHandle getter, MethodHandle setter) {
        return new AccessorProperty(key, propertyFlags, -1, getter, setter);
    }

    AccessorProperty(AccessorProperty property, Object delegate) {
        super(property);
        this.primitiveGetter = AccessorProperty.bindTo(property.primitiveGetter, delegate);
        this.primitiveSetter = AccessorProperty.bindTo(property.primitiveSetter, delegate);
        this.objectGetter = AccessorProperty.bindTo(property.ensureObjectGetter(), delegate);
        this.objectSetter = AccessorProperty.bindTo(property.ensureObjectSetter(), delegate);
        this.flags |= 0x400;
        this.setCurrentType(property.getCurrentType());
    }

    public AccessorProperty(String key, int flags, int slot) {
        super(key, flags, slot);
        assert ((flags & 8) == 8);
        this.setCurrentType(Object.class);
    }

    AccessorProperty(String key, int flags, int slot, MethodHandle getter, MethodHandle setter) {
        super(key, flags, slot);
        TypeDescriptor.OfField setterType;
        TypeDescriptor.OfField getterType = getter.type().returnType();
        TypeDescriptor.OfField ofField = setterType = setter == null ? null : setter.type().parameterType(1);
        assert (setterType == null || setterType == getterType);
        if (((Class)getterType).isPrimitive()) {
            for (int i = 0; i < NOOF_TYPES; ++i) {
                this.getters[i] = Lookup.MH.asType(Lookup.filterReturnType(getter, ObjectClassGenerator.getAccessorType(i).getTypeClass()), ACCESSOR_GETTER_TYPES[i]);
            }
        } else {
            this.objectGetter = getter.type() != Lookup.GET_OBJECT_TYPE ? Lookup.MH.asType(getter, Lookup.GET_OBJECT_TYPE) : getter;
            this.objectSetter = setter != null && setter.type() != Lookup.SET_OBJECT_TYPE ? Lookup.MH.asType(setter, Lookup.SET_OBJECT_TYPE) : setter;
        }
        this.setCurrentType((Class<?>)getterType);
    }

    public AccessorProperty(String key, int flags, Class<?> structure, int slot) {
        super(key, flags, slot);
        this.initGetterSetter(structure);
    }

    private void initGetterSetter(Class<?> structure) {
        int slot = this.getSlot();
        String key = this.getKey();
        this.primitiveGetter = null;
        this.primitiveSetter = null;
        if (this.isParameter() && this.hasArguments()) {
            MethodHandle arguments = Lookup.MH.getter(lookup, structure, "arguments", ScriptObject.class);
            this.objectGetter = Lookup.MH.asType(Lookup.MH.insertArguments(Lookup.MH.filterArguments(ScriptObject.GET_ARGUMENT.methodHandle(), 0, arguments), 1, slot), Lookup.GET_OBJECT_TYPE);
            this.objectSetter = Lookup.MH.asType(Lookup.MH.insertArguments(Lookup.MH.filterArguments(ScriptObject.SET_ARGUMENT.methodHandle(), 0, arguments), 1, slot), Lookup.SET_OBJECT_TYPE);
        } else {
            GettersSetters gs = GETTERS_SETTERS.get(structure);
            this.objectGetter = gs.getters[slot];
            this.objectSetter = gs.setters[slot];
            if (!ObjectClassGenerator.OBJECT_FIELDS_ONLY) {
                String fieldNamePrimitive = ObjectClassGenerator.getFieldName(slot, ObjectClassGenerator.PRIMITIVE_TYPE);
                Class<?> typeClass = ObjectClassGenerator.PRIMITIVE_TYPE.getTypeClass();
                this.primitiveGetter = Lookup.MH.asType(Lookup.MH.getter(lookup, structure, fieldNamePrimitive, typeClass), ACCESSOR_GETTER_PRIMITIVE_TYPE);
                this.primitiveSetter = Lookup.MH.asType(Lookup.MH.setter(lookup, structure, fieldNamePrimitive, typeClass), ACCESSOR_SETTER_PRIMITIVE_TYPE);
            }
        }
        Class<Object> initialType = null;
        if (ObjectClassGenerator.OBJECT_FIELDS_ONLY || this.isAlwaysObject()) {
            initialType = Object.class;
        } else if (!this.canBePrimitive()) {
            AccessorProperty.info(key + " cannot be primitive");
            initialType = Object.class;
        } else {
            AccessorProperty.info(key + " CAN be primitive");
            if (!this.canBeUndefined()) {
                AccessorProperty.info(key + " is always defined");
                initialType = Integer.TYPE;
            }
        }
        this.setCurrentType(initialType);
    }

    protected AccessorProperty(AccessorProperty property) {
        super(property);
        this.getters = property.getters;
        this.primitiveGetter = property.primitiveGetter;
        this.primitiveSetter = property.primitiveSetter;
        this.objectGetter = property.objectGetter;
        this.objectSetter = property.objectSetter;
        this.setCurrentType(property.getCurrentType());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.getters = new MethodHandle[NOOF_TYPES];
    }

    private static MethodHandle bindTo(MethodHandle mh, Object receiver) {
        if (mh == null) {
            return null;
        }
        return Lookup.MH.dropArguments(Lookup.MH.bindTo(mh, receiver), 0, Object.class);
    }

    @Override
    protected Property copy() {
        return new AccessorProperty(this);
    }

    @Override
    public void setObjectValue(ScriptObject self, ScriptObject owner, Object value, boolean strict) {
        if (this.isSpill()) {
            self.spill[this.getSlot()] = value;
        } else {
            try {
                this.getSetter(Object.class, self.getMap()).invokeExact(self, value);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Object getObjectValue(ScriptObject self, ScriptObject owner) {
        if (this.isSpill()) {
            return self.spill[this.getSlot()];
        }
        try {
            return this.getGetter(Object.class).invokeExact(self);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private MethodHandle ensureObjectGetter() {
        if (this.isSpill() && this.objectGetter == null) {
            this.objectGetter = this.getSpillGetter();
        }
        return this.objectGetter;
    }

    private MethodHandle ensureObjectSetter() {
        if (this.isSpill() && this.objectSetter == null) {
            this.objectSetter = this.getSpillSetter();
        }
        return this.objectSetter;
    }

    @Override
    void initMethodHandles(Class<?> structure) {
        if (!ScriptObject.class.isAssignableFrom(structure) || !StructureLoader.isStructureClass(structure.getName())) {
            throw new IllegalArgumentException();
        }
        if (!this.isSpill()) {
            this.initGetterSetter(structure);
        }
    }

    @Override
    public MethodHandle getGetter(Class<?> type) {
        int i = ObjectClassGenerator.getAccessorTypeIndex(type);
        this.ensureObjectGetter();
        if (this.getters[i] == null) {
            this.getters[i] = this.debug(ObjectClassGenerator.createGetter(this.currentType, type, this.primitiveGetter, this.objectGetter), this.currentType, type, "get");
        }
        return this.getters[i];
    }

    private Property getWiderProperty(Class<?> type) {
        AccessorProperty newProperty = new AccessorProperty(this);
        newProperty.invalidate(type);
        return newProperty;
    }

    private PropertyMap getWiderMap(PropertyMap oldMap, Property newProperty) {
        PropertyMap newMap = oldMap.replaceProperty(this, newProperty);
        assert (oldMap.size() > 0);
        assert (newMap.size() == oldMap.size());
        return newMap;
    }

    private static Object replaceMap(Object sobj, PropertyMap newMap, String key, Class<?> oldType, Class<?> newType) {
        if (ObjectClassGenerator.DEBUG_FIELDS) {
            PropertyMap oldMap = ((ScriptObject)sobj).getMap();
            AccessorProperty.info("Type change for '" + key + "' " + oldType + "=>" + newType);
            AccessorProperty.finest("setting map " + sobj + " from " + Debug.id(oldMap) + " to " + Debug.id(newMap) + " " + oldMap + " => " + newMap);
        }
        ((ScriptObject)sobj).setMap(newMap);
        return sobj;
    }

    private MethodHandle generateSetter(Class<?> forType, Class<?> type) {
        this.ensureObjectSetter();
        MethodHandle mh = ObjectClassGenerator.createSetter(forType, type, this.primitiveSetter, this.objectSetter);
        mh = this.debug(mh, this.currentType, type, "set");
        return mh;
    }

    @Override
    public MethodHandle getSetter(Class<?> type, PropertyMap currentMap) {
        MethodHandle mh;
        Class<?> forType;
        int i = ObjectClassGenerator.getAccessorTypeIndex(type);
        int ci = this.currentType == null ? -1 : ObjectClassGenerator.getAccessorTypeIndex(this.currentType);
        Class<?> clazz = forType = this.currentType == null ? type : this.currentType;
        if (this.needsInvalidator(i, ci)) {
            Property newProperty = this.getWiderProperty(type);
            PropertyMap newMap = this.getWiderMap(currentMap, newProperty);
            MethodHandle widerSetter = newProperty.getSetter(type, newMap);
            MethodHandle explodeTypeSetter = Lookup.MH.filterArguments(widerSetter, 0, Lookup.MH.insertArguments(REPLACE_MAP, 1, newMap, this.getKey(), this.currentType, type));
            mh = this.currentType != null && this.currentType.isPrimitive() && type == Object.class ? ObjectClassGenerator.createGuardBoxedPrimitiveSetter(this.currentType, this.generateSetter(this.currentType, this.currentType), explodeTypeSetter) : explodeTypeSetter;
        } else {
            mh = this.generateSetter(forType, type);
        }
        return mh;
    }

    @Override
    public boolean canChangeType() {
        if (ObjectClassGenerator.OBJECT_FIELDS_ONLY) {
            return false;
        }
        return this.currentType != Object.class && (this.isConfigurable() || this.isWritable());
    }

    private boolean needsInvalidator(int ti, int fti) {
        return this.canChangeType() && ti > fti;
    }

    private void invalidate(Class<?> newType) {
        this.getters = new MethodHandle[NOOF_TYPES];
        this.setCurrentType(newType);
    }

    private MethodHandle getSpillGetter() {
        MethodHandle getter;
        int slot = this.getSlot();
        MethodHandle methodHandle = getter = slot < 8 ? SPILL_ACCESSORS[slot * 2] : null;
        if (getter == null) {
            getter = Lookup.MH.insertArguments(SPILL_ELEMENT_GETTER, 1, slot);
            if (slot < 8) {
                AccessorProperty.SPILL_ACCESSORS[slot * 2 + 0] = getter;
            }
        }
        return getter;
    }

    private MethodHandle getSpillSetter() {
        MethodHandle setter;
        int slot = this.getSlot();
        MethodHandle methodHandle = setter = slot < 8 ? SPILL_ACCESSORS[slot * 2 + 1] : null;
        if (setter == null) {
            setter = Lookup.MH.insertArguments(SPILL_ELEMENT_SETTER, 1, slot);
            if (slot < 8) {
                AccessorProperty.SPILL_ACCESSORS[slot * 2 + 1] = setter;
            }
        }
        return setter;
    }

    private static void finest(String str) {
        if (ObjectClassGenerator.DEBUG_FIELDS) {
            ObjectClassGenerator.LOG.finest(str);
        }
    }

    private static void info(String str) {
        if (ObjectClassGenerator.DEBUG_FIELDS) {
            ObjectClassGenerator.LOG.info(str);
        }
    }

    private MethodHandle debug(MethodHandle mh, Class<?> forType, Class<?> type, String tag) {
        if (ObjectClassGenerator.DEBUG_FIELDS) {
            return MethodHandleFactory.addDebugPrintout(ObjectClassGenerator.LOG, mh, tag + " '" + this.getKey() + "' (property=" + Debug.id(this) + ", forType=" + MethodHandleFactory.stripName(forType) + ", type=" + MethodHandleFactory.stripName(type) + ')');
        }
        return mh;
    }

    private void setCurrentType(Class<?> currentType) {
        this.currentType = currentType;
    }

    @Override
    public Class<?> getCurrentType() {
        return this.currentType;
    }

    private static MethodHandle findOwnMH(String name, Class<?> rtype, Class<?> ... types) {
        return Lookup.MH.findStatic(lookup, AccessorProperty.class, name, Lookup.MH.type(rtype, types));
    }

    static {
        SPILL_ACCESSORS = new MethodHandle[16];
        MethodType getterPrimitiveType = null;
        MethodType setterPrimitiveType = null;
        for (int i = 0; i < NOOF_TYPES; ++i) {
            Type type = ObjectClassGenerator.ACCESSOR_TYPES.get(i);
            AccessorProperty.ACCESSOR_GETTER_TYPES[i] = Lookup.MH.type(type.getTypeClass(), Object.class);
            AccessorProperty.ACCESSOR_SETTER_TYPES[i] = Lookup.MH.type(Void.TYPE, Object.class, type.getTypeClass());
            if (type != ObjectClassGenerator.PRIMITIVE_TYPE) continue;
            getterPrimitiveType = ACCESSOR_GETTER_TYPES[i];
            setterPrimitiveType = ACCESSOR_SETTER_TYPES[i];
        }
        ACCESSOR_GETTER_PRIMITIVE_TYPE = getterPrimitiveType;
        ACCESSOR_SETTER_PRIMITIVE_TYPE = setterPrimitiveType;
        MethodType spillGetterType = MethodType.methodType(Object[].class, Object.class);
        MethodHandle spillGetter = Lookup.MH.asType(Lookup.MH.getter(MethodHandles.lookup(), ScriptObject.class, "spill", Object[].class), spillGetterType);
        SPILL_ELEMENT_GETTER = Lookup.MH.filterArguments(Lookup.MH.arrayElementGetter(Object[].class), 0, spillGetter);
        SPILL_ELEMENT_SETTER = Lookup.MH.filterArguments(Lookup.MH.arrayElementSetter(Object[].class), 0, spillGetter);
    }

    private static class GettersSetters {
        final MethodHandle[] getters;
        final MethodHandle[] setters;

        public GettersSetters(Class<?> structure) {
            int fieldCount = ObjectClassGenerator.getFieldCount(structure);
            this.getters = new MethodHandle[fieldCount];
            this.setters = new MethodHandle[fieldCount];
            for (int i = 0; i < fieldCount; ++i) {
                String fieldName = ObjectClassGenerator.getFieldName(i, Type.OBJECT);
                this.getters[i] = Lookup.MH.asType(Lookup.MH.getter(lookup, structure, fieldName, Type.OBJECT.getTypeClass()), Lookup.GET_OBJECT_TYPE);
                this.setters[i] = Lookup.MH.asType(Lookup.MH.setter(lookup, structure, fieldName, Type.OBJECT.getTypeClass()), Lookup.SET_OBJECT_TYPE);
            }
        }
    }
}

