/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import jdk.nashorn.internal.codegen.types.Type;
import jdk.nashorn.internal.ir.Assignment;
import jdk.nashorn.internal.ir.Expression;
import jdk.nashorn.internal.ir.IdentNode;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;
import jdk.nashorn.internal.parser.Token;
import jdk.nashorn.internal.parser.TokenType;

@Immutable
public final class UnaryNode
extends Expression
implements Assignment<Expression> {
    private final Expression rhs;

    public UnaryNode(long token, Expression rhs) {
        this(token, Math.min(rhs.getStart(), Token.descPosition(token)), Math.max(Token.descPosition(token) + Token.descLength(token), rhs.getFinish()), rhs);
    }

    public UnaryNode(long token, int start, int finish, Expression rhs) {
        super(token, start, finish);
        this.rhs = rhs;
    }

    private UnaryNode(UnaryNode unaryNode, Expression rhs) {
        super(unaryNode);
        this.rhs = rhs;
    }

    @Override
    public boolean isAssignment() {
        switch (this.tokenType()) {
            case DECPOSTFIX: 
            case DECPREFIX: 
            case INCPOSTFIX: 
            case INCPREFIX: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isSelfModifying() {
        return this.isAssignment();
    }

    @Override
    public Type getWidestOperationType() {
        return this.isAssignment() ? Type.NUMBER : Type.OBJECT;
    }

    @Override
    public Expression getAssignmentDest() {
        return this.isAssignment() ? this.rhs() : null;
    }

    public UnaryNode setAssignmentDest(Expression n) {
        return this.setRHS(n);
    }

    @Override
    public Expression getAssignmentSource() {
        return this.getAssignmentDest();
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterUnaryNode(this)) {
            return visitor.leaveUnaryNode(this.setRHS((Expression)this.rhs.accept(visitor)));
        }
        return this;
    }

    @Override
    public boolean isLocal() {
        switch (this.tokenType()) {
            case NEW: {
                return false;
            }
            case ADD: 
            case SUB: 
            case NOT: 
            case BIT_NOT: {
                return this.rhs.isLocal() && this.rhs.getType().isJSPrimitive();
            }
            case DECPOSTFIX: 
            case DECPREFIX: 
            case INCPOSTFIX: 
            case INCPREFIX: {
                return this.rhs instanceof IdentNode && this.rhs.isLocal() && this.rhs.getType().isJSPrimitive();
            }
        }
        return this.rhs.isLocal();
    }

    @Override
    public void toString(final StringBuilder sb) {
        this.toString(sb, new Runnable(){

            @Override
            public void run() {
                sb.append(UnaryNode.this.rhs().toString());
            }
        });
    }

    public void toString(StringBuilder sb, Runnable rhsStringBuilder) {
        TokenType type = this.tokenType();
        String name = type.getName();
        boolean isPostfix = type == TokenType.DECPOSTFIX || type == TokenType.INCPOSTFIX;
        boolean rhsParen = type.needsParens(this.rhs().tokenType(), false);
        if (!isPostfix) {
            if (name == null) {
                sb.append(type.name());
                rhsParen = true;
            } else {
                sb.append(name);
                if (type.ordinal() > TokenType.BIT_NOT.ordinal()) {
                    sb.append(' ');
                }
            }
        }
        if (rhsParen) {
            sb.append('(');
        }
        rhsStringBuilder.run();
        if (rhsParen) {
            sb.append(')');
        }
        if (isPostfix) {
            sb.append(type == TokenType.DECPOSTFIX ? "--" : "++");
        }
    }

    public Expression rhs() {
        return this.rhs;
    }

    public UnaryNode setRHS(Expression rhs) {
        if (this.rhs == rhs) {
            return this;
        }
        return new UnaryNode(this, rhs);
    }
}

