/*
 * Decompiled with CFR 0.152.
 */
package sun.security.timestamp;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import sun.misc.IOUtils;
import sun.security.timestamp.TSRequest;
import sun.security.timestamp.TSResponse;
import sun.security.timestamp.Timestamper;

public class HttpTimestamper
implements Timestamper {
    private static final int CONNECT_TIMEOUT = 15000;
    private static final String TS_QUERY_MIME_TYPE = "application/timestamp-query";
    private static final String TS_REPLY_MIME_TYPE = "application/timestamp-reply";
    private static final boolean DEBUG = false;
    private String tsaUrl = null;

    public HttpTimestamper(String tsaUrl) {
        this.tsaUrl = tsaUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TSResponse generateTimestamp(TSRequest tsQuery) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(this.tsaUrl).openConnection();
        connection.setDoOutput(true);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", TS_QUERY_MIME_TYPE);
        connection.setRequestMethod("POST");
        connection.setConnectTimeout(15000);
        connection.connect();
        try (DataOutputStream output = null;){
            output = new DataOutputStream(connection.getOutputStream());
            byte[] request = tsQuery.encode();
            output.write(request, 0, request.length);
            output.flush();
        }
        byte[] replyBuffer = null;
        try (BufferedInputStream input = null;){
            input = new BufferedInputStream(connection.getInputStream());
            HttpTimestamper.verifyMimeType(connection.getContentType());
            boolean total = false;
            int contentLength = connection.getContentLength();
            replyBuffer = IOUtils.readFully(input, contentLength, false);
        }
        return new TSResponse(replyBuffer);
    }

    private static void verifyMimeType(String contentType) throws IOException {
        if (!TS_REPLY_MIME_TYPE.equalsIgnoreCase(contentType)) {
            throw new IOException("MIME Content-Type is not application/timestamp-reply");
        }
    }
}

