/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import sun.misc.HexDumpEncoder;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Checksum;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.APOptions;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KRBError
implements Serializable {
    static final long serialVersionUID = 3643809337475284503L;
    private int pvno;
    private int msgType;
    private KerberosTime cTime;
    private Integer cuSec;
    private KerberosTime sTime;
    private Integer suSec;
    private int errorCode;
    private Realm crealm;
    private PrincipalName cname;
    private Realm realm;
    private PrincipalName sname;
    private String eText;
    private byte[] eData;
    private Checksum eCksum;
    private PAData[] pa;
    private static boolean DEBUG = Krb5.DEBUG;

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        try {
            this.init(new DerValue((byte[])is.readObject()));
            this.parseEData(this.eData);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        try {
            os.writeObject(this.asn1Encode());
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public KRBError(APOptions new_apOptions, KerberosTime new_cTime, Integer new_cuSec, KerberosTime new_sTime, Integer new_suSec, int new_errorCode, Realm new_crealm, PrincipalName new_cname, Realm new_realm, PrincipalName new_sname, String new_eText, byte[] new_eData) throws IOException, Asn1Exception {
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = new_cTime;
        this.cuSec = new_cuSec;
        this.sTime = new_sTime;
        this.suSec = new_suSec;
        this.errorCode = new_errorCode;
        this.crealm = new_crealm;
        this.cname = new_cname;
        this.realm = new_realm;
        this.sname = new_sname;
        this.eText = new_eText;
        this.eData = new_eData;
        this.parseEData(this.eData);
    }

    public KRBError(APOptions new_apOptions, KerberosTime new_cTime, Integer new_cuSec, KerberosTime new_sTime, Integer new_suSec, int new_errorCode, Realm new_crealm, PrincipalName new_cname, Realm new_realm, PrincipalName new_sname, String new_eText, byte[] new_eData, Checksum new_eCksum) throws IOException, Asn1Exception {
        this.pvno = 5;
        this.msgType = 30;
        this.cTime = new_cTime;
        this.cuSec = new_cuSec;
        this.sTime = new_sTime;
        this.suSec = new_suSec;
        this.errorCode = new_errorCode;
        this.crealm = new_crealm;
        this.cname = new_cname;
        this.realm = new_realm;
        this.sname = new_sname;
        this.eText = new_eText;
        this.eData = new_eData;
        this.eCksum = new_eCksum;
        this.parseEData(this.eData);
    }

    public KRBError(byte[] data) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(new DerValue(data));
        this.parseEData(this.eData);
    }

    public KRBError(DerValue encoding) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(encoding);
        this.showDebug();
        this.parseEData(this.eData);
    }

    private void parseEData(byte[] data) throws IOException {
        if (data == null) {
            return;
        }
        if (this.errorCode == 25 || this.errorCode == 24) {
            try {
                this.parsePAData(data);
            }
            catch (Exception e) {
                if (DEBUG) {
                    System.out.println("Unable to parse eData field of KRB-ERROR:\n" + new HexDumpEncoder().encodeBuffer(data));
                }
                IOException ioe = new IOException("Unable to parse eData field of KRB-ERROR");
                ioe.initCause(e);
                throw ioe;
            }
        } else if (DEBUG) {
            System.out.println("Unknown eData field of KRB-ERROR:\n" + new HexDumpEncoder().encodeBuffer(data));
        }
    }

    private void parsePAData(byte[] data) throws IOException, Asn1Exception {
        DerValue derPA = new DerValue(data);
        ArrayList<PAData> paList = new ArrayList<PAData>();
        while (derPA.data.available() > 0) {
            DerValue tmp = derPA.data.getDerValue();
            PAData pa_data = new PAData(tmp);
            paList.add(pa_data);
            if (!DEBUG) continue;
            System.out.println(pa_data);
        }
        this.pa = paList.toArray(new PAData[paList.size()]);
    }

    public final KerberosTime getServerTime() {
        return this.sTime;
    }

    public final KerberosTime getClientTime() {
        return this.cTime;
    }

    public final Integer getServerMicroSeconds() {
        return this.suSec;
    }

    public final Integer getClientMicroSeconds() {
        return this.cuSec;
    }

    public final int getErrorCode() {
        return this.errorCode;
    }

    public final PAData[] getPA() {
        return this.pa;
    }

    public final String getErrorString() {
        return this.eText;
    }

    private void init(DerValue encoding) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        if ((encoding.getTag() & 0x1F) != 30 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 0) {
            this.pvno = subDer.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 1) {
            this.msgType = subDer.getData().getBigInteger().intValue();
            if (this.msgType != 30) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        this.cTime = KerberosTime.parse(der.getData(), (byte)2, true);
        if ((der.getData().peekByte() & 0x1F) == 3) {
            subDer = der.getData().getDerValue();
            this.cuSec = new Integer(subDer.getData().getBigInteger().intValue());
        } else {
            this.cuSec = null;
        }
        this.sTime = KerberosTime.parse(der.getData(), (byte)4, false);
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 5) {
            throw new Asn1Exception(906);
        }
        this.suSec = new Integer(subDer.getData().getBigInteger().intValue());
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) != 6) {
            throw new Asn1Exception(906);
        }
        this.errorCode = subDer.getData().getBigInteger().intValue();
        this.crealm = Realm.parse(der.getData(), (byte)7, true);
        this.cname = PrincipalName.parse(der.getData(), (byte)8, true);
        this.realm = Realm.parse(der.getData(), (byte)9, false);
        this.sname = PrincipalName.parse(der.getData(), (byte)10, false);
        this.eText = null;
        this.eData = null;
        this.eCksum = null;
        if (der.getData().available() > 0 && (der.getData().peekByte() & 0x1F) == 11) {
            subDer = der.getData().getDerValue();
            this.eText = new KerberosString(subDer.getData().getDerValue()).toString();
        }
        if (der.getData().available() > 0 && (der.getData().peekByte() & 0x1F) == 12) {
            subDer = der.getData().getDerValue();
            this.eData = subDer.getData().getOctetString();
        }
        if (der.getData().available() > 0) {
            this.eCksum = Checksum.parse(der.getData(), (byte)13, true);
        }
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    private void showDebug() {
        if (DEBUG) {
            System.out.println(">>>KRBError:");
            if (this.cTime != null) {
                System.out.println("\t cTime is " + this.cTime.toDate().toString() + " " + this.cTime.toDate().getTime());
            }
            if (this.cuSec != null) {
                System.out.println("\t cuSec is " + this.cuSec);
            }
            System.out.println("\t sTime is " + this.sTime.toDate().toString() + " " + this.sTime.toDate().getTime());
            System.out.println("\t suSec is " + this.suSec);
            System.out.println("\t error code is " + this.errorCode);
            System.out.println("\t error Message is " + Krb5.getErrorMessage(this.errorCode));
            if (this.crealm != null) {
                System.out.println("\t crealm is " + this.crealm.toString());
            }
            if (this.cname != null) {
                System.out.println("\t cname is " + this.cname.toString());
            }
            if (this.realm != null) {
                System.out.println("\t realm is " + this.realm.toString());
            }
            if (this.sname != null) {
                System.out.println("\t sname is " + this.sname.toString());
            }
            if (this.eData != null) {
                System.out.println("\t eData provided.");
            }
            if (this.eCksum != null) {
                System.out.println("\t checksum provided.");
            }
            System.out.println("\t msgType is " + this.msgType);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream temp = new DerOutputStream();
        DerOutputStream bytes = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.pvno));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.msgType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        if (this.cTime != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)2), this.cTime.asn1Encode());
        }
        if (this.cuSec != null) {
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.valueOf(this.cuSec.intValue()));
            bytes.write(DerValue.createTag((byte)-128, true, (byte)3), temp);
        }
        bytes.write(DerValue.createTag((byte)-128, true, (byte)4), this.sTime.asn1Encode());
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.suSec.intValue()));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)5), temp);
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.errorCode));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)6), temp);
        if (this.crealm != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)7), this.crealm.asn1Encode());
        }
        if (this.cname != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)8), this.cname.asn1Encode());
        }
        bytes.write(DerValue.createTag((byte)-128, true, (byte)9), this.realm.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)10), this.sname.asn1Encode());
        if (this.eText != null) {
            temp = new DerOutputStream();
            temp.putDerValue(new KerberosString(this.eText).toDerValue());
            bytes.write(DerValue.createTag((byte)-128, true, (byte)11), temp);
        }
        if (this.eData != null) {
            temp = new DerOutputStream();
            temp.putOctetString(this.eData);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)12), temp);
        }
        if (this.eCksum != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)13), this.eCksum.asn1Encode());
        }
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        bytes = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)64, true, (byte)30), temp);
        return bytes.toByteArray();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KRBError)) {
            return false;
        }
        KRBError other = (KRBError)obj;
        return this.pvno == other.pvno && this.msgType == other.msgType && KRBError.isEqual(this.cTime, other.cTime) && KRBError.isEqual(this.cuSec, other.cuSec) && KRBError.isEqual(this.sTime, other.sTime) && KRBError.isEqual(this.suSec, other.suSec) && this.errorCode == other.errorCode && KRBError.isEqual(this.crealm, other.crealm) && KRBError.isEqual(this.cname, other.cname) && KRBError.isEqual(this.realm, other.realm) && KRBError.isEqual(this.sname, other.sname) && KRBError.isEqual(this.eText, other.eText) && Arrays.equals(this.eData, other.eData) && KRBError.isEqual(this.eCksum, other.eCksum);
    }

    private static boolean isEqual(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.pvno;
        result = 37 * result + this.msgType;
        if (this.cTime != null) {
            result = 37 * result + this.cTime.hashCode();
        }
        if (this.cuSec != null) {
            result = 37 * result + this.cuSec.hashCode();
        }
        if (this.sTime != null) {
            result = 37 * result + this.sTime.hashCode();
        }
        if (this.suSec != null) {
            result = 37 * result + this.suSec.hashCode();
        }
        result = 37 * result + this.errorCode;
        if (this.crealm != null) {
            result = 37 * result + this.crealm.hashCode();
        }
        if (this.cname != null) {
            result = 37 * result + this.cname.hashCode();
        }
        if (this.realm != null) {
            result = 37 * result + this.realm.hashCode();
        }
        if (this.sname != null) {
            result = 37 * result + this.sname.hashCode();
        }
        if (this.eText != null) {
            result = 37 * result + this.eText.hashCode();
        }
        result = 37 * result + Arrays.hashCode(this.eData);
        if (this.eCksum != null) {
            result = 37 * result + this.eCksum.hashCode();
        }
        return result;
    }
}

