/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.math.BigInteger;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptedData;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.EncKDCRepPart;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.Ticket;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KDCRep {
    public Realm crealm;
    public PrincipalName cname;
    public Ticket ticket;
    public EncryptedData encPart;
    public EncKDCRepPart encKDCRepPart;
    private int pvno;
    private int msgType;
    public PAData[] pAData = null;
    private boolean DEBUG = Krb5.DEBUG;

    public KDCRep(PAData[] new_pAData, Realm new_crealm, PrincipalName new_cname, Ticket new_ticket, EncryptedData new_encPart, int req_type) throws IOException {
        this.pvno = 5;
        this.msgType = req_type;
        if (new_pAData != null) {
            this.pAData = new PAData[new_pAData.length];
            for (int i = 0; i < new_pAData.length; ++i) {
                if (new_pAData[i] == null) {
                    throw new IOException("Cannot create a KDCRep");
                }
                this.pAData[i] = (PAData)new_pAData[i].clone();
            }
        }
        this.crealm = new_crealm;
        this.cname = new_cname;
        this.ticket = new_ticket;
        this.encPart = new_encPart;
    }

    public KDCRep() {
    }

    public KDCRep(byte[] data, int req_type) throws Asn1Exception, KrbApErrException, RealmException, IOException {
        this.init(new DerValue(data), req_type);
    }

    public KDCRep(DerValue encoding, int req_type) throws Asn1Exception, RealmException, KrbApErrException, IOException {
        this.init(encoding, req_type);
    }

    protected void init(DerValue encoding, int req_type) throws Asn1Exception, RealmException, IOException, KrbApErrException {
        if ((encoding.getTag() & 0x1F) != req_type) {
            if (this.DEBUG) {
                System.out.println(">>> KDCRep: init() encoding tag is " + encoding.getTag() + " req type is " + req_type);
            }
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 0) {
            this.pvno = subDer.getData().getBigInteger().intValue();
            if (this.pvno != 5) {
                throw new KrbApErrException(39);
            }
        } else {
            throw new Asn1Exception(906);
        }
        subDer = der.getData().getDerValue();
        if ((subDer.getTag() & 0x1F) == 1) {
            this.msgType = subDer.getData().getBigInteger().intValue();
            if (this.msgType != req_type) {
                throw new KrbApErrException(40);
            }
        } else {
            throw new Asn1Exception(906);
        }
        if ((der.getData().peekByte() & 0x1F) == 2) {
            subDer = der.getData().getDerValue();
            DerValue[] padata = subDer.getData().getSequence(1);
            this.pAData = new PAData[padata.length];
            for (int i = 0; i < padata.length; ++i) {
                this.pAData[i] = new PAData(padata[i]);
            }
        } else {
            this.pAData = null;
        }
        this.crealm = Realm.parse(der.getData(), (byte)3, false);
        this.cname = PrincipalName.parse(der.getData(), (byte)4, false);
        this.ticket = Ticket.parse(der.getData(), (byte)5, false);
        this.encPart = EncryptedData.parse(der.getData(), (byte)6, false);
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.pvno));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), temp);
        temp = new DerOutputStream();
        temp.putInteger(BigInteger.valueOf(this.msgType));
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), temp);
        if (this.pAData != null && this.pAData.length > 0) {
            DerOutputStream padata_stream = new DerOutputStream();
            for (int i = 0; i < this.pAData.length; ++i) {
                padata_stream.write(this.pAData[i].asn1Encode());
            }
            temp = new DerOutputStream();
            temp.write((byte)48, padata_stream);
            bytes.write(DerValue.createTag((byte)-128, true, (byte)2), temp);
        }
        bytes.write(DerValue.createTag((byte)-128, true, (byte)3), this.crealm.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)4), this.cname.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)5), this.ticket.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)6), this.encPart.asn1Encode());
        temp = new DerOutputStream();
        temp.write((byte)48, bytes);
        return temp.toByteArray();
    }
}

