/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.AuthorizationData;
import sun.security.krb5.internal.HostAddresses;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.TicketFlags;
import sun.security.krb5.internal.TransitedEncoding;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class EncTicketPart {
    public TicketFlags flags;
    public EncryptionKey key;
    public Realm crealm;
    public PrincipalName cname;
    public TransitedEncoding transited;
    public KerberosTime authtime;
    public KerberosTime starttime;
    public KerberosTime endtime;
    public KerberosTime renewTill;
    public HostAddresses caddr;
    public AuthorizationData authorizationData;

    public EncTicketPart(TicketFlags new_flags, EncryptionKey new_key, Realm new_crealm, PrincipalName new_cname, TransitedEncoding new_transited, KerberosTime new_authtime, KerberosTime new_starttime, KerberosTime new_endtime, KerberosTime new_renewTill, HostAddresses new_caddr, AuthorizationData new_authorizationData) {
        this.flags = new_flags;
        this.key = new_key;
        this.crealm = new_crealm;
        this.cname = new_cname;
        this.transited = new_transited;
        this.authtime = new_authtime;
        this.starttime = new_starttime;
        this.endtime = new_endtime;
        this.renewTill = new_renewTill;
        this.caddr = new_caddr;
        this.authorizationData = new_authorizationData;
    }

    public EncTicketPart(byte[] data) throws Asn1Exception, KrbException, IOException {
        this.init(new DerValue(data));
    }

    public EncTicketPart(DerValue encoding) throws Asn1Exception, KrbException, IOException {
        this.init(encoding);
    }

    private static String getHexBytes(byte[] bytes, int len) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; ++i) {
            int b1 = bytes[i] >> 4 & 0xF;
            int b2 = bytes[i] & 0xF;
            sb.append(Integer.toHexString(b1));
            sb.append(Integer.toHexString(b2));
            sb.append(' ');
        }
        return sb.toString();
    }

    private void init(DerValue encoding) throws Asn1Exception, IOException, RealmException {
        this.renewTill = null;
        this.caddr = null;
        this.authorizationData = null;
        if ((encoding.getTag() & 0x1F) != 3 || !encoding.isApplication() || !encoding.isConstructed()) {
            throw new Asn1Exception(906);
        }
        DerValue der = encoding.getData().getDerValue();
        if (der.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        this.flags = TicketFlags.parse(der.getData(), (byte)0, false);
        this.key = EncryptionKey.parse(der.getData(), (byte)1, false);
        this.crealm = Realm.parse(der.getData(), (byte)2, false);
        this.cname = PrincipalName.parse(der.getData(), (byte)3, false);
        this.transited = TransitedEncoding.parse(der.getData(), (byte)4, false);
        this.authtime = KerberosTime.parse(der.getData(), (byte)5, false);
        this.starttime = KerberosTime.parse(der.getData(), (byte)6, true);
        this.endtime = KerberosTime.parse(der.getData(), (byte)7, false);
        if (der.getData().available() > 0) {
            this.renewTill = KerberosTime.parse(der.getData(), (byte)8, true);
        }
        if (der.getData().available() > 0) {
            this.caddr = HostAddresses.parse(der.getData(), (byte)9, true);
        }
        if (der.getData().available() > 0) {
            this.authorizationData = AuthorizationData.parse(der.getData(), (byte)10, true);
        }
        if (der.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream bytes = new DerOutputStream();
        DerOutputStream temp = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)-128, true, (byte)0), this.flags.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)1), this.key.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)2), this.crealm.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)3), this.cname.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)4), this.transited.asn1Encode());
        bytes.write(DerValue.createTag((byte)-128, true, (byte)5), this.authtime.asn1Encode());
        if (this.starttime != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)6), this.starttime.asn1Encode());
        }
        bytes.write(DerValue.createTag((byte)-128, true, (byte)7), this.endtime.asn1Encode());
        if (this.renewTill != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)8), this.renewTill.asn1Encode());
        }
        if (this.caddr != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)9), this.caddr.asn1Encode());
        }
        if (this.authorizationData != null) {
            bytes.write(DerValue.createTag((byte)-128, true, (byte)10), this.authorizationData.asn1Encode());
        }
        temp.write((byte)48, bytes);
        bytes = new DerOutputStream();
        bytes.write(DerValue.createTag((byte)64, true, (byte)3), temp);
        return bytes.toByteArray();
    }
}

