/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.util.LinkedList;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.RealmException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.util.KerberosString;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class Realm
implements Cloneable {
    private String realm;
    private static boolean DEBUG = Krb5.DEBUG;

    private Realm() {
    }

    public Realm(String name) throws RealmException {
        this.realm = Realm.parseRealm(name);
    }

    public Object clone() {
        Realm new_realm = new Realm();
        if (this.realm != null) {
            new_realm.realm = new String(this.realm);
        }
        return new_realm;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Realm)) {
            return false;
        }
        Realm that = (Realm)obj;
        if (this.realm != null && that.realm != null) {
            return this.realm.equals(that.realm);
        }
        return this.realm == null && that.realm == null;
    }

    public int hashCode() {
        int result = 17;
        if (this.realm != null) {
            result = 37 * result + this.realm.hashCode();
        }
        return result;
    }

    public Realm(DerValue encoding) throws Asn1Exception, RealmException, IOException {
        if (encoding == null) {
            throw new IllegalArgumentException("encoding can not be null");
        }
        this.realm = new KerberosString(encoding).toString();
        if (this.realm == null || this.realm.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(this.realm)) {
            throw new RealmException(600);
        }
    }

    public String toString() {
        return this.realm;
    }

    public static String parseRealmAtSeparator(String name) throws RealmException {
        if (name == null) {
            throw new IllegalArgumentException("null input name is not allowed");
        }
        String temp = new String(name);
        String result = null;
        for (int i = 0; i < temp.length(); ++i) {
            if (temp.charAt(i) != '@' || i != 0 && temp.charAt(i - 1) == '\\') continue;
            if (i + 1 >= temp.length()) break;
            result = temp.substring(i + 1, temp.length());
            break;
        }
        if (result != null) {
            if (result.length() == 0) {
                throw new RealmException(601);
            }
            if (!Realm.isValidRealmString(result)) {
                throw new RealmException(600);
            }
        }
        return result;
    }

    public static String parseRealmComponent(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null input name is not allowed");
        }
        String temp = new String(name);
        String result = null;
        for (int i = 0; i < temp.length(); ++i) {
            if (temp.charAt(i) != '.' || i != 0 && temp.charAt(i - 1) == '\\') continue;
            if (i + 1 >= temp.length()) break;
            result = temp.substring(i + 1, temp.length());
            break;
        }
        return result;
    }

    protected static String parseRealm(String name) throws RealmException {
        String result = Realm.parseRealmAtSeparator(name);
        if (result == null) {
            result = name;
        }
        if (result == null || result.length() == 0) {
            throw new RealmException(601);
        }
        if (!Realm.isValidRealmString(result)) {
            throw new RealmException(600);
        }
        return result;
    }

    protected static boolean isValidRealmString(String name) {
        if (name == null) {
            return false;
        }
        if (name.length() == 0) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (name.charAt(i) != '/' && name.charAt(i) != ':' && name.charAt(i) != '\u0000') continue;
            return false;
        }
        return true;
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream out = new DerOutputStream();
        out.putDerValue(new KerberosString(this.realm).toDerValue());
        return out.toByteArray();
    }

    public static Realm parse(DerInputStream data, byte explicitTag, boolean optional) throws Asn1Exception, IOException, RealmException {
        if (optional && ((byte)data.peekByte() & 0x1F) != explicitTag) {
            return null;
        }
        DerValue der = data.getDerValue();
        if (explicitTag != (der.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue subDer = der.getData().getDerValue();
        return new Realm(subDer);
    }

    private static String[] doInitialParse(String cRealm, String sRealm) throws KrbException {
        if (cRealm == null || sRealm == null) {
            throw new KrbException(400);
        }
        if (DEBUG) {
            System.out.println(">>> Realm doInitialParse: cRealm=[" + cRealm + "], sRealm=[" + sRealm + "]");
        }
        if (cRealm.equals(sRealm)) {
            String[] retList = null;
            retList = new String[]{new String(cRealm)};
            if (DEBUG) {
                System.out.println(">>> Realm doInitialParse: " + retList[0]);
            }
            return retList;
        }
        return null;
    }

    public static String[] getRealmsList(String cRealm, String sRealm) throws KrbException {
        String[] retList = Realm.doInitialParse(cRealm, sRealm);
        if (retList != null && retList.length != 0) {
            return retList;
        }
        retList = Realm.parseCapaths(cRealm, sRealm);
        if (retList != null && retList.length != 0) {
            return retList;
        }
        retList = Realm.parseHierarchy(cRealm, sRealm);
        return retList;
    }

    private static String[] parseCapaths(String cRealm, String sRealm) {
        String value;
        Config cfg = null;
        try {
            cfg = Config.getInstance();
        }
        catch (Exception exc) {
            if (DEBUG) {
                System.out.println("Configuration information can not be obtained " + exc.getMessage());
            }
            return null;
        }
        String intermediaries = cfg.getDefault(sRealm, cRealm);
        if (intermediaries == null) {
            if (DEBUG) {
                System.out.println(">>> Realm parseCapaths: no cfg entry");
            }
            return null;
        }
        LinkedList<String> path = new LinkedList<String>();
        String head = sRealm;
        while ((value = cfg.getDefault(head, cRealm)) != null) {
            String[] more = value.split("\\s+");
            boolean changed = false;
            for (int i = more.length - 1; i >= 0; --i) {
                if (path.contains(more[i]) || more[i].equals(".") || more[i].equals(cRealm) || more[i].equals(sRealm) || more[i].equals(head)) continue;
                changed = true;
                path.addFirst(more[i]);
            }
            if (!changed) break;
            head = (String)path.getFirst();
        }
        path.addFirst(cRealm);
        return path.toArray(new String[path.size()]);
    }

    private static String[] parseHierarchy(String cRealm, String sRealm) {
        int i;
        String[] cComponents = cRealm.split("\\.");
        String[] sComponents = sRealm.split("\\.");
        int cPos = cComponents.length;
        int sPos = sComponents.length;
        boolean hasCommon = false;
        --sPos;
        --cPos;
        while (sPos >= 0 && cPos >= 0 && sComponents[sPos].equals(cComponents[cPos])) {
            hasCommon = true;
            --sPos;
            --cPos;
        }
        LinkedList<String> path = new LinkedList<String>();
        for (i = 0; i <= cPos; ++i) {
            path.addLast(Realm.subStringFrom(cComponents, i));
        }
        if (hasCommon) {
            path.addLast(Realm.subStringFrom(cComponents, cPos + 1));
        }
        for (i = sPos; i >= 0; --i) {
            path.addLast(Realm.subStringFrom(sComponents, i));
        }
        path.removeLast();
        return path.toArray(new String[path.size()]);
    }

    private static String subStringFrom(String[] components, int from) {
        StringBuilder sb = new StringBuilder();
        for (int i = from; i < components.length; ++i) {
            if (sb.length() != 0) {
                sb.append('.');
            }
            sb.append(components[i]);
        }
        return sb.toString();
    }
}

