/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.IIOPHelper;
import com.sun.jmx.remote.security.MBeanServerFileAccessController;
import com.sun.jmx.remote.util.ClassLogger;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnector;
import javax.management.remote.rmi.RMIIIOPServerImpl;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.management.remote.rmi.RMIServer;
import javax.management.remote.rmi.RMIServerImpl;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class RMIConnectorServer
extends JMXConnectorServer {
    public static final String JNDI_REBIND_ATTRIBUTE = "jmx.remote.jndi.rebind";
    public static final String RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.client.socket.factory";
    public static final String RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE = "jmx.remote.rmi.server.socket.factory";
    private static final char[] intToAlpha = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static ClassLogger logger = new ClassLogger("javax.management.remote.rmi", "RMIConnectorServer");
    private JMXServiceURL address;
    private RMIServerImpl rmiServerImpl;
    private final Map<String, ?> attributes;
    private ClassLoader defaultClassLoader = null;
    private String boundJndiUrl;
    private static final int CREATED = 0;
    private static final int STARTED = 1;
    private static final int STOPPED = 2;
    private int state = 0;
    private static final Set<RMIConnectorServer> openedServers = new HashSet<RMIConnectorServer>();

    public RMIConnectorServer(JMXServiceURL url, Map<String, ?> environment) throws IOException {
        this(url, environment, (MBeanServer)null);
    }

    public RMIConnectorServer(JMXServiceURL url, Map<String, ?> environment, MBeanServer mbeanServer) throws IOException {
        this(url, environment, (RMIServerImpl)null, mbeanServer);
    }

    public RMIConnectorServer(JMXServiceURL url, Map<String, ?> environment, RMIServerImpl rmiServerImpl, MBeanServer mbeanServer) throws IOException {
        super(mbeanServer);
        if (url == null) {
            throw new IllegalArgumentException("Null JMXServiceURL");
        }
        if (rmiServerImpl == null) {
            String prt = url.getProtocol();
            if (prt == null || !prt.equals("rmi") && !prt.equals("iiop")) {
                String msg = "Invalid protocol type: " + prt;
                throw new MalformedURLException(msg);
            }
            String urlPath = url.getURLPath();
            if (!(urlPath.equals("") || urlPath.equals("/") || urlPath.startsWith("/jndi/"))) {
                String msg = "URL path must be empty or start with /jndi/";
                throw new MalformedURLException("URL path must be empty or start with /jndi/");
            }
        }
        if (environment == null) {
            this.attributes = Collections.emptyMap();
        } else {
            EnvHelp.checkAttributes(environment);
            this.attributes = Collections.unmodifiableMap(environment);
        }
        this.address = url;
        this.rmiServerImpl = rmiServerImpl;
    }

    @Override
    public JMXConnector toJMXConnector(Map<String, ?> env) throws IOException {
        if (!this.isActive()) {
            throw new IllegalStateException("Connector is not active");
        }
        Map<String, Object> usemap = new HashMap(this.attributes == null ? Collections.emptyMap() : this.attributes);
        if (env != null) {
            EnvHelp.checkAttributes(env);
            usemap.putAll(env);
        }
        usemap = EnvHelp.filterAttributes(usemap);
        RMIServer stub = (RMIServer)this.rmiServerImpl.toStub();
        return new RMIConnector(stub, usemap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void start() throws IOException {
        RMIServerImpl rmiServer;
        boolean tracing;
        block31: {
            String accessFile;
            tracing = logger.traceOn();
            if (this.state == 1) {
                if (tracing) {
                    logger.trace("start", "already started");
                }
                return;
            }
            if (this.state == 2) {
                if (tracing) {
                    logger.trace("start", "already stopped");
                }
                throw new IOException("The server has been stopped.");
            }
            if (this.getMBeanServer() == null) {
                throw new IllegalStateException("This connector server is not attached to an MBean server");
            }
            if (this.attributes != null && (accessFile = (String)this.attributes.get("jmx.remote.x.access.file")) != null) {
                MBeanServerFileAccessController mbsf;
                try {
                    mbsf = new MBeanServerFileAccessController(accessFile);
                }
                catch (IOException e) {
                    throw EnvHelp.initCause(new IllegalArgumentException(e.getMessage()), e);
                }
                this.setMBeanServerForwarder(mbsf);
            }
            try {
                if (tracing) {
                    logger.trace("start", "setting default class loader");
                }
                this.defaultClassLoader = EnvHelp.resolveServerClassLoader(this.attributes, this.getMBeanServer());
            }
            catch (InstanceNotFoundException infc) {
                IllegalArgumentException x = new IllegalArgumentException("ClassLoader not found: " + infc);
                throw EnvHelp.initCause(x, infc);
            }
            if (tracing) {
                logger.trace("start", "setting RMIServer object");
            }
            rmiServer = this.rmiServerImpl != null ? this.rmiServerImpl : this.newServer();
            rmiServer.setMBeanServer(this.getMBeanServer());
            rmiServer.setDefaultClassLoader(this.defaultClassLoader);
            rmiServer.setRMIConnectorServer(this);
            rmiServer.export();
            try {
                if (tracing) {
                    logger.trace("start", "getting RMIServer object to export");
                }
                RMIServer objref = RMIConnectorServer.objectToBind(rmiServer, this.attributes);
                if (this.address != null && this.address.getURLPath().startsWith("/jndi/")) {
                    String jndiUrl = this.address.getURLPath().substring(6);
                    if (tracing) {
                        logger.trace("start", "Using external directory: " + jndiUrl);
                    }
                    String stringBoolean = (String)this.attributes.get(JNDI_REBIND_ATTRIBUTE);
                    boolean rebind = EnvHelp.computeBooleanFromString(stringBoolean);
                    if (tracing) {
                        logger.trace("start", "jmx.remote.jndi.rebind=" + rebind);
                    }
                    try {
                        if (tracing) {
                            logger.trace("start", "binding to " + jndiUrl);
                        }
                        Hashtable<String, ?> usemap = EnvHelp.mapToHashtable(this.attributes);
                        this.bind(jndiUrl, usemap, objref, rebind);
                        this.boundJndiUrl = jndiUrl;
                        break block31;
                    }
                    catch (NamingException e) {
                        throw RMIConnectorServer.newIOException("Cannot bind to URL [" + jndiUrl + "]: " + e, e);
                    }
                }
                if (tracing) {
                    logger.trace("start", "Encoding URL");
                }
                this.encodeStubInAddress(objref, this.attributes);
                if (tracing) {
                    logger.trace("start", "Encoded URL: " + this.address);
                }
            }
            catch (Exception e) {
                try {
                    rmiServer.close();
                }
                catch (Exception x) {
                    // empty catch block
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw RMIConnectorServer.newIOException("Got unexpected exception while starting the connector server: " + e, e);
            }
        }
        this.rmiServerImpl = rmiServer;
        Set<RMIConnectorServer> set = openedServers;
        synchronized (set) {
            openedServers.add(this);
        }
        this.state = 1;
        if (tracing) {
            logger.trace("start", "Connector Server Address = " + this.address);
            logger.trace("start", "started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws IOException {
        IOException exception;
        boolean tracing;
        block24: {
            tracing = logger.traceOn();
            Object object = this;
            synchronized (object) {
                if (this.state == 2) {
                    if (tracing) {
                        logger.trace("stop", "already stopped.");
                    }
                    return;
                }
                if (this.state == 0 && tracing) {
                    logger.trace("stop", "not started yet.");
                }
                if (tracing) {
                    logger.trace("stop", "stopping.");
                }
                this.state = 2;
            }
            object = openedServers;
            synchronized (object) {
                openedServers.remove(this);
            }
            exception = null;
            if (this.rmiServerImpl != null) {
                try {
                    if (tracing) {
                        logger.trace("stop", "closing RMI server.");
                    }
                    this.rmiServerImpl.close();
                }
                catch (IOException e) {
                    if (tracing) {
                        logger.trace("stop", "failed to close RMI server: " + e);
                    }
                    if (logger.debugOn()) {
                        logger.debug("stop", e);
                    }
                    exception = e;
                }
            }
            if (this.boundJndiUrl != null) {
                try {
                    if (tracing) {
                        logger.trace("stop", "unbind from external directory: " + this.boundJndiUrl);
                    }
                    Hashtable<String, ?> usemap = EnvHelp.mapToHashtable(this.attributes);
                    InitialContext ctx = new InitialContext(usemap);
                    ctx.unbind(this.boundJndiUrl);
                    ctx.close();
                }
                catch (NamingException e) {
                    if (tracing) {
                        logger.trace("stop", "failed to unbind RMI server: " + e);
                    }
                    if (logger.debugOn()) {
                        logger.debug("stop", e);
                    }
                    if (exception != null) break block24;
                    exception = RMIConnectorServer.newIOException("Cannot bind to URL: " + e, e);
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (tracing) {
            logger.trace("stop", "stopped");
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.state == 1;
    }

    @Override
    public JMXServiceURL getAddress() {
        if (!this.isActive()) {
            return null;
        }
        return this.address;
    }

    @Override
    public Map<String, ?> getAttributes() {
        Map<String, ?> map = EnvHelp.filterAttributes(this.attributes);
        return Collections.unmodifiableMap(map);
    }

    @Override
    public synchronized void setMBeanServerForwarder(MBeanServerForwarder mbsf) {
        super.setMBeanServerForwarder(mbsf);
        if (this.rmiServerImpl != null) {
            this.rmiServerImpl.setMBeanServer(this.getMBeanServer());
        }
    }

    @Override
    protected void connectionOpened(String connectionId, String message, Object userData) {
        super.connectionOpened(connectionId, message, userData);
    }

    @Override
    protected void connectionClosed(String connectionId, String message, Object userData) {
        super.connectionClosed(connectionId, message, userData);
    }

    @Override
    protected void connectionFailed(String connectionId, String message, Object userData) {
        super.connectionFailed(connectionId, message, userData);
    }

    void bind(String jndiUrl, Hashtable<?, ?> attributes, RMIServer rmiServer, boolean rebind) throws NamingException, MalformedURLException {
        InitialContext ctx = new InitialContext(attributes);
        if (rebind) {
            ctx.rebind(jndiUrl, (Object)rmiServer);
        } else {
            ctx.bind(jndiUrl, (Object)rmiServer);
        }
        ctx.close();
    }

    RMIServerImpl newServer() throws IOException {
        boolean iiop = RMIConnectorServer.isIiopURL(this.address, true);
        int port = this.address == null ? 0 : this.address.getPort();
        if (iiop) {
            return RMIConnectorServer.newIIOPServer(this.attributes);
        }
        return RMIConnectorServer.newJRMPServer(this.attributes, port);
    }

    private void encodeStubInAddress(RMIServer rmiServer, Map<String, ?> attributes) throws IOException {
        int port;
        String host;
        String protocol;
        if (this.address == null) {
            protocol = IIOPHelper.isStub(rmiServer) ? "iiop" : "rmi";
            host = null;
            port = 0;
        } else {
            protocol = this.address.getProtocol();
            host = this.address.getHost().equals("") ? null : this.address.getHost();
            port = this.address.getPort();
        }
        String urlPath = RMIConnectorServer.encodeStub(rmiServer, attributes);
        this.address = new JMXServiceURL(protocol, host, port, urlPath);
    }

    static boolean isIiopURL(JMXServiceURL directoryURL, boolean strict) throws MalformedURLException {
        String protocol = directoryURL.getProtocol();
        if (protocol.equals("rmi")) {
            return false;
        }
        if (protocol.equals("iiop")) {
            return true;
        }
        if (strict) {
            throw new MalformedURLException("URL must have protocol \"rmi\" or \"iiop\": \"" + protocol + "\"");
        }
        return false;
    }

    static String encodeStub(RMIServer rmiServer, Map<String, ?> env) throws IOException {
        if (IIOPHelper.isStub(rmiServer)) {
            return "/ior/" + RMIConnectorServer.encodeIIOPStub(rmiServer, env);
        }
        return "/stub/" + RMIConnectorServer.encodeJRMPStub(rmiServer, env);
    }

    static String encodeJRMPStub(RMIServer rmiServer, Map<String, ?> env) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(rmiServer);
        oout.close();
        byte[] bytes = bout.toByteArray();
        return RMIConnectorServer.byteArrayToBase64(bytes);
    }

    static String encodeIIOPStub(RMIServer rmiServer, Map<String, ?> env) throws IOException {
        try {
            Object orb = IIOPHelper.getOrb(rmiServer);
            return IIOPHelper.objectToString(orb, rmiServer);
        }
        catch (RuntimeException x) {
            throw RMIConnectorServer.newIOException(x.getMessage(), x);
        }
    }

    private static RMIServer objectToBind(RMIServerImpl rmiServer, Map<String, ?> env) throws IOException {
        return RMIConnector.connectStub((RMIServer)rmiServer.toStub(), env);
    }

    private static RMIServerImpl newJRMPServer(Map<String, ?> env, int port) throws IOException {
        RMIClientSocketFactory csf = (RMIClientSocketFactory)env.get(RMI_CLIENT_SOCKET_FACTORY_ATTRIBUTE);
        RMIServerSocketFactory ssf = (RMIServerSocketFactory)env.get(RMI_SERVER_SOCKET_FACTORY_ATTRIBUTE);
        return new RMIJRMPServerImpl(port, csf, ssf, env);
    }

    private static RMIServerImpl newIIOPServer(Map<String, ?> env) throws IOException {
        return new RMIIIOPServerImpl(env);
    }

    private static String byteArrayToBase64(byte[] a) {
        int aLen = a.length;
        int numFullGroups = aLen / 3;
        int numBytesInPartialGroup = aLen - 3 * numFullGroups;
        int resultLen = 4 * ((aLen + 2) / 3);
        StringBuilder result = new StringBuilder(resultLen);
        int inCursor = 0;
        for (int i = 0; i < numFullGroups; ++i) {
            int byte0 = a[inCursor++] & 0xFF;
            int byte1 = a[inCursor++] & 0xFF;
            int byte2 = a[inCursor++] & 0xFF;
            result.append(intToAlpha[byte0 >> 2]);
            result.append(intToAlpha[byte0 << 4 & 0x3F | byte1 >> 4]);
            result.append(intToAlpha[byte1 << 2 & 0x3F | byte2 >> 6]);
            result.append(intToAlpha[byte2 & 0x3F]);
        }
        if (numBytesInPartialGroup != 0) {
            int byte0 = a[inCursor++] & 0xFF;
            result.append(intToAlpha[byte0 >> 2]);
            if (numBytesInPartialGroup == 1) {
                result.append(intToAlpha[byte0 << 4 & 0x3F]);
                result.append("==");
            } else {
                int byte1 = a[inCursor++] & 0xFF;
                result.append(intToAlpha[byte0 << 4 & 0x3F | byte1 >> 4]);
                result.append(intToAlpha[byte1 << 2 & 0x3F]);
                result.append('=');
            }
        }
        return result.toString();
    }

    private static IOException newIOException(String message, Throwable cause) {
        IOException x = new IOException(message);
        return EnvHelp.initCause(x, cause);
    }
}

