/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import sun.reflect.CallerSensitive;
import sun.reflect.Reflection;

public class Logger {
    private static final Handler[] emptyHandlers = new Handler[0];
    private static final int offValue = Level.OFF.intValue();
    private volatile LogManager manager;
    private String name;
    private final CopyOnWriteArrayList<Handler> handlers = new CopyOnWriteArrayList();
    private volatile String resourceBundleName;
    private volatile boolean useParentHandlers = true;
    private volatile Filter filter;
    private boolean anonymous;
    private ResourceBundle catalog;
    private String catalogName;
    private Locale catalogLocale;
    private static final Object treeLock = new Object();
    private volatile Logger parent;
    private ArrayList<LogManager.LoggerWeakRef> kids;
    private volatile Level levelObject;
    private volatile int levelValue;
    private WeakReference<ClassLoader> callersClassLoaderRef;
    private final boolean isSystemLogger;
    public static final String GLOBAL_LOGGER_NAME = "global";
    @Deprecated
    public static final Logger global = new Logger("global");
    static final String SYSTEM_LOGGER_RB_NAME = "sun.util.logging.resources.logging";

    public static final Logger getGlobal() {
        return global;
    }

    protected Logger(String name, String resourceBundleName) {
        this(name, resourceBundleName, null, false);
    }

    Logger(String name, String resourceBundleName, Class<?> caller, boolean isSystemLogger) {
        this.manager = LogManager.getLogManager();
        this.isSystemLogger = isSystemLogger;
        this.setupResourceInfo(resourceBundleName, caller);
        this.name = name;
        this.levelValue = Level.INFO.intValue();
    }

    private void setCallersClassLoaderRef(Class<?> caller) {
        ClassLoader callersClassLoader;
        ClassLoader classLoader = callersClassLoader = caller != null ? caller.getClassLoader() : null;
        if (callersClassLoader != null) {
            this.callersClassLoaderRef = new WeakReference<ClassLoader>(callersClassLoader);
        }
    }

    private ClassLoader getCallersClassLoader() {
        return this.callersClassLoaderRef != null ? (ClassLoader)this.callersClassLoaderRef.get() : null;
    }

    private Logger(String name) {
        this.name = name;
        this.isSystemLogger = true;
        this.levelValue = Level.INFO.intValue();
    }

    void setLogManager(LogManager manager) {
        this.manager = manager;
    }

    private void checkPermission() throws SecurityException {
        if (!this.anonymous) {
            if (this.manager == null) {
                this.manager = LogManager.getLogManager();
            }
            this.manager.checkPermission();
        }
    }

    private static Logger demandLogger(String name, String resourceBundleName, Class<?> caller) {
        LogManager manager = LogManager.getLogManager();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && !LoggerHelper.disableCallerCheck && caller.getClassLoader() == null) {
            return manager.demandSystemLogger(name, resourceBundleName);
        }
        return manager.demandLogger(name, resourceBundleName, caller);
    }

    @CallerSensitive
    public static Logger getLogger(String name) {
        return Logger.demandLogger(name, null, Reflection.getCallerClass());
    }

    @CallerSensitive
    public static Logger getLogger(String name, String resourceBundleName) {
        Class callerClass = Reflection.getCallerClass();
        Logger result = Logger.demandLogger(name, resourceBundleName, callerClass);
        if (result.resourceBundleName == null) {
            result.setupResourceInfo(resourceBundleName, callerClass);
        } else if (!result.resourceBundleName.equals(resourceBundleName)) {
            throw new IllegalArgumentException(result.resourceBundleName + " != " + resourceBundleName);
        }
        return result;
    }

    static Logger getPlatformLogger(String name) {
        LogManager manager = LogManager.getLogManager();
        Logger result = manager.demandSystemLogger(name, SYSTEM_LOGGER_RB_NAME);
        return result;
    }

    public static Logger getAnonymousLogger() {
        return Logger.getAnonymousLogger(null);
    }

    @CallerSensitive
    public static Logger getAnonymousLogger(String resourceBundleName) {
        LogManager manager = LogManager.getLogManager();
        manager.drainLoggerRefQueueBounded();
        Logger result = new Logger(null, resourceBundleName, Reflection.getCallerClass(), false);
        result.anonymous = true;
        Logger root = manager.getLogger("");
        result.doSetParent(root);
        return result;
    }

    public ResourceBundle getResourceBundle() {
        return this.findResourceBundle(this.getResourceBundleName(), true);
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setFilter(Filter newFilter) throws SecurityException {
        this.checkPermission();
        this.filter = newFilter;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public void log(LogRecord record) {
        if (record.getLevel().intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        Filter theFilter = this.filter;
        if (theFilter != null && !theFilter.isLoggable(record)) {
            return;
        }
        Logger logger = this;
        while (logger != null) {
            boolean useParentHdls;
            Handler[] loggerHandlers;
            for (Handler handler : loggerHandlers = this.isSystemLogger ? logger.accessCheckedHandlers() : logger.getHandlers()) {
                handler.publish(record);
            }
            boolean bl = useParentHdls = this.isSystemLogger ? logger.useParentHandlers : logger.getUseParentHandlers();
            if (!useParentHdls) break;
            logger = this.isSystemLogger ? logger.parent : logger.getParent();
        }
    }

    private void doLog(LogRecord lr) {
        lr.setLoggerName(this.name);
        String ebname = this.getEffectiveResourceBundleName();
        if (ebname != null && !ebname.equals(SYSTEM_LOGGER_RB_NAME)) {
            lr.setResourceBundleName(ebname);
            lr.setResourceBundle(this.findResourceBundle(ebname, true));
        }
        this.log(lr);
    }

    public void log(Level level, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void log(Level level, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr);
    }

    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    private void doLog(LogRecord lr, String rbname) {
        lr.setLoggerName(this.name);
        if (rbname != null) {
            lr.setResourceBundleName(rbname);
            lr.setResourceBundle(this.findResourceBundle(rbname, false));
        }
        this.log(lr);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object param1) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        Object[] params = new Object[]{param1};
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Object[] params) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setParameters(params);
        this.doLog(lr, bundleName);
    }

    public void logrb(Level level, String sourceClass, String sourceMethod, String bundleName, String msg, Throwable thrown) {
        if (level.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(level, msg);
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr, bundleName);
    }

    public void entering(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY");
    }

    public void entering(String sourceClass, String sourceMethod, Object param1) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{param1};
        this.logp(Level.FINER, sourceClass, sourceMethod, "ENTRY {0}", params);
    }

    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        String msg = "ENTRY";
        if (params == null) {
            this.logp(Level.FINER, sourceClass, sourceMethod, msg);
            return;
        }
        for (int i = 0; i < params.length; ++i) {
            msg = msg + " {" + i + "}";
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, msg, params);
    }

    public void exiting(String sourceClass, String sourceMethod) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN");
    }

    public void exiting(String sourceClass, String sourceMethod, Object result) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        Object[] params = new Object[]{result};
        this.logp(Level.FINER, sourceClass, sourceMethod, "RETURN {0}", result);
    }

    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        if (Level.FINER.intValue() < this.levelValue || this.levelValue == offValue) {
            return;
        }
        LogRecord lr = new LogRecord(Level.FINER, "THROW");
        lr.setSourceClassName(sourceClass);
        lr.setSourceMethodName(sourceMethod);
        lr.setThrown(thrown);
        this.doLog(lr);
    }

    public void severe(String msg) {
        if (Level.SEVERE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.SEVERE, msg);
    }

    public void warning(String msg) {
        if (Level.WARNING.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.WARNING, msg);
    }

    public void info(String msg) {
        if (Level.INFO.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.INFO, msg);
    }

    public void config(String msg) {
        if (Level.CONFIG.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.CONFIG, msg);
    }

    public void fine(String msg) {
        if (Level.FINE.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINE, msg);
    }

    public void finer(String msg) {
        if (Level.FINER.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINER, msg);
    }

    public void finest(String msg) {
        if (Level.FINEST.intValue() < this.levelValue) {
            return;
        }
        this.log(Level.FINEST, msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLevel(Level newLevel) throws SecurityException {
        this.checkPermission();
        Object object = treeLock;
        synchronized (object) {
            this.levelObject = newLevel;
            this.updateEffectiveLevel();
        }
    }

    public Level getLevel() {
        return this.levelObject;
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.levelValue && this.levelValue != offValue;
    }

    public String getName() {
        return this.name;
    }

    public void addHandler(Handler handler) throws SecurityException {
        handler.getClass();
        this.checkPermission();
        this.handlers.add(handler);
    }

    public void removeHandler(Handler handler) throws SecurityException {
        this.checkPermission();
        if (handler == null) {
            return;
        }
        this.handlers.remove(handler);
    }

    public Handler[] getHandlers() {
        return this.accessCheckedHandlers();
    }

    Handler[] accessCheckedHandlers() {
        return this.handlers.toArray(emptyHandlers);
    }

    public void setUseParentHandlers(boolean useParentHandlers) {
        this.checkPermission();
        this.useParentHandlers = useParentHandlers;
    }

    public boolean getUseParentHandlers() {
        return this.useParentHandlers;
    }

    private static ResourceBundle findSystemResourceBundle(final Locale locale) {
        return AccessController.doPrivileged(new PrivilegedAction<ResourceBundle>(){

            @Override
            public ResourceBundle run() {
                try {
                    return ResourceBundle.getBundle(Logger.SYSTEM_LOGGER_RB_NAME, locale, ClassLoader.getSystemClassLoader());
                }
                catch (MissingResourceException e) {
                    throw new InternalError(e.toString());
                }
            }
        });
    }

    private synchronized ResourceBundle findResourceBundle(String name, boolean useCallersClassLoader) {
        if (name == null) {
            return null;
        }
        Locale currentLocale = Locale.getDefault();
        if (this.catalog != null && currentLocale.equals(this.catalogLocale) && name.equals(this.catalogName)) {
            return this.catalog;
        }
        if (name.equals(SYSTEM_LOGGER_RB_NAME)) {
            this.catalog = Logger.findSystemResourceBundle(currentLocale);
            this.catalogName = name;
            this.catalogLocale = currentLocale;
            return this.catalog;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        try {
            this.catalog = ResourceBundle.getBundle(name, currentLocale, cl);
            this.catalogName = name;
            this.catalogLocale = currentLocale;
            return this.catalog;
        }
        catch (MissingResourceException ex) {
            ClassLoader callersClassLoader;
            if (useCallersClassLoader && (callersClassLoader = this.getCallersClassLoader()) != null && callersClassLoader != cl) {
                try {
                    this.catalog = ResourceBundle.getBundle(name, currentLocale, callersClassLoader);
                    this.catalogName = name;
                    this.catalogLocale = currentLocale;
                    return this.catalog;
                }
                catch (MissingResourceException ex2) {
                    // empty catch block
                }
            }
            if (LoggerHelper.allowStackWalkSearch) {
                return this.findResourceBundleFromStack(name, currentLocale, cl);
            }
            return null;
        }
    }

    @CallerSensitive
    private synchronized ResourceBundle findResourceBundleFromStack(String name, Locale locale, ClassLoader cl) {
        Class clz;
        int ix = 0;
        while ((clz = Reflection.getCallerClass(ix)) != null) {
            ClassLoader cl2 = clz.getClassLoader();
            if (cl2 == null) {
                cl2 = ClassLoader.getSystemClassLoader();
            }
            if (cl != cl2) {
                cl = cl2;
                try {
                    this.catalog = ResourceBundle.getBundle(name, locale, cl);
                    this.catalogName = name;
                    this.catalogLocale = locale;
                    return this.catalog;
                }
                catch (MissingResourceException ex) {
                    // empty catch block
                }
            }
            ++ix;
        }
        return null;
    }

    private synchronized void setupResourceInfo(String name, Class<?> callersClass) {
        if (name == null) {
            return;
        }
        this.setCallersClassLoaderRef(callersClass);
        if (this.isSystemLogger && this.getCallersClassLoader() != null) {
            this.checkPermission();
        }
        if (this.findResourceBundle(name, true) == null) {
            this.callersClassLoaderRef = null;
            throw new MissingResourceException("Can't find " + name + " bundle", name, "");
        }
        this.resourceBundleName = name;
    }

    public Logger getParent() {
        return this.parent;
    }

    public void setParent(Logger parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        if (this.manager == null) {
            this.manager = LogManager.getLogManager();
        }
        this.manager.checkPermission();
        this.doSetParent(parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetParent(Logger newParent) {
        Object object = treeLock;
        synchronized (object) {
            LogManager.LoggerWeakRef ref = null;
            if (this.parent != null) {
                Iterator<LogManager.LoggerWeakRef> iter = this.parent.kids.iterator();
                while (iter.hasNext()) {
                    ref = iter.next();
                    Logger kid = (Logger)ref.get();
                    if (kid == this) {
                        iter.remove();
                        break;
                    }
                    ref = null;
                }
            }
            this.parent = newParent;
            if (this.parent.kids == null) {
                this.parent.kids = new ArrayList(2);
            }
            if (ref == null) {
                LogManager logManager = this.manager;
                logManager.getClass();
                ref = logManager.new LogManager.LoggerWeakRef(this);
            }
            ref.setParentRef(new WeakReference<Logger>(this.parent));
            this.parent.kids.add(ref);
            this.updateEffectiveLevel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeChildLogger(LogManager.LoggerWeakRef child) {
        Object object = treeLock;
        synchronized (object) {
            Iterator<LogManager.LoggerWeakRef> iter = this.kids.iterator();
            while (iter.hasNext()) {
                LogManager.LoggerWeakRef ref = iter.next();
                if (ref != child) continue;
                iter.remove();
                return;
            }
        }
    }

    private void updateEffectiveLevel() {
        int newLevelValue = this.levelObject != null ? this.levelObject.intValue() : (this.parent != null ? this.parent.levelValue : Level.INFO.intValue());
        if (this.levelValue == newLevelValue) {
            return;
        }
        this.levelValue = newLevelValue;
        if (this.kids != null) {
            for (int i = 0; i < this.kids.size(); ++i) {
                LogManager.LoggerWeakRef ref = this.kids.get(i);
                Logger kid = (Logger)ref.get();
                if (kid == null) continue;
                kid.updateEffectiveLevel();
            }
        }
    }

    private String getEffectiveResourceBundleName() {
        Logger target = this;
        while (target != null) {
            String rbn;
            String string = this.isSystemLogger ? (target.isSystemLogger ? target.resourceBundleName : null) : (rbn = target.getResourceBundleName());
            if (rbn != null) {
                return rbn;
            }
            target = this.isSystemLogger ? target.parent : target.getParent();
        }
        return null;
    }

    private static class LoggerHelper {
        static boolean disableCallerCheck = LoggerHelper.getBooleanProperty("sun.util.logging.disableCallerCheck");
        static boolean allowStackWalkSearch = LoggerHelper.getBooleanProperty("jdk.logging.allowStackWalkSearch");

        private LoggerHelper() {
        }

        private static boolean getBooleanProperty(final String key) {
            String s = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty(key);
                }
            });
            return Boolean.valueOf(s);
        }
    }
}

