/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.utils.UnsyncByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecurityPermission;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JavaUtils {
    static Logger log = Logger.getLogger(JavaUtils.class.getName());
    private static final SecurityPermission REGISTER_PERMISSION = new SecurityPermission("com.sun.org.apache.xml.internal.security.register");

    private JavaUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(String fileName) throws FileNotFoundException, IOException {
        byte[] refBytes = null;
        try (FileInputStream fisRef = new FileInputStream(fileName);){
            int len;
            UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = fisRef.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            refBytes = baos.toByteArray();
        }
        return refBytes;
    }

    public static void writeBytesToFilename(String filename, byte[] bytes) {
        block6: {
            FileOutputStream fos = null;
            try {
                if (filename != null && bytes != null) {
                    File f = new File(filename);
                    fos = new FileOutputStream(f);
                    fos.write(bytes);
                    fos.close();
                } else {
                    log.log(Level.FINE, "writeBytesToFilename got null byte[] pointed");
                }
            }
            catch (IOException ex) {
                if (fos == null) break block6;
                try {
                    fos.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    public static byte[] getBytesFromStream(InputStream inputStream) throws IOException {
        int len;
        byte[] refBytes = null;
        UnsyncByteArrayOutputStream baos = new UnsyncByteArrayOutputStream();
        byte[] buf = new byte[1024];
        while ((len = inputStream.read(buf)) > 0) {
            baos.write(buf, 0, len);
        }
        refBytes = baos.toByteArray();
        return refBytes;
    }

    public static void checkRegisterPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(REGISTER_PERMISSION);
        }
    }
}

