/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsTextUI;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TextUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Highlighter;
import javax.swing.text.Position;

public class WindowsTextFieldUI
extends BasicTextFieldUI {
    public static ComponentUI createUI(JComponent c) {
        return new WindowsTextFieldUI();
    }

    @Override
    protected void paintBackground(Graphics g) {
        super.paintBackground(g);
    }

    @Override
    protected Caret createCaret() {
        return new WindowsFieldCaret();
    }

    static class WindowsFieldCaret
    extends DefaultCaret
    implements UIResource {
        @Override
        protected void adjustVisibility(Rectangle r) {
            SwingUtilities.invokeLater(new SafeScroller(r));
        }

        @Override
        protected Highlighter.HighlightPainter getSelectionPainter() {
            return WindowsTextUI.WindowsPainter;
        }

        private class SafeScroller
        implements Runnable {
            private Rectangle r;

            SafeScroller(Rectangle r) {
                this.r = r;
            }

            @Override
            public void run() {
                JTextField field = (JTextField)WindowsFieldCaret.this.getComponent();
                if (field != null) {
                    TextUI ui = field.getUI();
                    int dot = WindowsFieldCaret.this.getDot();
                    Position.Bias bias = Position.Bias.Forward;
                    Rectangle startRect = null;
                    try {
                        startRect = ui.modelToView(field, dot, bias);
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                    Insets i = field.getInsets();
                    BoundedRangeModel vis = field.getHorizontalVisibility();
                    int x = this.r.x + vis.getValue() - i.left;
                    int quarterSpan = vis.getExtent() / 4;
                    if (this.r.x < i.left) {
                        vis.setValue(x - quarterSpan);
                    } else if (this.r.x + this.r.width > i.left + vis.getExtent()) {
                        vis.setValue(x - 3 * quarterSpan);
                    }
                    if (startRect != null) {
                        try {
                            Rectangle endRect = ui.modelToView(field, dot, bias);
                            if (endRect != null && !endRect.equals(startRect)) {
                                WindowsFieldCaret.this.damage(endRect);
                            }
                        }
                        catch (BadLocationException ble) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }
}

