/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProviderException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLProtocolException;
import sun.misc.HexDumpEncoder;
import sun.security.internal.spec.TlsKeyMaterialParameterSpec;
import sun.security.internal.spec.TlsKeyMaterialSpec;
import sun.security.internal.spec.TlsMasterSecretParameterSpec;
import sun.security.ssl.CipherBox;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.CipherSuiteList;
import sun.security.ssl.Debug;
import sun.security.ssl.EngineOutputRecord;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeInStream;
import sun.security.ssl.HandshakeMessage;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.InputRecord;
import sun.security.ssl.JsseJce;
import sun.security.ssl.MAC;
import sun.security.ssl.OutputRecord;
import sun.security.ssl.ProtocolList;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLEngineImpl;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SSLSocketImpl;
import sun.security.ssl.SignatureAndHashAlgorithm;

abstract class Handshaker {
    ProtocolVersion protocolVersion;
    ProtocolVersion activeProtocolVersion;
    boolean secureRenegotiation;
    byte[] clientVerifyData;
    byte[] serverVerifyData;
    boolean isInitialHandshake;
    private ProtocolList enabledProtocols;
    private CipherSuiteList enabledCipherSuites;
    String identificationProtocol;
    private AlgorithmConstraints algorithmConstraints = null;
    Collection<SignatureAndHashAlgorithm> localSupportedSignAlgs;
    Collection<SignatureAndHashAlgorithm> peerSupportedSignAlgs;
    private ProtocolList activeProtocols;
    private CipherSuiteList activeCipherSuites;
    private boolean isClient;
    private boolean needCertVerify;
    SSLSocketImpl conn = null;
    SSLEngineImpl engine = null;
    HandshakeHash handshakeHash;
    HandshakeInStream input;
    HandshakeOutStream output;
    int state;
    SSLContextImpl sslContext;
    RandomCookie clnt_random;
    RandomCookie svr_random;
    SSLSessionImpl session;
    CipherSuite cipherSuite;
    CipherSuite.KeyExchange keyExchange;
    boolean resumingSession;
    boolean enableNewSession;
    private SecretKey clntWriteKey;
    private SecretKey svrWriteKey;
    private IvParameterSpec clntWriteIV;
    private IvParameterSpec svrWriteIV;
    private SecretKey clntMacSecret;
    private SecretKey svrMacSecret;
    private volatile boolean taskDelegated = false;
    private volatile DelegatedTask delegatedTask = null;
    private volatile Exception thrown = null;
    private Object thrownLock = new Object();
    static final Debug debug = Debug.getInstance("ssl");
    static final boolean allowUnsafeRenegotiation = Debug.getBooleanProperty("sun.security.ssl.allowUnsafeRenegotiation", false);
    static final boolean allowLegacyHelloMessages = Debug.getBooleanProperty("sun.security.ssl.allowLegacyHelloMessages", true);
    boolean invalidated;

    Handshaker(SSLSocketImpl c, SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        this.conn = c;
        this.init(context, enabledProtocols, needCertVerify, isClient, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    Handshaker(SSLEngineImpl engine, SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        this.engine = engine;
        this.init(context, enabledProtocols, needCertVerify, isClient, activeProtocolVersion, isInitialHandshake, secureRenegotiation, clientVerifyData, serverVerifyData);
    }

    private void init(SSLContextImpl context, ProtocolList enabledProtocols, boolean needCertVerify, boolean isClient, ProtocolVersion activeProtocolVersion, boolean isInitialHandshake, boolean secureRenegotiation, byte[] clientVerifyData, byte[] serverVerifyData) {
        if (debug != null && Debug.isOn("handshake")) {
            System.out.println("Allow unsafe renegotiation: " + allowUnsafeRenegotiation + "\nAllow legacy hello messages: " + allowLegacyHelloMessages + "\nIs initial handshake: " + isInitialHandshake + "\nIs secure renegotiation: " + secureRenegotiation);
        }
        this.sslContext = context;
        this.isClient = isClient;
        this.needCertVerify = needCertVerify;
        this.activeProtocolVersion = activeProtocolVersion;
        this.isInitialHandshake = isInitialHandshake;
        this.secureRenegotiation = secureRenegotiation;
        this.clientVerifyData = clientVerifyData;
        this.serverVerifyData = serverVerifyData;
        this.enableNewSession = true;
        this.invalidated = false;
        this.setCipherSuite(CipherSuite.C_NULL);
        this.setEnabledProtocols(enabledProtocols);
        this.algorithmConstraints = this.conn != null ? new SSLAlgorithmConstraints(this.conn, true) : new SSLAlgorithmConstraints(this.engine, true);
        this.state = -2;
    }

    void fatalSE(byte b, String diagnostic) throws IOException {
        this.fatalSE(b, diagnostic, null);
    }

    void fatalSE(byte b, Throwable cause) throws IOException {
        this.fatalSE(b, null, cause);
    }

    void fatalSE(byte b, String diagnostic, Throwable cause) throws IOException {
        if (this.conn != null) {
            this.conn.fatal(b, diagnostic, cause);
        } else {
            this.engine.fatal(b, diagnostic, cause);
        }
    }

    void warningSE(byte b) {
        if (this.conn != null) {
            this.conn.warning(b);
        } else {
            this.engine.warning(b);
        }
    }

    String getRawHostnameSE() {
        if (this.conn != null) {
            return this.conn.getRawHostname();
        }
        return this.engine.getPeerHost();
    }

    String getHostSE() {
        if (this.conn != null) {
            return this.conn.getHost();
        }
        return this.engine.getPeerHost();
    }

    String getHostAddressSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().getHostAddress();
        }
        return this.engine.getPeerHost();
    }

    boolean isLoopbackSE() {
        if (this.conn != null) {
            return this.conn.getInetAddress().isLoopbackAddress();
        }
        return false;
    }

    int getPortSE() {
        if (this.conn != null) {
            return this.conn.getPort();
        }
        return this.engine.getPeerPort();
    }

    int getLocalPortSE() {
        if (this.conn != null) {
            return this.conn.getLocalPort();
        }
        return -1;
    }

    AccessControlContext getAccSE() {
        if (this.conn != null) {
            return this.conn.getAcc();
        }
        return this.engine.getAcc();
    }

    String getEndpointIdentificationAlgorithmSE() {
        SSLParameters paras = this.conn != null ? this.conn.getSSLParameters() : this.engine.getSSLParameters();
        return paras.getEndpointIdentificationAlgorithm();
    }

    private void setVersionSE(ProtocolVersion protocolVersion) {
        if (this.conn != null) {
            this.conn.setVersion(protocolVersion);
        } else {
            this.engine.setVersion(protocolVersion);
        }
    }

    void setVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.setVersionSE(protocolVersion);
        this.output.r.setVersion(protocolVersion);
    }

    void setEnabledProtocols(ProtocolList enabledProtocols) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.enabledProtocols = enabledProtocols;
    }

    void setEnabledCipherSuites(CipherSuiteList enabledCipherSuites) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.enabledCipherSuites = enabledCipherSuites;
    }

    void setAlgorithmConstraints(AlgorithmConstraints algorithmConstraints) {
        this.activeCipherSuites = null;
        this.activeProtocols = null;
        this.algorithmConstraints = new SSLAlgorithmConstraints(algorithmConstraints);
        this.localSupportedSignAlgs = null;
    }

    Collection<SignatureAndHashAlgorithm> getLocalSupportedSignAlgs() {
        if (this.localSupportedSignAlgs == null) {
            this.localSupportedSignAlgs = SignatureAndHashAlgorithm.getSupportedAlgorithms(this.algorithmConstraints);
        }
        return this.localSupportedSignAlgs;
    }

    void setPeerSupportedSignAlgs(Collection<SignatureAndHashAlgorithm> algorithms) {
        this.peerSupportedSignAlgs = new ArrayList<SignatureAndHashAlgorithm>(algorithms);
    }

    Collection<SignatureAndHashAlgorithm> getPeerSupportedSignAlgs() {
        return this.peerSupportedSignAlgs;
    }

    void setIdentificationProtocol(String protocol) {
        this.identificationProtocol = protocol;
    }

    void activate(ProtocolVersion helloVersion) throws IOException {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        if (this.activeProtocols.collection().isEmpty() || this.activeProtocols.max.v == ProtocolVersion.NONE.v) {
            throw new SSLHandshakeException("No appropriate protocol");
        }
        if (this.activeCipherSuites == null) {
            this.activeCipherSuites = this.getActiveCipherSuites();
        }
        if (this.activeCipherSuites.collection().isEmpty()) {
            throw new SSLHandshakeException("No appropriate cipher suite");
        }
        this.protocolVersion = !this.isInitialHandshake ? this.activeProtocolVersion : this.activeProtocols.max;
        if (helloVersion == null || helloVersion.v == ProtocolVersion.NONE.v) {
            helloVersion = this.activeProtocols.helloVersion;
        }
        Set<String> localSupportedHashAlgorithms = SignatureAndHashAlgorithm.getHashAlgorithmNames(this.getLocalSupportedSignAlgs());
        this.handshakeHash = new HandshakeHash(!this.isClient, this.needCertVerify, localSupportedHashAlgorithms);
        this.input = new HandshakeInStream(this.handshakeHash);
        if (this.conn != null) {
            this.output = new HandshakeOutStream(this.protocolVersion, helloVersion, this.handshakeHash, this.conn);
            this.conn.getAppInputStream().r.setHandshakeHash(this.handshakeHash);
            this.conn.getAppInputStream().r.setHelloVersion(helloVersion);
            this.conn.getAppOutputStream().r.setHelloVersion(helloVersion);
        } else {
            this.output = new HandshakeOutStream(this.protocolVersion, helloVersion, this.handshakeHash, this.engine);
            this.engine.inputRecord.setHandshakeHash(this.handshakeHash);
            this.engine.inputRecord.setHelloVersion(helloVersion);
            this.engine.outputRecord.setHelloVersion(helloVersion);
        }
        this.state = -1;
    }

    void setCipherSuite(CipherSuite s) {
        this.cipherSuite = s;
        this.keyExchange = s.keyExchange;
    }

    boolean isNegotiable(CipherSuite s) {
        if (this.activeCipherSuites == null) {
            this.activeCipherSuites = this.getActiveCipherSuites();
        }
        return this.activeCipherSuites.contains(s) && s.isNegotiable();
    }

    boolean isNegotiable(ProtocolVersion protocolVersion) {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        return this.activeProtocols.contains(protocolVersion);
    }

    ProtocolVersion selectProtocolVersion(ProtocolVersion protocolVersion) {
        if (this.activeProtocols == null) {
            this.activeProtocols = this.getActiveProtocols();
        }
        return this.activeProtocols.selectProtocolVersion(protocolVersion);
    }

    CipherSuiteList getActiveCipherSuites() {
        if (this.activeCipherSuites == null) {
            if (this.activeProtocols == null) {
                this.activeProtocols = this.getActiveProtocols();
            }
            ArrayList<CipherSuite> suites = new ArrayList<CipherSuite>();
            if (!this.activeProtocols.collection().isEmpty() && this.activeProtocols.min.v != ProtocolVersion.NONE.v) {
                for (CipherSuite suite : this.enabledCipherSuites.collection()) {
                    if (suite.obsoleted > this.activeProtocols.min.v && suite.supported <= this.activeProtocols.max.v) {
                        if (!this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), suite.name, null)) continue;
                        suites.add(suite);
                        continue;
                    }
                    if (debug == null || !Debug.isOn("verbose")) continue;
                    if (suite.obsoleted <= this.activeProtocols.min.v) {
                        System.out.println("Ignoring obsoleted cipher suite: " + suite);
                        continue;
                    }
                    System.out.println("Ignoring unsupported cipher suite: " + suite);
                }
            }
            this.activeCipherSuites = new CipherSuiteList(suites);
        }
        return this.activeCipherSuites;
    }

    ProtocolList getActiveProtocols() {
        if (this.activeProtocols == null) {
            ArrayList<ProtocolVersion> protocols = new ArrayList<ProtocolVersion>(4);
            for (ProtocolVersion protocol : this.enabledProtocols.collection()) {
                boolean found = false;
                for (CipherSuite suite : this.enabledCipherSuites.collection()) {
                    if (suite.isAvailable() && suite.obsoleted > protocol.v && suite.supported <= protocol.v) {
                        if (this.algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), suite.name, null)) {
                            protocols.add(protocol);
                            found = true;
                            break;
                        }
                        if (debug == null || !Debug.isOn("verbose")) continue;
                        System.out.println("Ignoring disabled cipher suite: " + suite + " for " + protocol);
                        continue;
                    }
                    if (debug == null || !Debug.isOn("verbose")) continue;
                    System.out.println("Ignoring unsupported cipher suite: " + suite + " for " + protocol);
                }
                if (found || debug == null || !Debug.isOn("handshake")) continue;
                System.out.println("No available cipher suite for " + protocol);
            }
            this.activeProtocols = new ProtocolList(protocols);
        }
        return this.activeProtocols;
    }

    void setEnableSessionCreation(boolean newSessions) {
        this.enableNewSession = newSessions;
    }

    CipherBox newReadCipher() throws NoSuchAlgorithmException {
        CipherBox box;
        CipherSuite.BulkCipher cipher = this.cipherSuite.cipher;
        if (this.isClient) {
            box = cipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, this.sslContext.getSecureRandom(), false);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        } else {
            box = cipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, this.sslContext.getSecureRandom(), false);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        }
        return box;
    }

    CipherBox newWriteCipher() throws NoSuchAlgorithmException {
        CipherBox box;
        CipherSuite.BulkCipher cipher = this.cipherSuite.cipher;
        if (this.isClient) {
            box = cipher.newCipher(this.protocolVersion, this.clntWriteKey, this.clntWriteIV, this.sslContext.getSecureRandom(), true);
            this.clntWriteKey = null;
            this.clntWriteIV = null;
        } else {
            box = cipher.newCipher(this.protocolVersion, this.svrWriteKey, this.svrWriteIV, this.sslContext.getSecureRandom(), true);
            this.svrWriteKey = null;
            this.svrWriteIV = null;
        }
        return box;
    }

    MAC newReadMAC() throws NoSuchAlgorithmException, InvalidKeyException {
        MAC mac;
        CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
        if (this.isClient) {
            mac = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
            this.svrMacSecret = null;
        } else {
            mac = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
            this.clntMacSecret = null;
        }
        return mac;
    }

    MAC newWriteMAC() throws NoSuchAlgorithmException, InvalidKeyException {
        MAC mac;
        CipherSuite.MacAlg macAlg = this.cipherSuite.macAlg;
        if (this.isClient) {
            mac = macAlg.newMac(this.protocolVersion, this.clntMacSecret);
            this.clntMacSecret = null;
        } else {
            mac = macAlg.newMac(this.protocolVersion, this.svrMacSecret);
            this.svrMacSecret = null;
        }
        return mac;
    }

    boolean isDone() {
        return this.state == 20;
    }

    SSLSessionImpl getSession() {
        return this.session;
    }

    void setHandshakeSessionSE(SSLSessionImpl handshakeSession) {
        if (this.conn != null) {
            this.conn.setHandshakeSession(handshakeSession);
        } else {
            this.engine.setHandshakeSession(handshakeSession);
        }
    }

    boolean isSecureRenegotiation() {
        return this.secureRenegotiation;
    }

    byte[] getClientVerifyData() {
        return this.clientVerifyData;
    }

    byte[] getServerVerifyData() {
        return this.serverVerifyData;
    }

    void process_record(InputRecord r, boolean expectingFinished) throws IOException {
        this.checkThrown();
        this.input.incomingRecord(r);
        if (this.conn != null || expectingFinished) {
            this.processLoop();
        } else {
            this.delegateTask(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    Handshaker.this.processLoop();
                    return null;
                }
            });
        }
    }

    void processLoop() throws IOException {
        while (this.input.available() >= 4) {
            this.input.mark(4);
            byte messageType = (byte)this.input.getInt8();
            int messageLen = this.input.getInt24();
            if (this.input.available() < messageLen) {
                this.input.reset();
                return;
            }
            if (messageType == 0) {
                this.input.reset();
                this.processMessage(messageType, messageLen);
                this.input.ignore(4 + messageLen);
                continue;
            }
            this.input.mark(messageLen);
            this.processMessage(messageType, messageLen);
            this.input.digestNow();
        }
    }

    boolean activated() {
        return this.state >= -1;
    }

    boolean started() {
        return this.state >= 0;
    }

    void kickstart() throws IOException {
        if (this.state >= 0) {
            return;
        }
        HandshakeMessage m = this.getKickstartMessage();
        if (debug != null && Debug.isOn("handshake")) {
            m.print(System.out);
        }
        m.write(this.output);
        this.output.flush();
        this.state = m.messageType();
    }

    abstract HandshakeMessage getKickstartMessage() throws SSLException;

    abstract void processMessage(byte var1, int var2) throws IOException;

    abstract void handshakeAlert(byte var1) throws SSLProtocolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendChangeCipherSpec(HandshakeMessage.Finished mesg, boolean lastMessage) throws IOException {
        this.output.flush();
        OutputRecord r = this.conn != null ? new OutputRecord(20) : new EngineOutputRecord(20, this.engine);
        r.setVersion(this.protocolVersion);
        r.write(1);
        if (this.conn != null) {
            this.conn.writeLock.lock();
            try {
                this.conn.writeRecord(r);
                this.conn.changeWriteCiphers();
                if (debug != null && Debug.isOn("handshake")) {
                    mesg.print(System.out);
                }
                mesg.write(this.output);
                this.output.flush();
            }
            finally {
                this.conn.writeLock.unlock();
            }
        }
        Object object = this.engine.writeLock;
        synchronized (object) {
            this.engine.writeRecord((EngineOutputRecord)r);
            this.engine.changeWriteCiphers();
            if (debug != null && Debug.isOn("handshake")) {
                mesg.print(System.out);
            }
            mesg.write(this.output);
            if (lastMessage) {
                this.output.setFinishedMsg();
            }
            this.output.flush();
        }
    }

    void calculateKeys(SecretKey preMasterSecret, ProtocolVersion version) {
        SecretKey master = this.calculateMasterSecret(preMasterSecret, version);
        this.session.setMasterSecret(master);
        this.calculateConnectionKeys(master);
    }

    private SecretKey calculateMasterSecret(SecretKey preMasterSecret, ProtocolVersion requestedVersion) {
        CipherSuite.PRF prf;
        String masterAlg;
        if (debug != null && Debug.isOn("keygen")) {
            HexDumpEncoder dump = new HexDumpEncoder();
            System.out.println("SESSION KEYGEN:");
            System.out.println("PreMaster Secret:");
            Handshaker.printHex(dump, preMasterSecret.getEncoded());
        }
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            masterAlg = "SunTls12MasterSecret";
            prf = this.cipherSuite.prfAlg;
        } else {
            masterAlg = "SunTlsMasterSecret";
            prf = CipherSuite.PRF.P_NONE;
        }
        String prfHashAlg = prf.getPRFHashAlg();
        int prfHashLength = prf.getPRFHashLength();
        int prfBlockSize = prf.getPRFBlockSize();
        TlsMasterSecretParameterSpec spec = new TlsMasterSecretParameterSpec(preMasterSecret, this.protocolVersion.major, this.protocolVersion.minor, this.clnt_random.random_bytes, this.svr_random.random_bytes, prfHashAlg, prfHashLength, prfBlockSize);
        try {
            KeyGenerator kg = JsseJce.getKeyGenerator(masterAlg);
            kg.init(spec);
            return kg.generateKey();
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException iae) {
            if (debug != null && Debug.isOn("handshake")) {
                System.out.println("RSA master secret generation error:");
                iae.printStackTrace(System.out);
            }
            throw new ProviderException(iae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateConnectionKeys(SecretKey masterKey) {
        CipherSuite.PRF prf;
        String keyMaterialAlg;
        int expandedKeySize;
        int hashSize = this.cipherSuite.macAlg.size;
        boolean is_exportable = this.cipherSuite.exportable;
        CipherSuite.BulkCipher cipher = this.cipherSuite.cipher;
        int n = expandedKeySize = is_exportable ? cipher.expandedKeySize : 0;
        if (this.protocolVersion.v >= ProtocolVersion.TLS12.v) {
            keyMaterialAlg = "SunTls12KeyMaterial";
            prf = this.cipherSuite.prfAlg;
        } else {
            keyMaterialAlg = "SunTlsKeyMaterial";
            prf = CipherSuite.PRF.P_NONE;
        }
        String prfHashAlg = prf.getPRFHashAlg();
        int prfHashLength = prf.getPRFHashLength();
        int prfBlockSize = prf.getPRFBlockSize();
        TlsKeyMaterialParameterSpec spec = new TlsKeyMaterialParameterSpec(masterKey, this.protocolVersion.major, this.protocolVersion.minor, this.clnt_random.random_bytes, this.svr_random.random_bytes, cipher.algorithm, cipher.keySize, expandedKeySize, cipher.ivSize, hashSize, prfHashAlg, prfHashLength, prfBlockSize);
        try {
            KeyGenerator kg = JsseJce.getKeyGenerator(keyMaterialAlg);
            kg.init(spec);
            TlsKeyMaterialSpec keySpec = (TlsKeyMaterialSpec)kg.generateKey();
            this.clntWriteKey = keySpec.getClientCipherKey();
            this.svrWriteKey = keySpec.getServerCipherKey();
            this.clntWriteIV = keySpec.getClientIv();
            this.svrWriteIV = keySpec.getServerIv();
            this.clntMacSecret = keySpec.getClientMacKey();
            this.svrMacSecret = keySpec.getServerMacKey();
        }
        catch (GeneralSecurityException e) {
            throw new ProviderException(e);
        }
        if (debug != null && Debug.isOn("keygen")) {
            PrintStream printStream = System.out;
            synchronized (printStream) {
                HexDumpEncoder dump = new HexDumpEncoder();
                System.out.println("CONNECTION KEYGEN:");
                System.out.println("Client Nonce:");
                Handshaker.printHex(dump, this.clnt_random.random_bytes);
                System.out.println("Server Nonce:");
                Handshaker.printHex(dump, this.svr_random.random_bytes);
                System.out.println("Master Secret:");
                Handshaker.printHex(dump, masterKey.getEncoded());
                System.out.println("Client MAC write Secret:");
                Handshaker.printHex(dump, this.clntMacSecret.getEncoded());
                System.out.println("Server MAC write Secret:");
                Handshaker.printHex(dump, this.svrMacSecret.getEncoded());
                if (this.clntWriteKey != null) {
                    System.out.println("Client write key:");
                    Handshaker.printHex(dump, this.clntWriteKey.getEncoded());
                    System.out.println("Server write key:");
                    Handshaker.printHex(dump, this.svrWriteKey.getEncoded());
                } else {
                    System.out.println("... no encryption keys used");
                }
                if (this.clntWriteIV != null) {
                    System.out.println("Client write IV:");
                    Handshaker.printHex(dump, this.clntWriteIV.getIV());
                    System.out.println("Server write IV:");
                    Handshaker.printHex(dump, this.svrWriteIV.getIV());
                } else if (this.protocolVersion.v >= ProtocolVersion.TLS11.v) {
                    System.out.println("... no IV derived for this protocol");
                } else {
                    System.out.println("... no IV used for this cipher");
                }
                System.out.flush();
            }
        }
    }

    private static void printHex(HexDumpEncoder dump, byte[] bytes) {
        if (bytes == null) {
            System.out.println("(key bytes not available)");
        } else {
            try {
                dump.encodeBuffer(bytes, (OutputStream)System.out);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void throwSSLException(String msg, Throwable cause) throws SSLException {
        SSLException e = new SSLException(msg);
        e.initCause(cause);
        throw e;
    }

    private <T> void delegateTask(PrivilegedExceptionAction<T> pea) {
        this.delegatedTask = new DelegatedTask<T>(pea);
        this.taskDelegated = false;
        this.thrown = null;
    }

    DelegatedTask getTask() {
        if (!this.taskDelegated) {
            this.taskDelegated = true;
            return this.delegatedTask;
        }
        return null;
    }

    boolean taskOutstanding() {
        return this.delegatedTask != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkThrown() throws SSLException {
        Object object = this.thrownLock;
        synchronized (object) {
            if (this.thrown != null) {
                String msg = this.thrown.getMessage();
                if (msg == null) {
                    msg = "Delegated task threw Exception/Error";
                }
                Exception e = this.thrown;
                this.thrown = null;
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)new RuntimeException(msg).initCause(e);
                }
                if (e instanceof SSLHandshakeException) {
                    throw (SSLHandshakeException)new SSLHandshakeException(msg).initCause(e);
                }
                if (e instanceof SSLKeyException) {
                    throw (SSLKeyException)new SSLKeyException(msg).initCause(e);
                }
                if (e instanceof SSLPeerUnverifiedException) {
                    throw (SSLPeerUnverifiedException)new SSLPeerUnverifiedException(msg).initCause(e);
                }
                if (e instanceof SSLProtocolException) {
                    throw (SSLProtocolException)new SSLProtocolException(msg).initCause(e);
                }
                throw (SSLException)new SSLException(msg).initCause(e);
            }
        }
    }

    class DelegatedTask<E>
    implements Runnable {
        private PrivilegedExceptionAction<E> pea;

        DelegatedTask(PrivilegedExceptionAction<E> pea) {
            this.pea = pea;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SSLEngineImpl sSLEngineImpl = Handshaker.this.engine;
            synchronized (sSLEngineImpl) {
                try {
                    AccessController.doPrivileged(this.pea, Handshaker.this.engine.getAcc());
                }
                catch (PrivilegedActionException pae) {
                    Handshaker.this.thrown = pae.getException();
                }
                catch (RuntimeException rte) {
                    Handshaker.this.thrown = rte;
                }
                Handshaker.this.delegatedTask = null;
                Handshaker.this.taskDelegated = false;
            }
        }
    }
}

