/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.AccessFlags;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.Instance;
import sun.jvm.hotspot.oops.IntField;
import sun.jvm.hotspot.oops.Metadata;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.ClassConstants;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;

public class Klass
extends Metadata
implements ClassConstants {
    public static int LH_INSTANCE_SLOW_PATH_BIT;
    public static int LH_LOG2_ELEMENT_SIZE_SHIFT;
    public static int LH_ELEMENT_TYPE_SHIFT;
    public static int LH_HEADER_SIZE_SHIFT;
    public static int LH_ARRAY_TAG_SHIFT;
    public static int LH_ARRAY_TAG_TYPE_VALUE;
    public static int LH_ARRAY_TAG_OBJ_VALUE;
    private static OopField javaMirror;
    private static MetadataField superField;
    private static IntField layoutHelper;
    private static AddressField name;
    private static CIntField accessFlags;
    private static MetadataField subklass;
    private static MetadataField nextSibling;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("Klass");
        javaMirror = new OopField(type.getOopField("_java_mirror"), 0L);
        superField = new MetadataField(type.getAddressField("_super"), 0L);
        layoutHelper = new IntField(type.getJIntField("_layout_helper"), 0L);
        name = type.getAddressField("_name");
        accessFlags = new CIntField(type.getCIntegerField("_access_flags"), 0L);
        subklass = new MetadataField(type.getAddressField("_subklass"), 0L);
        nextSibling = new MetadataField(type.getAddressField("_next_sibling"), 0L);
        LH_INSTANCE_SLOW_PATH_BIT = db.lookupIntConstant("Klass::_lh_instance_slow_path_bit");
        LH_LOG2_ELEMENT_SIZE_SHIFT = db.lookupIntConstant("Klass::_lh_log2_element_size_shift");
        LH_ELEMENT_TYPE_SHIFT = db.lookupIntConstant("Klass::_lh_element_type_shift");
        LH_HEADER_SIZE_SHIFT = db.lookupIntConstant("Klass::_lh_header_size_shift");
        LH_ARRAY_TAG_SHIFT = db.lookupIntConstant("Klass::_lh_array_tag_shift");
        LH_ARRAY_TAG_TYPE_VALUE = db.lookupIntConstant("Klass::_lh_array_tag_type_value");
        LH_ARRAY_TAG_OBJ_VALUE = db.lookupIntConstant("Klass::_lh_array_tag_obj_value");
    }

    public Klass(Address addr) {
        super(addr);
    }

    public int getClassStatus() {
        return 0;
    }

    public boolean isKlass() {
        return true;
    }

    private Address getValue(AddressField field) {
        return this.addr.getAddressAt(field.getOffset());
    }

    protected Symbol getSymbol(AddressField field) {
        return Symbol.create(this.addr.getAddressAt(field.getOffset()));
    }

    public Instance getJavaMirror() {
        return (Instance)javaMirror.getValue(this);
    }

    public Klass getSuper() {
        return (Klass)superField.getValue(this);
    }

    public Klass getJavaSuper() {
        return null;
    }

    public int getLayoutHelper() {
        return layoutHelper.getValue(this);
    }

    public Symbol getName() {
        return this.getSymbol(name);
    }

    public long getAccessFlags() {
        return accessFlags.getValue(this);
    }

    public AccessFlags getAccessFlagsObj() {
        return new AccessFlags(this.getAccessFlags());
    }

    public Klass getSubklassKlass() {
        return (Klass)subklass.getValue(this);
    }

    public Klass getNextSiblingKlass() {
        return (Klass)nextSibling.getValue(this);
    }

    public long computeModifierFlags() {
        return 0L;
    }

    public final long getClassModifiers() {
        long flags = this.computeModifierFlags();
        if (this.isSuper()) {
            flags |= 0x20L;
        }
        return flags;
    }

    public boolean isSubclassOf(Klass k) {
        if (k != null) {
            for (Klass t = this; t != null; t = t.getSuper()) {
                if (!t.equals(k)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isSubtypeOf(Klass k) {
        return this.computeSubtypeOf(k);
    }

    boolean computeSubtypeOf(Klass k) {
        return this.isSubclassOf(k);
    }

    public Klass lca(Klass k2) {
        Klass k1 = this;
        while (!k1.isSubtypeOf(k2)) {
            if (k2.isSubtypeOf(k1)) {
                return k1;
            }
            k1 = k1.getSuper();
            k2 = k2.getSuper();
        }
        return k2;
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("Klass");
    }

    @Override
    public void iterateFields(MetadataVisitor visitor) {
        visitor.doOop(javaMirror, true);
        visitor.doMetadata(superField, true);
        visitor.doInt(layoutHelper, true);
        visitor.doCInt(accessFlags, true);
        visitor.doMetadata(subklass, true);
        visitor.doMetadata(nextSibling, true);
    }

    public long getObjectSize() {
        throw new RuntimeException("should not reach here");
    }

    public Klass arrayKlass(int rank) {
        return this.arrayKlassImpl(false, rank);
    }

    public Klass arrayKlass() {
        return this.arrayKlassImpl(false);
    }

    public Klass arrayKlassOrNull(int rank) {
        return this.arrayKlassImpl(true, rank);
    }

    public Klass arrayKlassOrNull() {
        return this.arrayKlassImpl(true);
    }

    public Klass arrayKlassImpl(boolean orNull, int rank) {
        throw new RuntimeException("array_klass should be dispatched to InstanceKlass, ObjArrayKlass or TypeArrayKlass");
    }

    public Klass arrayKlassImpl(boolean orNull) {
        throw new RuntimeException("array_klass should be dispatched to InstanceKlass, ObjArrayKlass or TypeArrayKlass");
    }

    public String signature() {
        return this.getName().asString();
    }

    public boolean isPublic() {
        return this.getAccessFlagsObj().isPublic();
    }

    public boolean isFinal() {
        return this.getAccessFlagsObj().isFinal();
    }

    public boolean isInterface() {
        return this.getAccessFlagsObj().isInterface();
    }

    public boolean isAbstract() {
        return this.getAccessFlagsObj().isAbstract();
    }

    public boolean isSuper() {
        return this.getAccessFlagsObj().isSuper();
    }

    public boolean isSynthetic() {
        return this.getAccessFlagsObj().isSynthetic();
    }

    public boolean hasFinalizer() {
        return this.getAccessFlagsObj().hasFinalizer();
    }

    public boolean isCloneable() {
        return this.getAccessFlagsObj().isCloneable();
    }

    public boolean hasVanillaConstructor() {
        return this.getAccessFlagsObj().hasVanillaConstructor();
    }

    public boolean hasMirandaMethods() {
        return this.getAccessFlagsObj().hasMirandaMethods();
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                Klass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

