/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import sun.security.ssl.Debug;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SessionId;
import sun.security.util.Cache;

final class SSLSessionContextImpl
implements SSLSessionContext {
    private Cache sessionCache;
    private Cache sessionHostPortCache;
    private int cacheLimit = this.getDefaultCacheLimit();
    private int timeout = 86400;
    private static final Debug debug = Debug.getInstance("ssl");

    SSLSessionContextImpl() {
        this.sessionCache = Cache.newSoftMemoryCache(this.cacheLimit, this.timeout);
        this.sessionHostPortCache = Cache.newSoftMemoryCache(this.cacheLimit, this.timeout);
    }

    @Override
    public SSLSession getSession(byte[] sessionId) {
        if (sessionId == null) {
            throw new NullPointerException("session id cannot be null");
        }
        SSLSessionImpl sess = (SSLSessionImpl)this.sessionCache.get(new SessionId(sessionId));
        if (!this.isTimedout(sess)) {
            return sess;
        }
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        SessionCacheVisitor scVisitor = new SessionCacheVisitor();
        this.sessionCache.accept(scVisitor);
        return scVisitor.getSessionIds();
    }

    @Override
    public void setSessionTimeout(int seconds) throws IllegalArgumentException {
        if (seconds < 0) {
            throw new IllegalArgumentException();
        }
        if (this.timeout != seconds) {
            this.sessionCache.setTimeout(seconds);
            this.sessionHostPortCache.setTimeout(seconds);
            this.timeout = seconds;
        }
    }

    @Override
    public int getSessionTimeout() {
        return this.timeout;
    }

    @Override
    public void setSessionCacheSize(int size) throws IllegalArgumentException {
        if (size < 0) {
            throw new IllegalArgumentException();
        }
        if (this.cacheLimit != size) {
            this.sessionCache.setCapacity(size);
            this.sessionHostPortCache.setCapacity(size);
            this.cacheLimit = size;
        }
    }

    @Override
    public int getSessionCacheSize() {
        return this.cacheLimit;
    }

    SSLSessionImpl get(byte[] id) {
        return (SSLSessionImpl)this.getSession(id);
    }

    SSLSessionImpl get(String hostname, int port) {
        if (hostname == null && port == -1) {
            return null;
        }
        SSLSessionImpl sess = (SSLSessionImpl)this.sessionHostPortCache.get(this.getKey(hostname, port));
        if (!this.isTimedout(sess)) {
            return sess;
        }
        return null;
    }

    private String getKey(String hostname, int port) {
        return (hostname + ":" + String.valueOf(port)).toLowerCase();
    }

    void put(SSLSessionImpl s) {
        this.sessionCache.put(s.getSessionId(), s);
        if (s.getPeerHost() != null && s.getPeerPort() != -1) {
            this.sessionHostPortCache.put(this.getKey(s.getPeerHost(), s.getPeerPort()), s);
        }
        s.setContext(this);
    }

    void remove(SessionId key) {
        SSLSessionImpl s = (SSLSessionImpl)this.sessionCache.get(key);
        if (s != null) {
            this.sessionCache.remove(key);
            this.sessionHostPortCache.remove(this.getKey(s.getPeerHost(), s.getPeerPort()));
        }
    }

    private int getDefaultCacheLimit() {
        int cacheLimit = 0;
        try {
            String s = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("javax.net.ssl.sessionCacheSize");
                }
            });
            cacheLimit = s != null ? Integer.valueOf(s) : 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cacheLimit > 0 ? cacheLimit : 0;
    }

    boolean isTimedout(SSLSession sess) {
        if (this.timeout == 0) {
            return false;
        }
        if (sess != null && sess.getCreationTime() + (long)this.timeout * 1000L <= System.currentTimeMillis()) {
            sess.invalidate();
            return true;
        }
        return false;
    }

    final class SessionCacheVisitor
    implements Cache.CacheVisitor {
        Vector<byte[]> ids = null;

        SessionCacheVisitor() {
        }

        public void visit(Map<Object, Object> map) {
            this.ids = new Vector(map.size());
            for (Object key : map.keySet()) {
                SSLSessionImpl value = (SSLSessionImpl)map.get(key);
                if (SSLSessionContextImpl.this.isTimedout(value)) continue;
                this.ids.addElement(((SessionId)key).getId());
            }
        }

        public Enumeration<byte[]> getSessionIds() {
            return this.ids != null ? this.ids.elements() : new Vector().elements();
        }
    }
}

