/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.DelegatableDecoder;

public class DoubleByte {
    public static final char[] B2C_UNMAPPABLE = new char[256];

    static {
        Arrays.fill(B2C_UNMAPPABLE, '\ufffd');
    }

    public static class Encoder_EUC_SIM
    extends Encoder {
        Encoder_EUC_SIM(Charset cs, char[] c2b, char[] c2bIndex) {
            super(cs, c2b, c2bIndex);
        }
    }

    public static class Encoder_EBCDIC
    extends Encoder {
        static final int SBCS = 0;
        static final int DBCS = 1;
        static final byte SO = 14;
        static final byte SI = 15;
        protected int currentState = 0;

        Encoder_EBCDIC(Charset cs, char[] c2b, char[] c2bIndex) {
            super(cs, 4.0f, 5.0f, new byte[]{111}, c2b, c2bIndex);
        }

        @Override
        protected void implReset() {
            this.currentState = 0;
        }

        @Override
        protected CoderResult implFlush(ByteBuffer out) {
            if (this.currentState == 1) {
                if (out.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                out.put((byte)15);
            }
            this.implReset();
            return CoderResult.UNDERFLOW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            int sp;
            char[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                for (sp = src.arrayOffset() + src.position(); sp < sl; ++sp) {
                    char c = sa[sp];
                    int bb = this.encodeChar(c);
                    if (bb == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, sa, sp, sl) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (bb > 255) {
                        if (this.currentState == 0) {
                            if (dl - dp < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 1;
                            da[dp++] = 14;
                        }
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(bb >> 8);
                        da[dp++] = (byte)bb;
                        continue;
                    }
                    if (this.currentState == 1) {
                        if (dl - dp < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        this.currentState = 0;
                        da[dp++] = 15;
                    }
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = (byte)bb;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    int bb = this.encodeChar(c);
                    if (bb == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, src) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (bb > 255) {
                        if (this.currentState == 0) {
                            if (dst.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 1;
                            dst.put((byte)14);
                        }
                        if (dst.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)(bb >> 8));
                        dst.put((byte)bb);
                    } else {
                        if (this.currentState == 1) {
                            if (dst.remaining() < 1) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            this.currentState = 0;
                            dst.put((byte)15);
                        }
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)bb);
                    }
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }
    }

    public static class Encoder_EBCDIC_DBCSONLY
    extends Encoder {
        Encoder_EBCDIC_DBCSONLY(Charset cs, byte[] repl, char[] c2b, char[] c2bIndex) {
            super(cs, 2.0f, 2.0f, repl, c2b, c2bIndex);
        }

        @Override
        public int encodeChar(char ch) {
            int bb = super.encodeChar(ch);
            if (bb <= 255) {
                return 65533;
            }
            return bb;
        }
    }

    public static class Encoder
    extends CharsetEncoder {
        final int MAX_SINGLEBYTE = 255;
        private final char[] c2b;
        private final char[] c2bIndex;
        Surrogate.Parser sgp;

        protected Encoder(Charset cs, char[] c2b, char[] c2bIndex) {
            super(cs, 2.0f, 2.0f);
            this.c2b = c2b;
            this.c2bIndex = c2bIndex;
        }

        Encoder(Charset cs, float avg, float max, byte[] repl, char[] c2b, char[] c2bIndex) {
            super(cs, avg, max, repl);
            this.c2b = c2b;
            this.c2bIndex = c2bIndex;
        }

        @Override
        public boolean canEncode(char c) {
            return this.encodeChar(c) != 65533;
        }

        Surrogate.Parser sgp() {
            if (this.sgp == null) {
                this.sgp = new Surrogate.Parser();
            }
            return this.sgp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            int sp;
            char[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                for (sp = src.arrayOffset() + src.position(); sp < sl; ++sp) {
                    char c = sa[sp];
                    int bb = this.encodeChar(c);
                    if (bb == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, sa, sp, sl) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (bb > 255) {
                        if (dl - dp < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        da[dp++] = (byte)(bb >> 8);
                        da[dp++] = (byte)bb;
                        continue;
                    }
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = (byte)bb;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    int bb = this.encodeChar(c);
                    if (bb == 65533) {
                        if (Character.isSurrogate(c)) {
                            if (this.sgp().parse(c, src) < 0) {
                                CoderResult coderResult = this.sgp.error();
                                return coderResult;
                            }
                            CoderResult coderResult = this.sgp.unmappableResult();
                            return coderResult;
                        }
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    if (bb > 255) {
                        if (dst.remaining() < 2) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)(bb >> 8));
                        dst.put((byte)bb);
                    } else {
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put((byte)bb);
                    }
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }

        public int encodeChar(char ch) {
            return this.c2b[this.c2bIndex[ch >> 8] + (ch & 0xFF)];
        }

        static void initC2B(String[] b2c, String b2cSB, String b2cNR, String c2bNR, int b2Min, int b2Max, char[] c2b, char[] c2bIndex) {
            char c;
            int i;
            Arrays.fill(c2b, '\ufffd');
            int off = 256;
            char[][] b2c_ca = new char[b2c.length][];
            char[] b2cSB_ca = null;
            if (b2cSB != null) {
                b2cSB_ca = b2cSB.toCharArray();
            }
            for (i = 0; i < b2c.length; ++i) {
                if (b2c[i] == null) continue;
                b2c_ca[i] = b2c[i].toCharArray();
            }
            if (b2cNR != null) {
                int j = 0;
                while (j < b2cNR.length()) {
                    char b = b2cNR.charAt(j++);
                    c = b2cNR.charAt(j++);
                    if (b < '\u0100' && b2cSB_ca != null) {
                        if (b2cSB_ca[b] != c) continue;
                        b2cSB_ca[b] = 65533;
                        continue;
                    }
                    if (b2c_ca[b >> 8][(b & 0xFF) - b2Min] != c) continue;
                    b2c_ca[b >> 8][(b & 0xFF) - b2Min] = 65533;
                }
            }
            if (b2cSB_ca != null) {
                for (int b = 0; b < b2cSB_ca.length; ++b) {
                    char c2 = b2cSB_ca[b];
                    if (c2 == '\ufffd') continue;
                    int index = c2bIndex[c2 >> 8];
                    if (index == 0) {
                        index = off;
                        off += 256;
                        c2bIndex[c2 >> 8] = (char)index;
                    }
                    c2b[index + (c2 & 0xFF)] = (char)b;
                }
            }
            for (int b1 = 0; b1 < b2c.length; ++b1) {
                char[] db = b2c_ca[b1];
                if (db == null) continue;
                for (int b2 = b2Min; b2 <= b2Max; ++b2) {
                    char c3 = db[b2 - b2Min];
                    if (c3 == '\ufffd') continue;
                    int index = c2bIndex[c3 >> 8];
                    if (index == 0) {
                        index = off;
                        off += 256;
                        c2bIndex[c3 >> 8] = (char)index;
                    }
                    c2b[index + (c3 & 0xFF)] = (char)(b1 << 8 | b2);
                }
            }
            if (c2bNR != null) {
                for (i = 0; i < c2bNR.length(); i += 2) {
                    char b = c2bNR.charAt(i);
                    c = c2bNR.charAt(i + 1);
                    int index = c >> 8;
                    if (c2bIndex[index] == '\u0000') {
                        c2bIndex[index] = (char)off;
                        off += 256;
                    }
                    index = c2bIndex[index] + (c & 0xFF);
                    c2b[index] = b;
                }
            }
        }
    }

    public static class Decoder_EUC_SIM
    extends Decoder {
        private final int SS2 = 142;
        private final int SS3 = 143;

        Decoder_EUC_SIM(Charset cs, char[][] b2c, char[] b2cSB, int b2Min, int b2Max) {
            super(cs, b2c, b2cSB, b2Min, b2Max);
        }

        @Override
        protected CoderResult crMalformedOrUnderFlow(int b) {
            if (b == 142 || b == 143) {
                return CoderResult.malformedForLength(1);
            }
            return CoderResult.UNDERFLOW;
        }

        @Override
        protected CoderResult crMalformedOrUnmappable(int b) {
            if (b == 142 || b == 143) {
                return CoderResult.malformedForLength(1);
            }
            return CoderResult.unmappableForLength(2);
        }
    }

    public static class Decoder_EBCDIC_DBCSONLY
    extends Decoder {
        static final char[] b2cSB = new char[256];

        Decoder_EBCDIC_DBCSONLY(Charset cs, char[][] b2c, int b2Min, int b2Max) {
            super(cs, 0.5f, 1.0f, b2c, b2cSB, b2Min, b2Max);
        }

        static {
            Arrays.fill(b2cSB, '\ufffd');
        }
    }

    public static class Decoder_EBCDIC
    extends Decoder {
        private static final int SBCS = 0;
        private static final int DBCS = 1;
        private static final int SO = 14;
        private static final int SI = 15;
        private int currentState;

        Decoder_EBCDIC(Charset cs, char[][] b2c, char[] b2cSB, int b2Min, int b2Max) {
            super(cs, b2c, b2cSB, b2Min, b2Max);
        }

        @Override
        public void implReset() {
            this.currentState = 0;
        }

        private static boolean isDoubleByte(int b1, int b2) {
            return 65 <= b1 && b1 <= 254 && 65 <= b2 && b2 <= 254 || b1 == 64 && b2 == 64;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            int sp;
            byte[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                int inSize;
                for (sp = src.arrayOffset() + src.position(); sp < sl; sp += inSize) {
                    int b1 = sa[sp] & 0xFF;
                    inSize = 1;
                    if (b1 == 14) {
                        if (this.currentState != 0) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 1;
                        continue;
                    }
                    if (b1 == 15) {
                        if (this.currentState != 1) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 0;
                        continue;
                    }
                    int c = 65533;
                    if (this.currentState == 0) {
                        c = this.b2cSB[b1];
                        if (c == 65533) {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    } else {
                        if (sl - sp < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int b2 = sa[sp + 1] & 0xFF;
                        if (b2 < this.b2Min || b2 > this.b2Max || (c = this.b2c[b1][b2 - this.b2Min]) == 65533) {
                            if (!Decoder_EBCDIC.isDoubleByte(b1, b2)) {
                                CoderResult coderResult = CoderResult.malformedForLength(2);
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(2);
                            return coderResult;
                        }
                        ++inSize;
                    }
                    if (dl - dp < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = c;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    int b1 = src.get() & 0xFF;
                    int inSize = 1;
                    if (b1 == 14) {
                        if (this.currentState != 0) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 1;
                    } else if (b1 == 15) {
                        if (this.currentState != 1) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.currentState = 0;
                    } else {
                        char c = '\ufffd';
                        if (this.currentState == 0) {
                            c = this.b2cSB[b1];
                            if (c == '\ufffd') {
                                CoderResult coderResult = CoderResult.unmappableForLength(1);
                                return coderResult;
                            }
                        } else {
                            if (src.remaining() < 1) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            int b2 = src.get() & 0xFF;
                            if (b2 < this.b2Min || b2 > this.b2Max || (c = this.b2c[b1][b2 - this.b2Min]) == '\ufffd') {
                                if (!Decoder_EBCDIC.isDoubleByte(b1, b2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(2);
                                    return coderResult;
                                }
                                CoderResult coderResult = CoderResult.unmappableForLength(2);
                                return coderResult;
                            }
                            ++inSize;
                        }
                        if (dst.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        dst.put(c);
                    }
                    mark += inSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }
    }

    public static class Decoder
    extends CharsetDecoder
    implements DelegatableDecoder {
        final char[][] b2c;
        final char[] b2cSB;
        final int b2Min;
        final int b2Max;

        protected CoderResult crMalformedOrUnderFlow(int b) {
            return CoderResult.UNDERFLOW;
        }

        protected CoderResult crMalformedOrUnmappable(int b) {
            return CoderResult.unmappableForLength(2);
        }

        Decoder(Charset cs, float avgcpb, float maxcpb, char[][] b2c, char[] b2cSB, int b2Min, int b2Max) {
            super(cs, avgcpb, maxcpb);
            this.b2c = b2c;
            this.b2cSB = b2cSB;
            this.b2Min = b2Min;
            this.b2Max = b2Max;
        }

        Decoder(Charset cs, char[][] b2c, char[] b2cSB, int b2Min, int b2Max) {
            this(cs, 0.5f, 1.0f, b2c, b2cSB, b2Min, b2Max);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            int sp;
            byte[] sa = src.array();
            int sl = src.arrayOffset() + src.limit();
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            try {
                int inSize;
                for (sp = src.arrayOffset() + src.position(); sp < sl && dp < dl; sp += inSize) {
                    inSize = 1;
                    int b1 = sa[sp] & 0xFF;
                    char c = this.b2cSB[b1];
                    if (c == '\ufffd') {
                        if (sl - sp < 2) {
                            CoderResult coderResult = this.crMalformedOrUnderFlow(b1);
                            return coderResult;
                        }
                        int b2 = sa[sp + 1] & 0xFF;
                        if (b2 < this.b2Min || b2 > this.b2Max || (c = this.b2c[b1][b2 - this.b2Min]) == '\ufffd') {
                            CoderResult coderResult = this.crMalformedOrUnmappable(b1);
                            return coderResult;
                        }
                        ++inSize;
                    }
                    da[dp++] = c;
                }
                CoderResult coderResult = sp >= sl ? CoderResult.UNDERFLOW : CoderResult.OVERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            try {
                while (src.hasRemaining() && dst.hasRemaining()) {
                    int b1 = src.get() & 0xFF;
                    char c = this.b2cSB[b1];
                    int inSize = 1;
                    if (c == '\ufffd') {
                        if (src.remaining() < 1) {
                            CoderResult coderResult = this.crMalformedOrUnderFlow(b1);
                            return coderResult;
                        }
                        int b2 = src.get() & 0xFF;
                        if (b2 < this.b2Min || b2 > this.b2Max || (c = this.b2c[b1][b2 - this.b2Min]) == '\ufffd') {
                            CoderResult coderResult = this.crMalformedOrUnmappable(b1);
                            return coderResult;
                        }
                        ++inSize;
                    }
                    dst.put(c);
                    mark += inSize;
                }
                CoderResult coderResult = src.hasRemaining() ? CoderResult.OVERFLOW : CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        public CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }

        @Override
        public void implReset() {
            super.implReset();
        }

        @Override
        public CoderResult implFlush(CharBuffer out) {
            return super.implFlush(out);
        }

        public char decodeSingle(int b) {
            return this.b2cSB[b];
        }

        public char decodeDouble(int b1, int b2) {
            if (b2 < this.b2Min || b2 > this.b2Max) {
                return '\ufffd';
            }
            return this.b2c[b1][b2 - this.b2Min];
        }
    }
}

