/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;

public class KrbException
extends Exception {
    private static final long serialVersionUID = -4993302876451928596L;
    private int returnCode;
    private KRBError error;

    public KrbException(String s) {
        super(s);
    }

    public KrbException(int i) {
        this.returnCode = i;
    }

    public KrbException(int i, String s) {
        this(s);
        this.returnCode = i;
    }

    public KrbException(KRBError e) {
        this.returnCode = e.getErrorCode();
        this.error = e;
    }

    public KrbException(KRBError e, String s) {
        this(s);
        this.returnCode = e.getErrorCode();
        this.error = e;
    }

    public KRBError getError() {
        return this.error;
    }

    public int returnCode() {
        return this.returnCode;
    }

    public String returnCodeSymbol() {
        return KrbException.returnCodeSymbol(this.returnCode);
    }

    public static String returnCodeSymbol(int i) {
        return "not yet implemented";
    }

    public String returnCodeMessage() {
        return Krb5.getErrorMessage(this.returnCode);
    }

    public static String errorMessage(int i) {
        return Krb5.getErrorMessage(i);
    }

    public String krbErrorMessage() {
        StringBuffer strbuf = new StringBuffer("krb_error " + this.returnCode);
        String msg = this.getMessage();
        if (msg != null) {
            strbuf.append(" ");
            strbuf.append(msg);
        }
        return strbuf.toString();
    }

    @Override
    public String getMessage() {
        String consMessage;
        StringBuffer message = new StringBuffer();
        int returnCode = this.returnCode();
        if (returnCode != 0) {
            message.append(this.returnCodeMessage());
            message.append(" (").append(this.returnCode()).append(')');
        }
        if ((consMessage = super.getMessage()) != null && consMessage.length() != 0) {
            if (returnCode != 0) {
                message.append(" - ");
            }
            message.append(consMessage);
        }
        return message.toString();
    }

    @Override
    public String toString() {
        return "KrbException: " + this.getMessage();
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.returnCode;
        if (this.error != null) {
            result = 37 * result + this.error.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof KrbException)) {
            return false;
        }
        KrbException other = (KrbException)obj;
        if (this.returnCode != other.returnCode) {
            return false;
        }
        return this.error == null ? other.error == null : this.error.equals(other.error);
    }
}

