/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.MultiplexConnectionInfo;

final class MultiplexInputStream
extends InputStream {
    private ConnectionMultiplexer manager;
    private MultiplexConnectionInfo info;
    private byte[] buffer;
    private int present = 0;
    private int pos = 0;
    private int requested = 0;
    private boolean disconnected = false;
    private Object lock = new Object();
    private int waterMark;
    private byte[] temp = new byte[1];

    MultiplexInputStream(ConnectionMultiplexer manager, MultiplexConnectionInfo info, int bufferLength) {
        this.manager = manager;
        this.info = info;
        this.buffer = new byte[bufferLength];
        this.waterMark = bufferLength / 2;
    }

    @Override
    public synchronized int read() throws IOException {
        int n = this.read(this.temp, 0, 1);
        if (n != 1) {
            return -1;
        }
        return this.temp[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int moreSpace;
        if (len <= 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.pos >= this.present) {
                this.present = 0;
                this.pos = 0;
            } else if (this.pos >= this.waterMark) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.present - this.pos);
                this.present -= this.pos;
                this.pos = 0;
            }
            int freeSpace = this.buffer.length - this.present;
            moreSpace = Math.max(freeSpace - this.requested, 0);
        }
        if (moreSpace > 0) {
            this.manager.sendRequest(this.info, moreSpace);
        }
        object = this.lock;
        synchronized (object) {
            this.requested += moreSpace;
            while (this.pos >= this.present && !this.disconnected) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.disconnected && this.pos >= this.present) {
                return -1;
            }
            int available = this.present - this.pos;
            if (len < available) {
                System.arraycopy(this.buffer, this.pos, b, off, len);
                this.pos += len;
                return len;
            }
            System.arraycopy(this.buffer, this.pos, b, off, available);
            this.present = 0;
            this.pos = 0;
            return available;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int available() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.present - this.pos;
        }
    }

    @Override
    public void close() throws IOException {
        this.manager.sendClose(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receive(int length, DataInputStream in) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.pos > 0 && this.buffer.length - this.present < length) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.present - this.pos);
                this.present -= this.pos;
                this.pos = 0;
            }
            if (this.buffer.length - this.present < length) {
                throw new IOException("Receive buffer overflow");
            }
            in.readFully(this.buffer, this.present, length);
            this.present += length;
            this.requested -= length;
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void disconnect() {
        Object object = this.lock;
        synchronized (object) {
            this.disconnected = true;
            this.lock.notifyAll();
        }
    }
}

