/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import com.sun.nio.file.SensitivityWatchEventModifier;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import sun.nio.fs.AbstractWatchKey;
import sun.nio.fs.AbstractWatchService;

class PollingWatchService
extends AbstractWatchService {
    private final Map<Object, PollingWatchKey> map = new HashMap<Object, PollingWatchKey>();
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        }
    });

    PollingWatchService() {
    }

    @Override
    WatchKey register(final Path path, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        if (events.length == 0) {
            throw new IllegalArgumentException("No events to register");
        }
        final HashSet eventSet = new HashSet(events.length);
        for (WatchEvent.Kind<?> event : events) {
            if (event == StandardWatchEventKinds.ENTRY_CREATE || event == StandardWatchEventKinds.ENTRY_MODIFY || event == StandardWatchEventKinds.ENTRY_DELETE) {
                eventSet.add(event);
                continue;
            }
            if (event == StandardWatchEventKinds.OVERFLOW) {
                if (events.length != 1) continue;
                throw new IllegalArgumentException("No events to register");
            }
            if (event == null) {
                throw new NullPointerException("An element in event set is 'null'");
            }
            throw new UnsupportedOperationException(event.name());
        }
        SensitivityWatchEventModifier sensivity = SensitivityWatchEventModifier.MEDIUM;
        if (modifiers.length > 0) {
            for (WatchEvent.Modifier modifier : modifiers) {
                if (modifier == null) {
                    throw new NullPointerException();
                }
                if (!(modifier instanceof SensitivityWatchEventModifier)) {
                    throw new UnsupportedOperationException("Modifier not supported");
                }
                sensivity = (SensitivityWatchEventModifier)modifier;
            }
        }
        if (!this.isOpen()) {
            throw new ClosedWatchServiceException();
        }
        try {
            final SensitivityWatchEventModifier s = sensivity;
            return AccessController.doPrivileged(new PrivilegedExceptionAction<PollingWatchKey>(){

                @Override
                public PollingWatchKey run() throws IOException {
                    return PollingWatchService.this.doPrivilegedRegister(path, eventSet, s);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable cause = pae.getCause();
            if (cause != null && cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new AssertionError((Object)pae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PollingWatchKey doPrivilegedRegister(Path path, Set<? extends WatchEvent.Kind<?>> events, SensitivityWatchEventModifier sensivity) throws IOException {
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        if (!attrs.isDirectory()) {
            throw new NotDirectoryException(path.toString());
        }
        Object fileKey = attrs.fileKey();
        if (fileKey == null) {
            throw new AssertionError((Object)"File keys must be supported");
        }
        Object object = this.closeLock();
        synchronized (object) {
            PollingWatchKey watchKey;
            if (!this.isOpen()) {
                throw new ClosedWatchServiceException();
            }
            Map<Object, PollingWatchKey> map = this.map;
            synchronized (map) {
                watchKey = this.map.get(fileKey);
                if (watchKey == null) {
                    watchKey = new PollingWatchKey(path, this, fileKey);
                    this.map.put(fileKey, watchKey);
                } else {
                    watchKey.disable();
                }
            }
            watchKey.enable(events, sensivity.sensitivityValueInSeconds());
            return watchKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void implClose() throws IOException {
        Map<Object, PollingWatchKey> map = this.map;
        synchronized (map) {
            for (Map.Entry<Object, PollingWatchKey> entry : this.map.entrySet()) {
                PollingWatchKey watchKey = entry.getValue();
                watchKey.disable();
                watchKey.invalidate();
            }
            this.map.clear();
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                PollingWatchService.this.scheduledExecutor.shutdown();
                return null;
            }
        });
    }

    private class PollingWatchKey
    extends AbstractWatchKey {
        private final Object fileKey;
        private Set<? extends WatchEvent.Kind<?>> events;
        private ScheduledFuture<?> poller;
        private volatile boolean valid;
        private int tickCount;
        private Map<Path, CacheEntry> entries;

        PollingWatchKey(Path dir, PollingWatchService watcher, Object fileKey) throws IOException {
            super(dir, watcher);
            this.fileKey = fileKey;
            this.valid = true;
            this.tickCount = 0;
            this.entries = new HashMap<Path, CacheEntry>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
                for (Path entry : stream) {
                    long lastModified = Files.getLastModifiedTime(entry, LinkOption.NOFOLLOW_LINKS).toMillis();
                    this.entries.put(entry.getFileName(), new CacheEntry(lastModified, this.tickCount));
                }
            }
            catch (DirectoryIteratorException e) {
                throw e.getCause();
            }
        }

        Object fileKey() {
            return this.fileKey;
        }

        @Override
        public boolean isValid() {
            return this.valid;
        }

        void invalidate() {
            this.valid = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void enable(Set<? extends WatchEvent.Kind<?>> events, long period) {
            PollingWatchKey pollingWatchKey = this;
            synchronized (pollingWatchKey) {
                this.events = events;
                Runnable thunk = new Runnable(){

                    @Override
                    public void run() {
                        PollingWatchKey.this.poll();
                    }
                };
                this.poller = PollingWatchService.this.scheduledExecutor.scheduleAtFixedRate(thunk, period, period, TimeUnit.SECONDS);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disable() {
            PollingWatchKey pollingWatchKey = this;
            synchronized (pollingWatchKey) {
                if (this.poller != null) {
                    this.poller.cancel(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            this.valid = false;
            Map map = PollingWatchService.this.map;
            synchronized (map) {
                PollingWatchService.this.map.remove(this.fileKey());
            }
            this.disable();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void poll() {
            if (!this.valid) {
                return;
            }
            ++this.tickCount;
            DirectoryStream<Path> stream = null;
            try {
                stream = Files.newDirectoryStream(this.watchable());
            }
            catch (IOException x) {
                this.cancel();
                this.signal();
                return;
            }
            try {
                for (Path entry : stream) {
                    long lastModified = 0L;
                    try {
                        lastModified = Files.getLastModifiedTime(entry, LinkOption.NOFOLLOW_LINKS).toMillis();
                    }
                    catch (IOException x) {
                        continue;
                    }
                    CacheEntry e = this.entries.get(entry.getFileName());
                    if (e == null) {
                        this.entries.put(entry.getFileName(), new CacheEntry(lastModified, this.tickCount));
                        if (this.events.contains(StandardWatchEventKinds.ENTRY_CREATE)) {
                            this.signalEvent(StandardWatchEventKinds.ENTRY_CREATE, entry.getFileName());
                            continue;
                        }
                        if (!this.events.contains(StandardWatchEventKinds.ENTRY_MODIFY)) continue;
                        this.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, entry.getFileName());
                        continue;
                    }
                    if (e.lastModified != lastModified && this.events.contains(StandardWatchEventKinds.ENTRY_MODIFY)) {
                        this.signalEvent(StandardWatchEventKinds.ENTRY_MODIFY, entry.getFileName());
                    }
                    e.update(lastModified, this.tickCount);
                }
            }
            catch (DirectoryIteratorException e) {
            }
            finally {
                try {
                    stream.close();
                }
                catch (IOException x) {}
            }
            Iterator<Map.Entry<Path, CacheEntry>> i = this.entries.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry<Path, CacheEntry> mapEntry = i.next();
                CacheEntry entry = mapEntry.getValue();
                if (entry.lastTickCount() == this.tickCount) continue;
                Path name = mapEntry.getKey();
                i.remove();
                if (!this.events.contains(StandardWatchEventKinds.ENTRY_DELETE)) continue;
                this.signalEvent(StandardWatchEventKinds.ENTRY_DELETE, name);
            }
        }
    }

    private static class CacheEntry {
        private long lastModified;
        private int lastTickCount;

        CacheEntry(long lastModified, int lastTickCount) {
            this.lastModified = lastModified;
            this.lastTickCount = lastTickCount;
        }

        int lastTickCount() {
            return this.lastTickCount;
        }

        long lastModified() {
            return this.lastModified;
        }

        void update(long lastModified, int tickCount) {
            this.lastModified = lastModified;
            this.lastTickCount = tickCount;
        }
    }
}

