/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import sun.swing.DefaultLookup;
import sun.swing.SwingUtilities2;

public class BasicInternalFrameTitlePane
extends JComponent {
    protected JMenuBar menuBar;
    protected JButton iconButton;
    protected JButton maxButton;
    protected JButton closeButton;
    protected JMenu windowMenu;
    protected JInternalFrame frame;
    protected Color selectedTitleColor;
    protected Color selectedTextColor;
    protected Color notSelectedTitleColor;
    protected Color notSelectedTextColor;
    protected Icon maxIcon;
    protected Icon minIcon;
    protected Icon iconIcon;
    protected Icon closeIcon;
    protected PropertyChangeListener propertyChangeListener;
    protected Action closeAction;
    protected Action maximizeAction;
    protected Action iconifyAction;
    protected Action restoreAction;
    protected Action moveAction;
    protected Action sizeAction;
    protected static final String CLOSE_CMD = UIManager.getString("InternalFrameTitlePane.closeButtonText");
    protected static final String ICONIFY_CMD = UIManager.getString("InternalFrameTitlePane.minimizeButtonText");
    protected static final String RESTORE_CMD = UIManager.getString("InternalFrameTitlePane.restoreButtonText");
    protected static final String MAXIMIZE_CMD = UIManager.getString("InternalFrameTitlePane.maximizeButtonText");
    protected static final String MOVE_CMD = UIManager.getString("InternalFrameTitlePane.moveButtonText");
    protected static final String SIZE_CMD = UIManager.getString("InternalFrameTitlePane.sizeButtonText");
    private String closeButtonToolTip;
    private String iconButtonToolTip;
    private String restoreButtonToolTip;
    private String maxButtonToolTip;
    private Handler handler;

    public BasicInternalFrameTitlePane(JInternalFrame f) {
        this.frame = f;
        this.installTitlePane();
    }

    protected void installTitlePane() {
        this.installDefaults();
        this.installListeners();
        this.createActions();
        this.enableActions();
        this.createActionMap();
        this.setLayout(this.createLayout());
        this.assembleSystemMenu();
        this.createButtons();
        this.addSubComponents();
    }

    protected void addSubComponents() {
        this.add(this.menuBar);
        this.add(this.iconButton);
        this.add(this.maxButton);
        this.add(this.closeButton);
    }

    protected void createActions() {
        this.maximizeAction = new MaximizeAction();
        this.iconifyAction = new IconifyAction();
        this.closeAction = new CloseAction();
        this.restoreAction = new RestoreAction();
        this.moveAction = new MoveAction();
        this.sizeAction = new SizeAction();
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("showSystemMenu", new ShowSystemMenuAction(true));
        map.put("hideSystemMenu", new ShowSystemMenuAction(false));
        return map;
    }

    protected void installListeners() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = this.createPropertyChangeListener();
        }
        this.frame.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallListeners() {
        this.frame.removePropertyChangeListener(this.propertyChangeListener);
        this.handler = null;
    }

    protected void installDefaults() {
        this.maxIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.iconIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.selectedTitleColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        this.selectedTextColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        this.notSelectedTextColor = UIManager.getColor("InternalFrame.inactiveTitleForeground");
        this.setFont(UIManager.getFont("InternalFrame.titleFont"));
        this.closeButtonToolTip = UIManager.getString("InternalFrame.closeButtonToolTip");
        this.iconButtonToolTip = UIManager.getString("InternalFrame.iconButtonToolTip");
        this.restoreButtonToolTip = UIManager.getString("InternalFrame.restoreButtonToolTip");
        this.maxButtonToolTip = UIManager.getString("InternalFrame.maxButtonToolTip");
    }

    protected void uninstallDefaults() {
    }

    protected void createButtons() {
        this.iconButton = new NoFocusButton("InternalFrameTitlePane.iconifyButtonAccessibleName", "InternalFrameTitlePane.iconifyButtonOpacity");
        this.iconButton.addActionListener(this.iconifyAction);
        if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
            this.iconButton.setToolTipText(this.iconButtonToolTip);
        }
        this.maxButton = new NoFocusButton("InternalFrameTitlePane.maximizeButtonAccessibleName", "InternalFrameTitlePane.maximizeButtonOpacity");
        this.maxButton.addActionListener(this.maximizeAction);
        this.closeButton = new NoFocusButton("InternalFrameTitlePane.closeButtonAccessibleName", "InternalFrameTitlePane.closeButtonOpacity");
        this.closeButton.addActionListener(this.closeAction);
        if (this.closeButtonToolTip != null && this.closeButtonToolTip.length() != 0) {
            this.closeButton.setToolTipText(this.closeButtonToolTip);
        }
        this.setButtonIcons();
    }

    protected void setButtonIcons() {
        if (this.frame.isIcon()) {
            if (this.minIcon != null) {
                this.iconButton.setIcon(this.minIcon);
            }
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.restoreButtonToolTip);
            }
            if (this.maxIcon != null) {
                this.maxButton.setIcon(this.maxIcon);
            }
            if (this.maxButtonToolTip != null && this.maxButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.maxButtonToolTip);
            }
        } else if (this.frame.isMaximum()) {
            if (this.iconIcon != null) {
                this.iconButton.setIcon(this.iconIcon);
            }
            if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.iconButtonToolTip);
            }
            if (this.minIcon != null) {
                this.maxButton.setIcon(this.minIcon);
            }
            if (this.restoreButtonToolTip != null && this.restoreButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.restoreButtonToolTip);
            }
        } else {
            if (this.iconIcon != null) {
                this.iconButton.setIcon(this.iconIcon);
            }
            if (this.iconButtonToolTip != null && this.iconButtonToolTip.length() != 0) {
                this.iconButton.setToolTipText(this.iconButtonToolTip);
            }
            if (this.maxIcon != null) {
                this.maxButton.setIcon(this.maxIcon);
            }
            if (this.maxButtonToolTip != null && this.maxButtonToolTip.length() != 0) {
                this.maxButton.setToolTipText(this.maxButtonToolTip);
            }
        }
        if (this.closeIcon != null) {
            this.closeButton.setIcon(this.closeIcon);
        }
    }

    protected void assembleSystemMenu() {
        this.menuBar = this.createSystemMenuBar();
        this.windowMenu = this.createSystemMenu();
        this.menuBar.add(this.windowMenu);
        this.addSystemMenuItems(this.windowMenu);
        this.enableActions();
    }

    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem mi = systemMenu.add(this.restoreAction);
        mi.setMnemonic('R');
        mi = systemMenu.add(this.moveAction);
        mi.setMnemonic('M');
        mi = systemMenu.add(this.sizeAction);
        mi.setMnemonic('S');
        mi = systemMenu.add(this.iconifyAction);
        mi.setMnemonic('n');
        mi = systemMenu.add(this.maximizeAction);
        mi.setMnemonic('x');
        systemMenu.add(new JSeparator());
        mi = systemMenu.add(this.closeAction);
        mi.setMnemonic('C');
    }

    protected JMenu createSystemMenu() {
        return new JMenu("    ");
    }

    protected JMenuBar createSystemMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setBorderPainted(false);
        return this.menuBar;
    }

    protected void showSystemMenu() {
        this.windowMenu.doClick();
    }

    @Override
    public void paintComponent(Graphics g) {
        this.paintTitleBackground(g);
        if (this.frame.getTitle() != null) {
            int titleX;
            boolean isSelected = this.frame.isSelected();
            Font f = g.getFont();
            g.setFont(this.getFont());
            if (isSelected) {
                g.setColor(this.selectedTextColor);
            } else {
                g.setColor(this.notSelectedTextColor);
            }
            FontMetrics fm = SwingUtilities2.getFontMetrics((JComponent)this.frame, g);
            int baseline = (this.getHeight() + fm.getAscent() - fm.getLeading() - fm.getDescent()) / 2;
            Rectangle r = new Rectangle(0, 0, 0, 0);
            if (this.frame.isIconifiable()) {
                r = this.iconButton.getBounds();
            } else if (this.frame.isMaximizable()) {
                r = this.maxButton.getBounds();
            } else if (this.frame.isClosable()) {
                r = this.closeButton.getBounds();
            }
            String title = this.frame.getTitle();
            if (BasicGraphicsUtils.isLeftToRight(this.frame)) {
                if (r.x == 0) {
                    r.x = this.frame.getWidth() - this.frame.getInsets().right;
                }
                titleX = this.menuBar.getX() + this.menuBar.getWidth() + 2;
                int titleW = r.x - titleX - 3;
                title = this.getTitle(this.frame.getTitle(), fm, titleW);
            } else {
                titleX = this.menuBar.getX() - 2 - SwingUtilities2.stringWidth(this.frame, fm, title);
            }
            SwingUtilities2.drawString((JComponent)this.frame, g, title, titleX, baseline);
            g.setFont(f);
        }
    }

    protected void paintTitleBackground(Graphics g) {
        boolean isSelected = this.frame.isSelected();
        if (isSelected) {
            g.setColor(this.selectedTitleColor);
        } else {
            g.setColor(this.notSelectedTitleColor);
        }
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    protected String getTitle(String text, FontMetrics fm, int availTextWidth) {
        return SwingUtilities2.clipStringIfNecessary(this.frame, fm, text, availTextWidth);
    }

    protected void postClosingEvent(JInternalFrame frame) {
        InternalFrameEvent e = new InternalFrameEvent(frame, 25550);
        if (JInternalFrame.class.getClassLoader() == null) {
            try {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(e);
                return;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        frame.dispatchEvent(e);
    }

    protected void enableActions() {
        this.restoreAction.setEnabled(this.frame.isMaximum() || this.frame.isIcon());
        this.maximizeAction.setEnabled(this.frame.isMaximizable() && !this.frame.isMaximum() && !this.frame.isIcon() || this.frame.isMaximizable() && this.frame.isIcon());
        this.iconifyAction.setEnabled(this.frame.isIconifiable() && !this.frame.isIcon());
        this.closeAction.setEnabled(this.frame.isClosable());
        this.sizeAction.setEnabled(false);
        this.moveAction.setEnabled(false);
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayout() {
        return this.getHandler();
    }

    private class NoFocusButton
    extends JButton {
        private String uiKey;

        public NoFocusButton(String uiKey, String opacityKey) {
            this.setFocusPainted(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.uiKey = uiKey;
            Object opacity = UIManager.get(opacityKey);
            if (opacity instanceof Boolean) {
                this.setOpaque((Boolean)opacity);
            }
        }

        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            AccessibleContext ac = super.getAccessibleContext();
            if (this.uiKey != null) {
                ac.setAccessibleName(UIManager.getString(this.uiKey));
                this.uiKey = null;
            }
            return ac;
        }
    }

    public class SystemMenuBar
    extends JMenuBar {
        @Override
        public boolean isFocusTraversable() {
            return false;
        }

        @Override
        public void requestFocus() {
        }

        @Override
        public void paint(Graphics g) {
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            if (icon == null) {
                icon = (Icon)DefaultLookup.get(BasicInternalFrameTitlePane.this.frame, BasicInternalFrameTitlePane.this.frame.getUI(), "InternalFrame.icon");
            }
            if (icon != null) {
                if (icon instanceof ImageIcon && (icon.getIconWidth() > 16 || icon.getIconHeight() > 16)) {
                    Image img = ((ImageIcon)icon).getImage();
                    ((ImageIcon)icon).setImage(img.getScaledInstance(16, 16, 4));
                }
                icon.paintIcon(this, g, 0, 0);
            }
        }

        @Override
        public boolean isOpaque() {
            return true;
        }
    }

    public class SizeAction
    extends AbstractAction {
        public SizeAction() {
            super(UIManager.getString("InternalFrameTitlePane.sizeButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private class ShowSystemMenuAction
    extends AbstractAction {
        private boolean show;

        public ShowSystemMenuAction(boolean show) {
            this.show = show;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.show) {
                BasicInternalFrameTitlePane.this.windowMenu.doClick();
            } else {
                BasicInternalFrameTitlePane.this.windowMenu.setVisible(false);
            }
        }
    }

    public class MoveAction
    extends AbstractAction {
        public MoveAction() {
            super(UIManager.getString("InternalFrameTitlePane.moveButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    public class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString("InternalFrameTitlePane.restoreButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable() && BasicInternalFrameTitlePane.this.frame.isMaximum() && BasicInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException e) {}
            } else if (BasicInternalFrameTitlePane.this.frame.isMaximizable() && BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                }
                catch (PropertyVetoException e) {}
            } else if (BasicInternalFrameTitlePane.this.frame.isIconifiable() && BasicInternalFrameTitlePane.this.frame.isIcon()) {
                try {
                    BasicInternalFrameTitlePane.this.frame.setIcon(false);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    public class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString("InternalFrameTitlePane.minimizeButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                if (!BasicInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(true);
                    }
                    catch (PropertyVetoException e1) {}
                } else {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString("InternalFrameTitlePane.maximizeButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                if (BasicInternalFrameTitlePane.this.frame.isMaximum() && BasicInternalFrameTitlePane.this.frame.isIcon()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setIcon(false);
                    }
                    catch (PropertyVetoException e) {}
                } else if (!BasicInternalFrameTitlePane.this.frame.isMaximum()) {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(true);
                    }
                    catch (PropertyVetoException e) {}
                } else {
                    try {
                        BasicInternalFrameTitlePane.this.frame.setMaximum(false);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString("InternalFrameTitlePane.closeButtonText"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                BasicInternalFrameTitlePane.this.frame.doDefaultCloseAction();
            }
        }
    }

    public class TitlePaneLayout
    implements LayoutManager {
        @Override
        public void addLayoutComponent(String name, Component c) {
            BasicInternalFrameTitlePane.this.getHandler().addLayoutComponent(name, c);
        }

        @Override
        public void removeLayoutComponent(Component c) {
            BasicInternalFrameTitlePane.this.getHandler().removeLayoutComponent(c);
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return BasicInternalFrameTitlePane.this.getHandler().preferredLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return BasicInternalFrameTitlePane.this.getHandler().minimumLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            BasicInternalFrameTitlePane.this.getHandler().layoutContainer(c);
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BasicInternalFrameTitlePane.this.getHandler().propertyChange(evt);
        }
    }

    private class Handler
    implements LayoutManager,
    PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (prop == "selected") {
                BasicInternalFrameTitlePane.this.repaint();
                return;
            }
            if (prop == "icon" || prop == "maximum") {
                BasicInternalFrameTitlePane.this.setButtonIcons();
                BasicInternalFrameTitlePane.this.enableActions();
                return;
            }
            if ("closable" == prop) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.closeButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.closeButton);
                }
            } else if ("maximizable" == prop) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.maxButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.maxButton);
                }
            } else if ("iconable" == prop) {
                if (evt.getNewValue() == Boolean.TRUE) {
                    BasicInternalFrameTitlePane.this.add(BasicInternalFrameTitlePane.this.iconButton);
                } else {
                    BasicInternalFrameTitlePane.this.remove(BasicInternalFrameTitlePane.this.iconButton);
                }
            }
            BasicInternalFrameTitlePane.this.enableActions();
            BasicInternalFrameTitlePane.this.revalidate();
            BasicInternalFrameTitlePane.this.repaint();
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int subtitle_w;
            int title_length;
            int width = 22;
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                width += 19;
            }
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 19;
            }
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 19;
            }
            FontMetrics fm = BasicInternalFrameTitlePane.this.frame.getFontMetrics(BasicInternalFrameTitlePane.this.getFont());
            String frameTitle = BasicInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? SwingUtilities2.stringWidth(BasicInternalFrameTitlePane.this.frame, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            width = title_length > 3 ? (width += title_w < (subtitle_w = SwingUtilities2.stringWidth(BasicInternalFrameTitlePane.this.frame, fm, frameTitle.substring(0, 3) + "...")) ? title_w : subtitle_w) : (width += title_w);
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            int fontHeight = fm.getHeight();
            fontHeight += 2;
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            int height = Math.max(fontHeight, iconHeight += 2);
            Dimension dim = new Dimension(width, height);
            if (BasicInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = BasicInternalFrameTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container c) {
            boolean leftToRight = BasicGraphicsUtils.isLeftToRight(BasicInternalFrameTitlePane.this.frame);
            int w = BasicInternalFrameTitlePane.this.getWidth();
            int h = BasicInternalFrameTitlePane.this.getHeight();
            int buttonHeight = BasicInternalFrameTitlePane.this.closeButton.getIcon().getIconHeight();
            Icon icon = BasicInternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = icon.getIconHeight();
            }
            int x = leftToRight ? 2 : w - 16 - 2;
            BasicInternalFrameTitlePane.this.menuBar.setBounds(x, (h - iconHeight) / 2, 16, 16);
            int n = x = leftToRight ? w - 16 - 2 : 2;
            if (BasicInternalFrameTitlePane.this.frame.isClosable()) {
                BasicInternalFrameTitlePane.this.closeButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (BasicInternalFrameTitlePane.this.frame.isMaximizable()) {
                BasicInternalFrameTitlePane.this.maxButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
                x += leftToRight ? -18 : 18;
            }
            if (BasicInternalFrameTitlePane.this.frame.isIconifiable()) {
                BasicInternalFrameTitlePane.this.iconButton.setBounds(x, (h - buttonHeight) / 2, 16, 14);
            }
        }
    }
}

