/*
 * Decompiled with CFR 0.152.
 */
package javax.naming.spi;

import com.sun.naming.internal.FactoryEnumeration;
import com.sun.naming.internal.ResourceManager;
import com.sun.naming.internal.VersionHelper;
import java.net.MalformedURLException;
import java.util.Hashtable;
import javax.naming.CannotProceedException;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ContinuationContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import javax.naming.spi.Resolver;
import javax.naming.spi.StateFactory;

public class NamingManager {
    static final VersionHelper helper = VersionHelper.getVersionHelper();
    private static ObjectFactoryBuilder object_factory_builder = null;
    private static final String defaultPkgPrefix = "com.sun.jndi.url";
    private static InitialContextFactoryBuilder initctx_factory_builder = null;
    public static final String CPE = "java.naming.spi.CannotProceedException";

    NamingManager() {
    }

    public static synchronized void setObjectFactoryBuilder(ObjectFactoryBuilder builder) throws NamingException {
        if (object_factory_builder != null) {
            throw new IllegalStateException("ObjectFactoryBuilder already set");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        object_factory_builder = builder;
    }

    static synchronized ObjectFactoryBuilder getObjectFactoryBuilder() {
        return object_factory_builder;
    }

    static ObjectFactory getObjectFactoryFromReference(Reference ref, String factoryName) throws IllegalAccessException, InstantiationException, MalformedURLException {
        String codebase;
        Class clas = null;
        try {
            clas = helper.loadClass(factoryName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (clas == null && (codebase = ref.getFactoryClassLocation()) != null) {
            try {
                clas = helper.loadClass(factoryName, codebase);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return clas != null ? (ObjectFactory)clas.newInstance() : null;
    }

    private static Object createObjectFromFactories(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        FactoryEnumeration factories = ResourceManager.getFactories("java.naming.factory.object", environment, nameCtx);
        if (factories == null) {
            return null;
        }
        Object answer = null;
        while (answer == null && factories.hasMore()) {
            ObjectFactory factory = (ObjectFactory)factories.next();
            answer = factory.getObjectInstance(obj, name, nameCtx, environment);
        }
        return answer;
    }

    private static String getURLScheme(String str) {
        int colon_posn = str.indexOf(58);
        int slash_posn = str.indexOf(47);
        if (colon_posn > 0 && (slash_posn == -1 || colon_posn < slash_posn)) {
            return str.substring(0, colon_posn);
        }
        return null;
    }

    public static Object getObjectInstance(Object refInfo, Name name, Context nameCtx, Hashtable<?, ?> environment) throws Exception {
        Object answer;
        ObjectFactoryBuilder builder = NamingManager.getObjectFactoryBuilder();
        if (builder != null) {
            ObjectFactory factory = builder.createObjectFactory(refInfo, environment);
            return factory.getObjectInstance(refInfo, name, nameCtx, environment);
        }
        Reference ref = null;
        if (refInfo instanceof Reference) {
            ref = (Reference)refInfo;
        } else if (refInfo instanceof Referenceable) {
            ref = ((Referenceable)refInfo).getReference();
        }
        if (ref != null) {
            String f = ref.getFactoryClassName();
            if (f != null) {
                ObjectFactory factory = NamingManager.getObjectFactoryFromReference(ref, f);
                if (factory != null) {
                    return factory.getObjectInstance(ref, name, nameCtx, environment);
                }
                return refInfo;
            }
            answer = NamingManager.processURLAddrs(ref, name, nameCtx, environment);
            if (answer != null) {
                return answer;
            }
        }
        return (answer = NamingManager.createObjectFromFactories(refInfo, name, nameCtx, environment)) != null ? answer : refInfo;
    }

    static Object processURLAddrs(Reference ref, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        for (int i = 0; i < ref.size(); ++i) {
            String url;
            Object answer;
            RefAddr addr = ref.get(i);
            if (!(addr instanceof StringRefAddr) || !addr.getType().equalsIgnoreCase("URL") || (answer = NamingManager.processURL(url = (String)addr.getContent(), name, nameCtx, environment)) == null) continue;
            return answer;
        }
        return null;
    }

    private static Object processURL(Object refInfo, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        Object answer;
        String url;
        String scheme;
        if (refInfo instanceof String && (scheme = NamingManager.getURLScheme(url = (String)refInfo)) != null && (answer = NamingManager.getURLObject(scheme, refInfo, name, nameCtx, environment)) != null) {
            return answer;
        }
        if (refInfo instanceof String[]) {
            String[] urls = (String[])refInfo;
            for (int i = 0; i < urls.length; ++i) {
                String scheme2 = NamingManager.getURLScheme(urls[i]);
                if (scheme2 == null || (answer = NamingManager.getURLObject(scheme2, refInfo, name, nameCtx, environment)) == null) continue;
                return answer;
            }
        }
        return null;
    }

    static Context getContext(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        Object answer;
        if (obj instanceof Context) {
            return (Context)obj;
        }
        try {
            answer = NamingManager.getObjectInstance(obj, name, nameCtx, environment);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return answer instanceof Context ? (Context)answer : null;
    }

    static Resolver getResolver(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        Object answer;
        if (obj instanceof Resolver) {
            return (Resolver)obj;
        }
        try {
            answer = NamingManager.getObjectInstance(obj, name, nameCtx, environment);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
        return answer instanceof Resolver ? (Resolver)answer : null;
    }

    public static Context getURLContext(String scheme, Hashtable<?, ?> environment) throws NamingException {
        Object answer = NamingManager.getURLObject(scheme, null, null, null, environment);
        if (answer instanceof Context) {
            return (Context)answer;
        }
        return null;
    }

    private static Object getURLObject(String scheme, Object urlInfo, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        ObjectFactory factory = (ObjectFactory)ResourceManager.getFactory("java.naming.factory.url.pkgs", environment, nameCtx, "." + scheme + "." + scheme + "URLContextFactory", defaultPkgPrefix);
        if (factory == null) {
            return null;
        }
        try {
            return factory.getObjectInstance(urlInfo, name, nameCtx, environment);
        }
        catch (NamingException e) {
            throw e;
        }
        catch (Exception e) {
            NamingException ne = new NamingException();
            ne.setRootCause(e);
            throw ne;
        }
    }

    private static synchronized InitialContextFactoryBuilder getInitialContextFactoryBuilder() {
        return initctx_factory_builder;
    }

    public static Context getInitialContext(Hashtable<?, ?> env) throws NamingException {
        InitialContextFactory factory;
        InitialContextFactoryBuilder builder = NamingManager.getInitialContextFactoryBuilder();
        if (builder == null) {
            String className;
            String string = className = env != null ? (String)env.get("java.naming.factory.initial") : null;
            if (className == null) {
                NoInitialContextException ne = new NoInitialContextException("Need to specify class name in environment or system property, or as an applet parameter, or in an application resource file:  java.naming.factory.initial");
                throw ne;
            }
            try {
                factory = (InitialContextFactory)helper.loadClass(className).newInstance();
            }
            catch (Exception e) {
                NoInitialContextException ne = new NoInitialContextException("Cannot instantiate class: " + className);
                ne.setRootCause(e);
                throw ne;
            }
        } else {
            factory = builder.createInitialContextFactory(env);
        }
        return factory.getInitialContext(env);
    }

    public static synchronized void setInitialContextFactoryBuilder(InitialContextFactoryBuilder builder) throws NamingException {
        if (initctx_factory_builder != null) {
            throw new IllegalStateException("InitialContextFactoryBuilder already set");
        }
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkSetFactory();
        }
        initctx_factory_builder = builder;
    }

    public static boolean hasInitialContextFactoryBuilder() {
        return NamingManager.getInitialContextFactoryBuilder() != null;
    }

    public static Context getContinuationContext(CannotProceedException cpe) throws NamingException {
        Hashtable<String, CannotProceedException> env = cpe.getEnvironment();
        env = env == null ? new Hashtable<String, CannotProceedException>(7) : (Hashtable<String, CannotProceedException>)env.clone();
        env.put(CPE, cpe);
        ContinuationContext cctx = new ContinuationContext(cpe, env);
        return cctx.getTargetContext();
    }

    public static Object getStateToBind(Object obj, Name name, Context nameCtx, Hashtable<?, ?> environment) throws NamingException {
        FactoryEnumeration factories = ResourceManager.getFactories("java.naming.factory.state", environment, nameCtx);
        if (factories == null) {
            return obj;
        }
        Object answer = null;
        while (answer == null && factories.hasMore()) {
            StateFactory factory = (StateFactory)factories.next();
            answer = factory.getStateToBind(obj, name, nameCtx, environment);
        }
        return answer != null ? answer : obj;
    }
}

