/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import sun.misc.MessageUtils;
import sun.nio.cs.ArrayDecoder;
import sun.nio.cs.ArrayEncoder;
import sun.nio.cs.HistoricallyNamedCharset;

class StringCoding {
    private static final ThreadLocal<SoftReference<StringDecoder>> decoder = new ThreadLocal();
    private static final ThreadLocal<SoftReference<StringEncoder>> encoder = new ThreadLocal();
    private static boolean warnUnsupportedCharset = true;

    private StringCoding() {
    }

    private static <T> T deref(ThreadLocal<SoftReference<T>> tl) {
        SoftReference<T> sr = tl.get();
        if (sr == null) {
            return null;
        }
        return sr.get();
    }

    private static <T> void set(ThreadLocal<SoftReference<T>> tl, T ob) {
        tl.set(new SoftReference<T>(ob));
    }

    private static byte[] safeTrim(byte[] ba, int len, Charset cs, boolean isTrusted) {
        if (len == ba.length && (isTrusted || System.getSecurityManager() == null)) {
            return ba;
        }
        return Arrays.copyOf(ba, len);
    }

    private static char[] safeTrim(char[] ca, int len, Charset cs, boolean isTrusted) {
        if (len == ca.length && (isTrusted || System.getSecurityManager() == null)) {
            return ca;
        }
        return Arrays.copyOf(ca, len);
    }

    private static int scale(int len, float expansionFactor) {
        return (int)((double)len * (double)expansionFactor);
    }

    private static Charset lookupCharset(String csn) {
        if (Charset.isSupported(csn)) {
            try {
                return Charset.forName(csn);
            }
            catch (UnsupportedCharsetException x) {
                throw new Error(x);
            }
        }
        return null;
    }

    private static void warnUnsupportedCharset(String csn) {
        if (warnUnsupportedCharset) {
            MessageUtils.err("WARNING: Default charset " + csn + " not supported, using ISO-8859-1 instead");
            warnUnsupportedCharset = false;
        }
    }

    static char[] decode(String charsetName, byte[] ba, int off, int len) throws UnsupportedEncodingException {
        String csn;
        StringDecoder sd = (StringDecoder)StringCoding.deref(decoder);
        String string = csn = charsetName == null ? "ISO-8859-1" : charsetName;
        if (sd == null || !csn.equals(sd.requestedCharsetName()) && !csn.equals(sd.charsetName())) {
            sd = null;
            try {
                Charset cs = StringCoding.lookupCharset(csn);
                if (cs != null) {
                    sd = new StringDecoder(cs, csn);
                }
            }
            catch (IllegalCharsetNameException x) {
                // empty catch block
            }
            if (sd == null) {
                throw new UnsupportedEncodingException(csn);
            }
            StringCoding.set(decoder, sd);
        }
        return sd.decode(ba, off, len);
    }

    static char[] decode(Charset cs, byte[] ba, int off, int len) {
        CharsetDecoder cd = cs.newDecoder();
        int en = StringCoding.scale(len, cd.maxCharsPerByte());
        char[] ca = new char[en];
        if (len == 0) {
            return ca;
        }
        boolean isTrusted = false;
        if (System.getSecurityManager() != null && !(isTrusted = cs.getClass().getClassLoader0() == null)) {
            ba = Arrays.copyOfRange(ba, off, off + len);
            off = 0;
        }
        cd.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        if (cd instanceof ArrayDecoder) {
            int clen = ((ArrayDecoder)((Object)cd)).decode(ba, off, len, ca);
            return StringCoding.safeTrim(ca, clen, cs, isTrusted);
        }
        ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
        CharBuffer cb = CharBuffer.wrap(ca);
        try {
            CoderResult cr = cd.decode(bb, cb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = cd.flush(cb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return StringCoding.safeTrim(ca, cb.position(), cs, isTrusted);
    }

    static char[] decode(byte[] ba, int off, int len) {
        String csn = Charset.defaultCharset().name();
        try {
            return StringCoding.decode(csn, ba, off, len);
        }
        catch (UnsupportedEncodingException x) {
            StringCoding.warnUnsupportedCharset(csn);
            try {
                return StringCoding.decode("ISO-8859-1", ba, off, len);
            }
            catch (UnsupportedEncodingException x2) {
                MessageUtils.err("ISO-8859-1 charset not available: " + x2.toString());
                System.exit(1);
                return null;
            }
        }
    }

    static byte[] encode(String charsetName, char[] ca, int off, int len) throws UnsupportedEncodingException {
        String csn;
        StringEncoder se = (StringEncoder)StringCoding.deref(encoder);
        String string = csn = charsetName == null ? "ISO-8859-1" : charsetName;
        if (se == null || !csn.equals(se.requestedCharsetName()) && !csn.equals(se.charsetName())) {
            se = null;
            try {
                Charset cs = StringCoding.lookupCharset(csn);
                if (cs != null) {
                    se = new StringEncoder(cs, csn);
                }
            }
            catch (IllegalCharsetNameException x) {
                // empty catch block
            }
            if (se == null) {
                throw new UnsupportedEncodingException(csn);
            }
            StringCoding.set(encoder, se);
        }
        return se.encode(ca, off, len);
    }

    static byte[] encode(Charset cs, char[] ca, int off, int len) {
        CharsetEncoder ce = cs.newEncoder();
        int en = StringCoding.scale(len, ce.maxBytesPerChar());
        byte[] ba = new byte[en];
        if (len == 0) {
            return ba;
        }
        boolean isTrusted = false;
        if (System.getSecurityManager() != null && !(isTrusted = cs.getClass().getClassLoader0() == null)) {
            ca = Arrays.copyOfRange(ca, off, off + len);
            off = 0;
        }
        ce.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).reset();
        if (ce instanceof ArrayEncoder) {
            int blen = ((ArrayEncoder)((Object)ce)).encode(ca, off, len, ba);
            return StringCoding.safeTrim(ba, blen, cs, isTrusted);
        }
        ByteBuffer bb = ByteBuffer.wrap(ba);
        CharBuffer cb = CharBuffer.wrap(ca, off, len);
        try {
            CoderResult cr = ce.encode(cb, bb, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = ce.flush(bb)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return StringCoding.safeTrim(ba, bb.position(), cs, isTrusted);
    }

    static byte[] encode(char[] ca, int off, int len) {
        String csn = Charset.defaultCharset().name();
        try {
            return StringCoding.encode(csn, ca, off, len);
        }
        catch (UnsupportedEncodingException x) {
            StringCoding.warnUnsupportedCharset(csn);
            try {
                return StringCoding.encode("ISO-8859-1", ca, off, len);
            }
            catch (UnsupportedEncodingException x2) {
                MessageUtils.err("ISO-8859-1 charset not available: " + x2.toString());
                System.exit(1);
                return null;
            }
        }
    }

    private static class StringEncoder {
        private Charset cs;
        private CharsetEncoder ce;
        private final String requestedCharsetName;
        private final boolean isTrusted;

        private StringEncoder(Charset cs, String rcn) {
            this.requestedCharsetName = rcn;
            this.cs = cs;
            this.ce = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.isTrusted = cs.getClass().getClassLoader0() == null;
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        byte[] encode(char[] ca, int off, int len) {
            int en = StringCoding.scale(len, this.ce.maxBytesPerChar());
            byte[] ba = new byte[en];
            if (len == 0) {
                return ba;
            }
            if (this.ce instanceof ArrayEncoder) {
                int blen = ((ArrayEncoder)((Object)this.ce)).encode(ca, off, len, ba);
                return StringCoding.safeTrim(ba, blen, this.cs, this.isTrusted);
            }
            this.ce.reset();
            ByteBuffer bb = ByteBuffer.wrap(ba);
            CharBuffer cb = CharBuffer.wrap(ca, off, len);
            try {
                CoderResult cr = this.ce.encode(cb, bb, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = this.ce.flush(bb)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException x) {
                throw new Error(x);
            }
            return StringCoding.safeTrim(ba, bb.position(), this.cs, this.isTrusted);
        }
    }

    private static class StringDecoder {
        private final String requestedCharsetName;
        private final Charset cs;
        private final CharsetDecoder cd;
        private final boolean isTrusted;

        private StringDecoder(Charset cs, String rcn) {
            this.requestedCharsetName = rcn;
            this.cs = cs;
            this.cd = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
            this.isTrusted = cs.getClass().getClassLoader0() == null;
        }

        String charsetName() {
            if (this.cs instanceof HistoricallyNamedCharset) {
                return ((HistoricallyNamedCharset)((Object)this.cs)).historicalName();
            }
            return this.cs.name();
        }

        final String requestedCharsetName() {
            return this.requestedCharsetName;
        }

        char[] decode(byte[] ba, int off, int len) {
            int en = StringCoding.scale(len, this.cd.maxCharsPerByte());
            char[] ca = new char[en];
            if (len == 0) {
                return ca;
            }
            if (this.cd instanceof ArrayDecoder) {
                int clen = ((ArrayDecoder)((Object)this.cd)).decode(ba, off, len, ca);
                return StringCoding.safeTrim(ca, clen, this.cs, this.isTrusted);
            }
            this.cd.reset();
            ByteBuffer bb = ByteBuffer.wrap(ba, off, len);
            CharBuffer cb = CharBuffer.wrap(ca);
            try {
                CoderResult cr = this.cd.decode(bb, cb, true);
                if (!cr.isUnderflow()) {
                    cr.throwException();
                }
                if (!(cr = this.cd.flush(cb)).isUnderflow()) {
                    cr.throwException();
                }
            }
            catch (CharacterCodingException x) {
                throw new Error(x);
            }
            return StringCoding.safeTrim(ca, cb.position(), this.cs, this.isTrusted);
        }
    }
}

