/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations;

import com.sun.org.apache.xml.internal.security.encryption.EncryptedKey;
import com.sun.org.apache.xml.internal.security.encryption.XMLCipher;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.KeyResolverSpi;
import com.sun.org.apache.xml.internal.security.keys.keyresolver.implementations.RSAKeyValueResolver;
import com.sun.org.apache.xml.internal.security.keys.storage.StorageResolver;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.w3c.dom.Element;

public class EncryptedKeyResolver
extends KeyResolverSpi {
    static Logger log = Logger.getLogger(RSAKeyValueResolver.class.getName());
    Key _kek;
    String _algorithm;

    public EncryptedKeyResolver(String algorithm) {
        this._kek = null;
        this._algorithm = algorithm;
    }

    public EncryptedKeyResolver(String algorithm, Key kek) {
        this._algorithm = algorithm;
        this._kek = kek;
    }

    @Override
    public PublicKey engineLookupAndResolvePublicKey(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public X509Certificate engineLookupResolveX509Certificate(Element element, String BaseURI, StorageResolver storage) {
        return null;
    }

    @Override
    public SecretKey engineLookupAndResolveSecretKey(Element element, String BaseURI, StorageResolver storage) {
        SecretKey key = null;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "EncryptedKeyResolver - Can I resolve " + element.getTagName());
        }
        if (element == null) {
            return null;
        }
        boolean isEncryptedKey = XMLUtils.elementIsInEncryptionSpace(element, "EncryptedKey");
        if (isEncryptedKey) {
            log.log(Level.FINE, "Passed an Encrypted Key");
            try {
                XMLCipher cipher = XMLCipher.getInstance();
                cipher.init(4, this._kek);
                EncryptedKey ek = cipher.loadEncryptedKey(element);
                key = (SecretKey)cipher.decryptKey(ek, this._algorithm);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return key;
    }
}

