/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.ShortMessage;

final class FastShortMessage
extends ShortMessage {
    private int packedMsg;

    FastShortMessage(int packedMsg) throws InvalidMidiDataException {
        this.packedMsg = packedMsg;
        this.getDataLength(packedMsg & 0xFF);
    }

    FastShortMessage(ShortMessage msg) {
        this.packedMsg = msg.getStatus() | msg.getData1() << 8 | msg.getData2() << 16;
    }

    int getPackedMsg() {
        return this.packedMsg;
    }

    @Override
    public byte[] getMessage() {
        int length = 0;
        try {
            length = this.getDataLength(this.packedMsg & 0xFF) + 1;
        }
        catch (InvalidMidiDataException imde) {
            // empty catch block
        }
        byte[] returnedArray = new byte[length];
        if (length > 0) {
            returnedArray[0] = (byte)(this.packedMsg & 0xFF);
            if (length > 1) {
                returnedArray[1] = (byte)((this.packedMsg & 0xFF00) >> 8);
                if (length > 2) {
                    returnedArray[2] = (byte)((this.packedMsg & 0xFF0000) >> 16);
                }
            }
        }
        return returnedArray;
    }

    @Override
    public int getLength() {
        try {
            return this.getDataLength(this.packedMsg & 0xFF) + 1;
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return 0;
        }
    }

    @Override
    public void setMessage(int status) throws InvalidMidiDataException {
        int dataLength = this.getDataLength(status);
        if (dataLength != 0) {
            super.setMessage(status);
        }
        this.packedMsg = this.packedMsg & 0xFFFF00 | status & 0xFF;
    }

    @Override
    public void setMessage(int status, int data1, int data2) throws InvalidMidiDataException {
        this.getDataLength(status);
        this.packedMsg = status & 0xFF | (data1 & 0xFF) << 8 | (data2 & 0xFF) << 16;
    }

    @Override
    public void setMessage(int command, int channel, int data1, int data2) throws InvalidMidiDataException {
        this.getDataLength(command);
        this.packedMsg = command & 0xF0 | channel & 0xF | (data1 & 0xFF) << 8 | (data2 & 0xFF) << 16;
    }

    @Override
    public int getChannel() {
        return this.packedMsg & 0xF;
    }

    @Override
    public int getCommand() {
        return this.packedMsg & 0xF0;
    }

    @Override
    public int getData1() {
        return (this.packedMsg & 0xFF00) >> 8;
    }

    @Override
    public int getData2() {
        return (this.packedMsg & 0xFF0000) >> 16;
    }

    @Override
    public int getStatus() {
        return this.packedMsg & 0xFF;
    }

    @Override
    public Object clone() {
        try {
            return new FastShortMessage(this.packedMsg);
        }
        catch (InvalidMidiDataException invalidMidiDataException) {
            return null;
        }
    }
}

