/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.naming.CommunicationException;

final class LdapRequest {
    LdapRequest next;
    int msgId;
    private int gotten = 0;
    private BlockingQueue<BerDecoder> replies;
    private int highWatermark = -1;
    private boolean cancelled = false;
    private boolean pauseAfterReceipt = false;
    private boolean completed = false;

    LdapRequest(int msgId, boolean pause) {
        this(msgId, pause, -1);
    }

    LdapRequest(int msgId, boolean pause, int replyQueueCapacity) {
        this.msgId = msgId;
        this.pauseAfterReceipt = pause;
        if (replyQueueCapacity == -1) {
            this.replies = new LinkedBlockingQueue<BerDecoder>();
        } else {
            this.replies = new LinkedBlockingQueue<BerDecoder>(replyQueueCapacity);
            this.highWatermark = replyQueueCapacity * 80 / 100;
        }
    }

    synchronized void cancel() {
        this.cancelled = true;
        this.notify();
    }

    synchronized boolean addReplyBer(BerDecoder ber) {
        if (this.cancelled) {
            return false;
        }
        try {
            this.replies.put(ber);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            ber.parseSeq(null);
            ber.parseInt();
            this.completed = ber.peekByte() == 101;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ber.reset();
        this.notify();
        if (this.highWatermark != -1 && this.replies.size() >= this.highWatermark) {
            return true;
        }
        return this.pauseAfterReceipt;
    }

    synchronized BerDecoder getReplyBer() throws CommunicationException {
        if (this.cancelled) {
            throw new CommunicationException("Request: " + this.msgId + " cancelled");
        }
        BerDecoder reply = (BerDecoder)this.replies.poll();
        return reply;
    }

    synchronized boolean hasSearchCompleted() {
        return this.completed;
    }
}

