/*
 * Decompiled with CFR 0.152.
 */
package redstone.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import redstone.xmlrpc.XmlRpcException;
import redstone.xmlrpc.XmlRpcFault;
import redstone.xmlrpc.XmlRpcInvocation;
import redstone.xmlrpc.XmlRpcInvocationHandler;
import redstone.xmlrpc.XmlRpcInvocationInterceptor;
import redstone.xmlrpc.XmlRpcMessages;
import redstone.xmlrpc.XmlRpcParser;
import redstone.xmlrpc.XmlRpcServer;

public class XmlRpcDispatcher
extends XmlRpcParser {
    private XmlRpcServer server;
    private String callerIp;
    private String methodName;
    private List arguments = new ArrayList(6);
    private Writer writer;
    private static int callSequence;
    private static Logger logger;
    static /* synthetic */ Class class$redstone$xmlrpc$XmlRpcDispatcher;

    public XmlRpcDispatcher(XmlRpcServer xmlRpcServer, String string) {
        this.server = xmlRpcServer;
        this.callerIp = string;
    }

    public String getCallerIp() {
        return this.callerIp;
    }

    public void dispatch(InputStream inputStream, Writer writer) throws XmlRpcException {
        this.parse(inputStream);
        this.writer = writer;
        int n = this.methodName.lastIndexOf(".");
        if (n > -1) {
            String string = this.methodName.substring(0, n);
            this.methodName = this.methodName.substring(n + 1);
            XmlRpcInvocationHandler xmlRpcInvocationHandler = this.server.getInvocationHandler(string);
            if (xmlRpcInvocationHandler != null) {
                int n2 = ++callSequence;
                XmlRpcInvocation xmlRpcInvocation = null;
                if (this.server.getInvocationInterceptors().size() > 0) {
                    xmlRpcInvocation = new XmlRpcInvocation(n2, string, this.methodName, xmlRpcInvocationHandler, this.arguments, this.writer);
                }
                try {
                    if (!this.preProcess(xmlRpcInvocation)) {
                        this.writeError(-1, XmlRpcMessages.getString("XmlRpcDispatcher.InvocationCancelled"));
                    } else {
                        Object object = xmlRpcInvocationHandler.invoke(this.methodName, this.arguments);
                        if ((object = this.postProcess(xmlRpcInvocation, object)) != null) {
                            this.writeValue(object);
                        }
                    }
                }
                catch (Throwable throwable) {
                    this.processException(xmlRpcInvocation, throwable);
                    int n3 = -1;
                    if (throwable instanceof XmlRpcFault) {
                        n3 = ((XmlRpcFault)throwable).getErrorCode();
                    }
                    this.writeError(n3, throwable.getClass().getName() + ": " + throwable.getMessage());
                }
            } else {
                this.writeError(-1, XmlRpcMessages.getString("XmlRpcDispatcher.HandlerNotFound"));
            }
        } else {
            this.writeError(-1, XmlRpcMessages.getString("XmlRpcDispatcher.InvalidMethodNameFormat"));
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string2.equals("methodName")) {
            this.methodName = this.consumeCharData();
        } else {
            super.endElement(string, string2, string3);
        }
    }

    protected void handleParsedValue(Object object) {
        this.arguments.add(object);
    }

    private boolean preProcess(XmlRpcInvocation xmlRpcInvocation) {
        for (int i = 0; i < this.server.getInvocationInterceptors().size(); ++i) {
            XmlRpcInvocationInterceptor xmlRpcInvocationInterceptor = (XmlRpcInvocationInterceptor)this.server.getInvocationInterceptors().get(i);
            if (xmlRpcInvocationInterceptor.before(xmlRpcInvocation)) continue;
            return false;
        }
        return true;
    }

    private Object postProcess(XmlRpcInvocation xmlRpcInvocation, Object object) {
        for (int i = 0; i < this.server.getInvocationInterceptors().size(); ++i) {
            XmlRpcInvocationInterceptor xmlRpcInvocationInterceptor = (XmlRpcInvocationInterceptor)this.server.getInvocationInterceptors().get(i);
            object = xmlRpcInvocationInterceptor.after(xmlRpcInvocation, object);
            if (object != null) continue;
            return null;
        }
        return object;
    }

    private void processException(XmlRpcInvocation xmlRpcInvocation, Throwable throwable) {
        for (int i = 0; i < this.server.getInvocationInterceptors().size(); ++i) {
            XmlRpcInvocationInterceptor xmlRpcInvocationInterceptor = (XmlRpcInvocationInterceptor)this.server.getInvocationInterceptors().get(i);
            xmlRpcInvocationInterceptor.onException(xmlRpcInvocation, throwable);
        }
    }

    private void writeValue(Object object) throws IOException {
        this.server.getSerializer().writeEnvelopeHeader(object, this.writer);
        if (object != null) {
            this.server.getSerializer().serialize(object, this.writer);
        }
        this.server.getSerializer().writeEnvelopeFooter(object, this.writer);
    }

    private void writeError(int n, String string) {
        try {
            logger.log(Level.WARNING, string);
            this.server.getSerializer().writeError(n, string, this.writer);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, XmlRpcMessages.getString("XmlRpcDispatcher.ErrorSendingFault"), iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        logger = Logger.getLogger((class$redstone$xmlrpc$XmlRpcDispatcher == null ? (class$redstone$xmlrpc$XmlRpcDispatcher = XmlRpcDispatcher.class$("redstone.xmlrpc.XmlRpcDispatcher")) : class$redstone$xmlrpc$XmlRpcDispatcher).getName());
    }
}

