# - Finds the lxqt package
#
# The module defines the following variables
#
#  LXQT_FOUND         - Set to TRUE if all of the above has been found
#
#  LXQT_SHARE_DIR     - This allows to install and read the configs from non-standard locations
#
#  LXQT_TRANSLATIONS_DIR - The default translations directory
#
#  LXQT_ETC_XDG_DIR   - XDG standards expects system-wide configuration files in the
#                        /etc/xdg/lxqt location. Unfortunately QSettings we are using internally
#                        can be overriden in the Qt compilation time to use different path for
#                        system-wide configs. (for example configure ... -sysconfdir /etc/settings ...)
#                        This path can be found calling Qt's qmake:
#                             qmake -query QT_INSTALL_CONFIGURATION
#
#  LXQT_DATA_DIR      - LXQt base directory relative to which data files should
#                       be searched.Defaults to CMAKE_INSTALL_FULL_DATADIR. It's
#                       added to XDG_DATA_DIRS by the startlxqt script.
#


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was lxqt-config.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(LXQT_USEQT5             ON)
set(LXQT_QT_VERSION         "5")
set(LXQT_MAJOR_VERSION      "0")
set(LXQT_MINOR_VERSION      "10")
set(LXQT_PATCH_VERSION      "0")
set(LXQT_VERSION            "0.10.0")

set(LXQT_RELATIVE_SHARE_DIR "lxqt")
set(LXQT_SHARE_DIR          "/usr/share/lxqt")
set(LXQT_RELATIVE_TRANSLATIONS_DIR "lxqt/translations")
set(LXQT_TRANSLATIONS_DIR   "/usr/share/lxqt/translations")
set(LXQT_GRAPHICS_DIR       "/usr/share/lxqt/graphics")
set(LXQT_ETC_XDG_DIR        "/etc/xdg")
set(LXQT_DATA_DIR           "/usr/share")
set(LXQT_CMAKE_MODULES_DIR  "/usr/share/cmake/lxqt/modules")
set(LXQT_CMAKE_FIND_MODULES_DIR "/usr/share/cmake/lxqt/find-modules")


set(LXQT5_FOUND             1)

include(CMakeFindDependencyMacro)

add_definitions("-DLXQT_RELATIVE_SHARE_DIR=\"${LXQT_RELATIVE_SHARE_DIR}\"")
add_definitions("-DLXQT_SHARE_DIR=\"${LXQT_SHARE_DIR}\"")
add_definitions("-DLXQT_RELATIVE_SHARE_TRANSLATIONS_DIR=\"${LXQT_RELATIVE_TRANSLATIONS_DIR}\"")
add_definitions("-DLXQT_SHARE_TRANSLATIONS_DIR=\"${LXQT_TRANSLATIONS_DIR}\"")
add_definitions("-DLXQT_GRAPHICS_DIR=\"${LXQT_GRAPHICS_DIR}\"")
add_definitions("-DLXQT_ETC_XDG_DIR=\"${LXQT_ETC_XDG_DIR}\"")
add_definitions("-DLXQT_DATA_DIR=\"${LXQT_DATA_DIR}\"")
add_definitions("-DLXQT_VERSION=\"${LXQT_VERSION}\"")

list(APPEND CMAKE_MODULE_PATH
    "${LXQT_CMAKE_MODULES_DIR}"
    "${LXQT_CMAKE_FIND_MODULES_DIR}"
)

find_dependency(Qt5Widgets)
find_dependency(Qt5DBus)
find_dependency(Qt5X11Extras)
find_dependency(Qt5LinguistTools)
find_dependency(Qt5Xdg)
find_dependency(KF5WindowSystem)

if (CMAKE_VERSION VERSION_GREATER 2.8.12)
    cmake_policy(SET CMP0024 OLD)
endif()
include("${CMAKE_CURRENT_LIST_DIR}/lxqt-targets.cmake")
