/*
 * Decompiled with CFR 0.152.
 */
package org.sdg.xdman.gui;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import org.sdg.xdman.core.common.DownloadStateListner;
import org.sdg.xdman.gui.DownloadList;
import org.sdg.xdman.gui.DownloadListItem;
import org.sdg.xdman.gui.XDMTransferHandler;
import org.sdg.xdman.gui.XDMTransferable;

public class FileTransferHandler
extends XDMTransferHandler {
    private static final long serialVersionUID = -339416811193865790L;
    DownloadList list;

    public FileTransferHandler(DownloadList list, DownloadStateListner mgr) {
        super(mgr);
        this.list = list;
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        int i;
        JTable table;
        int[] rows;
        Object[] values = null;
        if (c instanceof JList) {
            values = ((JList)c).getSelectedValues();
        } else if (c instanceof JTable && (rows = (table = (JTable)c).getSelectedRows()) != null) {
            values = new Object[rows.length];
            i = 0;
            while (i < rows.length) {
                int index = rows[i];
                DownloadListItem item = this.list.get(index);
                File file = new File(item.saveto, item.filename);
                values[i] = file;
                ++i;
            }
        }
        if (values == null || values.length == 0) {
            return null;
        }
        StringBuffer plainBuf = new StringBuffer();
        StringBuffer htmlBuf = new StringBuffer();
        htmlBuf.append("<html>\n<body>\n<ul>\n");
        i = 0;
        while (i < values.length) {
            Object obj = values[i];
            String val = obj == null ? "" : obj.toString();
            plainBuf.append(String.valueOf(val) + "\n");
            htmlBuf.append("  <li>" + val + "\n");
            ++i;
        }
        plainBuf.deleteCharAt(plainBuf.length() - 1);
        htmlBuf.append("</ul>\n</body>\n</html>");
        return new FileTransferable(plainBuf.toString(), htmlBuf.toString(), values);
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    static class FileTransferable
    extends XDMTransferable {
        Object[] fileData;

        FileTransferable(String plainData, String htmlData, Object[] fileData) {
            super(plainData, htmlData);
            this.fileData = fileData;
        }

        @Override
        protected DataFlavor[] getRicherFlavors() {
            DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
            return flavors;
        }

        @Override
        protected Object getRicherData(DataFlavor flavor) {
            if (DataFlavor.javaFileListFlavor.equals(flavor)) {
                ArrayList<Object> files = new ArrayList<Object>();
                int i = 0;
                while (i < this.fileData.length) {
                    files.add(this.fileData[i]);
                    ++i;
                }
                return files;
            }
            if (DataFlavor.stringFlavor.equals(flavor)) {
                ArrayList<Object> files = new ArrayList<Object>();
                int i = 0;
                while (i < this.fileData.length) {
                    files.add(this.fileData[i]);
                    ++i;
                }
                return files;
            }
            return null;
        }
    }
}

