/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.ui.progress.IProgressConstants;
import org.rssowl.core.util.ITask;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.ui.internal.Activator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DownloadJobQueue {
    private final AtomicInteger fScheduledJobs = new AtomicInteger(0);
    private final BlockingQueue<DownloadTask> fOpenTasksQueue;
    private final int fMaxConcurrentJobs;
    private String fName;

    public DownloadJobQueue(String name, int maxConcurrentJobs, int maxQueueSize) {
        Assert.isNotNull((Object)name);
        this.fName = name;
        this.fMaxConcurrentJobs = maxConcurrentJobs;
        this.fOpenTasksQueue = new LinkedBlockingQueue<DownloadTask>(maxQueueSize);
    }

    public boolean schedule(DownloadTask task) {
        return this.schedule(Collections.singletonList(task));
    }

    public boolean schedule(List<DownloadTask> tasks) {
        int tasksSize = tasks.size();
        if (tasksSize == 0) {
            return true;
        }
        for (DownloadTask task : tasks) {
            try {
                this.fOpenTasksQueue.put(task);
            }
            catch (InterruptedException interruptedException) {
                return false;
            }
        }
        if (this.fScheduledJobs.get() >= this.fMaxConcurrentJobs) {
            return true;
        }
        int i = 0;
        while (i < tasksSize && !this.fOpenTasksQueue.isEmpty()) {
            if (this.fScheduledJobs.incrementAndGet() > this.fMaxConcurrentJobs) {
                this.fScheduledJobs.decrementAndGet();
                break;
            }
            this.scheduleTaskJob();
            ++i;
        }
        return true;
    }

    private void scheduleTaskJob() {
        Job job = this.createTaskJob();
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (!DownloadJobQueue.this.fOpenTasksQueue.isEmpty()) {
                    DownloadJobQueue.this.scheduleTaskJob();
                } else {
                    DownloadJobQueue.this.fScheduledJobs.decrementAndGet();
                }
            }
        });
        job.setProperty(IProgressConstants.NO_IMMEDIATE_ERROR_PROMPT_PROPERTY, (Object)Boolean.TRUE);
        job.schedule();
    }

    public boolean isQueued(DownloadTask task) {
        return this.fOpenTasksQueue.contains(task);
    }

    private Job createTaskJob() {
        Job job = new Job(this.fName){

            protected IStatus run(final IProgressMonitor monitor) {
                final 2 job = this;
                final IStatus[] status = new IStatus[1];
                final DownloadTask task = (DownloadTask)DownloadJobQueue.this.fOpenTasksQueue.poll();
                if (task == null) {
                    return Status.OK_STATUS;
                }
                if (!monitor.isCanceled()) {
                    SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                        public void run() throws Exception {
                            status[0] = task.run(job, monitor);
                            if (status[0].getSeverity() == 4 && Activator.getDefault() != null) {
                                Activator.getDefault().getLog().log(status[0]);
                            }
                        }
                    });
                }
                return monitor.isCanceled() ? Status.CANCEL_STATUS : status[0];
            }

            public boolean belongsTo(Object family) {
                return family == DownloadJobQueue.this;
            }
        };
        return job;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel(boolean joinRunning) {
        DownloadJobQueue downloadJobQueue = this;
        synchronized (downloadJobQueue) {
            this.fOpenTasksQueue.clear();
            Job.getJobManager().cancel((Object)this);
        }
        if (joinRunning) {
            while (Job.getJobManager().find((Object)this).length != 0) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
    }

    public boolean isWorking() {
        Job[] activeDownloads = Job.getJobManager().find((Object)this);
        return activeDownloads != null && activeDownloads.length > 0;
    }

    public static abstract class DownloadTask
    implements ITask {
        public IStatus run(IProgressMonitor monitor) {
            return this.run(null, monitor);
        }

        public abstract IStatus run(Job var1, IProgressMonitor var2);
    }
}

