/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DAOService;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.service.PersistenceException;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.ReparentInfo;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.SyncUtils;
import org.rssowl.ui.internal.Activator;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.actions.ReloadTypesAction;
import org.rssowl.ui.internal.dialogs.ConfirmDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsubscribeGoogleReaderAction
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        ConfirmDialog dialog = new ConfirmDialog(this.fWindow.getShell(), Messages.UnsubscribeGoogleReaderAction_0, Messages.UnsubscribeGoogleReaderAction_1, Messages.UnsubscribeGoogleReaderAction_2, Messages.UnsubscribeGoogleReaderAction_3, null){

            protected String getTitleLabel() {
                return Messages.UnsubscribeGoogleReaderAction_4;
            }

            protected String getTitleImage() {
                return "/icons/wizban/reader_wiz.png";
            }
        };
        if (dialog.open() == 0) {
            try {
                Controller.getDefault().stopUpdate();
                List<IBookMark> feedsToReload = this.internalRun();
                if (feedsToReload.size() > 0) {
                    new ReloadTypesAction((IStructuredSelection)new StructuredSelection(feedsToReload), this.fWindow.getShell()).run();
                }
            }
            catch (PersistenceException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (URISyntaxException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    private List<IBookMark> internalRun() throws URISyntaxException {
        ArrayList<IBookMark> feedsToReload = new ArrayList<IBookMark>();
        IFolder root = OwlUI.getSelectedBookMarkSet();
        IFolder archive = null;
        Collection bookmarks = DynamicDAO.loadAll(IBookMark.class);
        for (IBookMark oldBookMark : bookmarks) {
            if (!SyncUtils.isSynchronized((IBookMark)oldBookMark)) continue;
            String oldFeedLink = oldBookMark.getFeedLinkReference().getLinkAsText();
            if (!(oldFeedLink.equals("reader://shared") || oldFeedLink.equals("reader://recommended") || oldFeedLink.equals("reader://notes"))) {
                URI newFeedLink = oldFeedLink.indexOf("readers") == 0 ? new URI(StringUtils.replaceAll((String)oldFeedLink, (String)"readers://", (String)"https://")) : new URI(StringUtils.replaceAll((String)oldFeedLink, (String)"reader://", (String)"http://"));
                IBookMark newBookMark = Owl.getModelFactory().createBookMark(null, oldBookMark.getParent(), new FeedLinkReference(newFeedLink), oldBookMark.getName(), (IFolderChild)oldBookMark, Boolean.valueOf(true));
                feedsToReload.add(newBookMark);
                Map properties = oldBookMark.getProperties();
                Set keySet = properties.keySet();
                for (String key : keySet) {
                    newBookMark.setProperty(key, (Serializable)properties.get(key));
                }
                newBookMark.setProperty(DefaultPreferences.NEVER_DEL_LABELED_NEWS_STATE, (Serializable)Boolean.valueOf(true));
                newBookMark.setCreationDate(oldBookMark.getCreationDate());
                newBookMark.setLastVisitDate(oldBookMark.getLastVisitDate());
                newBookMark.setPopularity(oldBookMark.getPopularity());
                DAOService daoService = Owl.getPersistenceService().getDAOService();
                if (!daoService.getFeedDAO().exists(newFeedLink)) {
                    IFeed feed = Owl.getModelFactory().createFeed(null, newFeedLink);
                    feed = (IFeed)DynamicDAO.save((IPersistable)feed);
                }
                DynamicDAO.save((IPersistable)oldBookMark.getParent());
            }
            oldBookMark.setProperty(DefaultPreferences.BM_RELOAD_ON_STARTUP, (Serializable)Boolean.valueOf(false));
            oldBookMark.setProperty(DefaultPreferences.BM_UPDATE_INTERVAL_STATE, (Serializable)Boolean.valueOf(false));
            DynamicDAO.save((IPersistable)oldBookMark);
            if (archive == null) {
                archive = Owl.getModelFactory().createFolder(null, root, "Google Reader Archive");
                archive.setProperty(DefaultPreferences.BM_RELOAD_ON_STARTUP, (Serializable)Boolean.valueOf(false));
                archive.setProperty(DefaultPreferences.BM_UPDATE_INTERVAL_STATE, (Serializable)Boolean.valueOf(false));
                DynamicDAO.save((IPersistable)root);
            }
            ArrayList<ReparentInfo> reparenting = new ArrayList<ReparentInfo>();
            reparenting.add(ReparentInfo.create((Object)oldBookMark, (Object)archive, null, null));
            CoreUtils.reparentWithProperties(reparenting);
        }
        if (archive != null) {
            archive.sort();
            DynamicDAO.save(archive);
        }
        return feedsToReload;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

