/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.ui.internal.ApplicationWorkbenchWindowAdvisor;
import org.rssowl.ui.internal.Controller;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private static final String PERSPECTIVE_ID = "org.rssowl.ui.perspective";
    public static ApplicationWorkbenchWindowAdvisor fgPrimaryApplicationWorkbenchWindowAdvisor;
    private final Runnable fRunAfterUIStartup;

    public ApplicationWorkbenchAdvisor(Runnable runAfterUIStartup) {
        this.fRunAfterUIStartup = runAfterUIStartup;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        ApplicationWorkbenchWindowAdvisor advisor = new ApplicationWorkbenchWindowAdvisor(configurer);
        if (fgPrimaryApplicationWorkbenchWindowAdvisor == null) {
            fgPrimaryApplicationWorkbenchWindowAdvisor = advisor;
        }
        return advisor;
    }

    ApplicationWorkbenchWindowAdvisor getPrimaryWorkbenchWindowAdvisor() {
        return fgPrimaryApplicationWorkbenchWindowAdvisor;
    }

    public String getInitialWindowPerspectiveId() {
        return PERSPECTIVE_ID;
    }

    public String getMainPreferencePageId() {
        return "org.eclipse.ui.preferencePages.Workbench";
    }

    public IAdaptable getDefaultPageInput() {
        return super.getDefaultPageInput();
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        IWorkbenchConfigurer workbenchConfigurer = this.getWorkbenchConfigurer();
        workbenchConfigurer.setSaveAndRestore(true);
        super.initialize(configurer);
    }

    public void postStartup() {
        super.postStartup();
        if (this.fRunAfterUIStartup != null) {
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    ApplicationWorkbenchAdvisor.this.fRunAfterUIStartup.run();
                }
            });
        }
    }

    public boolean preShutdown() {
        final boolean[] res = new boolean[]{true};
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                res[0] = Controller.getDefault().preUIShutdown();
            }
        });
        return res[0];
    }
}

