/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.newsaction;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.INewsAction;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.newsaction.Messages;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.INews;
import org.rssowl.core.util.BatchedBuffer;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.StreamGobbler;
import org.rssowl.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrowlNotifyAction
implements INewsAction {
    private static final int BATCH_INTERVAL = 5000;
    private static final int MAX_ITEMS_TO_SHOW = 5;
    private static final String APPLICATION_NAME = "RSSOwl";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private BatchedBuffer<INews> fBatchedBuffer;
    private String fPathToGrowlNotify;

    public GrowlNotifyAction() {
        BatchedBuffer.Receiver<INews> receiver = new BatchedBuffer.Receiver<INews>(){

            @Override
            public IStatus receive(Collection<INews> items, Job job, IProgressMonitor monitor) {
                try {
                    if (!Owl.isShuttingDown()) {
                        GrowlNotifyAction.this.executeCommand(GrowlNotifyAction.this.fPathToGrowlNotify, items);
                    }
                }
                catch (IOException e) {
                    Activator.safeLogError(e.getMessage(), e);
                }
                return Status.OK_STATUS;
            }
        };
        this.fBatchedBuffer = new BatchedBuffer<INews>(receiver, 5000);
    }

    @Override
    public List<IEntity> run(List<INews> news, Map<INews, INews> replacements, Object data) {
        news = CoreUtils.replace(news, replacements);
        if (data instanceof String && new File((String)data).exists()) {
            this.fPathToGrowlNotify = (String)data;
            this.fBatchedBuffer.addAll(news);
        }
        return Collections.emptyList();
    }

    private void executeCommand(String pathToGrowlnotify, Collection<INews> news) throws IOException {
        if (StringUtils.isSet(pathToGrowlnotify)) {
            ArrayList<String> commands = new ArrayList<String>();
            commands.add(pathToGrowlnotify);
            commands.add("--name");
            commands.add(APPLICATION_NAME);
            commands.add("-a");
            commands.add(APPLICATION_NAME);
            commands.add("-t");
            commands.add(NLS.bind((String)Messages.GrowlNotifyAction_N_INCOMING_NEWS, (Object)news.size()));
            commands.add("-m");
            TreeSet<INews> sortedNews = new TreeSet<INews>(new Comparator<INews>(){

                @Override
                public int compare(INews news1, INews news2) {
                    Date date1 = DateUtils.getRecentDate(news1);
                    Date date2 = DateUtils.getRecentDate(news2);
                    int res = date2.compareTo(date1);
                    if (res != 0) {
                        return res;
                    }
                    return -1;
                }
            });
            sortedNews.addAll(news);
            int i = 0;
            StringBuilder message = new StringBuilder();
            for (INews item : sortedNews) {
                if (++i > 5) break;
                message.append(CoreUtils.getHeadline(item, true)).append(SEPARATOR).append(SEPARATOR);
            }
            if (news.size() > 5) {
                message.append(NLS.bind((String)Messages.GrowlNotifyAction_N_MORE, (Object)(news.size() - 5)));
            }
            commands.add(message.toString());
            Process proc = Runtime.getRuntime().exec(commands.toArray(new String[commands.size()]));
            OutputStream outputStream = proc.getOutputStream();
            outputStream.write(message.toString().getBytes());
            outputStream.close();
            StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream());
            StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream());
            errorGobbler.schedule();
            outputGobbler.schedule();
        }
    }

    @Override
    public boolean conflictsWith(INewsAction otherAction) {
        return false;
    }

    @Override
    public String getLabel(Object data) {
        return null;
    }
}

