/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import org.jdom.Attribute;
import org.jdom.Element;
import org.rssowl.core.Owl;
import org.rssowl.core.interpreter.INamespaceHandler;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IImage;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.persist.ITextInput;
import org.rssowl.core.util.DateUtils;
import org.rssowl.core.util.URIUtils;

public class DublinCoreNamespaceHandler
implements INamespaceHandler {
    public void processElement(Element element, IPersistable type) {
        String name = element.getName().toLowerCase();
        if ("title".equals(name)) {
            if (type instanceof IFeed) {
                ((IFeed)type).setTitle(element.getText());
            } else if (type instanceof INews) {
                ((INews)type).setTitle(element.getText());
            } else if (type instanceof IImage) {
                ((IImage)type).setTitle(element.getText());
            } else if (type instanceof ITextInput) {
                ((ITextInput)type).setTitle(element.getText());
            }
        } else if ("description".equals(name)) {
            if (type instanceof IFeed) {
                ((IFeed)type).setDescription(element.getText());
            } else if (type instanceof INews) {
                ((INews)type).setDescription(element.getText());
            } else if (type instanceof IImage) {
                ((IImage)type).setDescription(element.getText());
            } else if (type instanceof ITextInput) {
                ((ITextInput)type).setDescription(element.getText());
            }
        } else if ("date".equals(name)) {
            if (type instanceof IFeed) {
                ((IFeed)type).setPublishDate(DateUtils.parseDate(element.getText()));
            } else if (type instanceof INews) {
                ((INews)type).setPublishDate(DateUtils.parseDate(element.getText()));
            }
        } else if ("modified".equals(name)) {
            if (type instanceof IFeed) {
                ((IFeed)type).setLastModifiedDate(DateUtils.parseDate(element.getText()));
            } else if (type instanceof INews) {
                ((INews)type).setModifiedDate(DateUtils.parseDate(element.getText()));
            }
        } else if ("creator".equals(name)) {
            IPerson person = Owl.getModelFactory().createPerson(null, type);
            person.setName(element.getText());
        } else if ("publisher".equals(name)) {
            boolean usePublisher = true;
            if (type instanceof IFeed && ((IFeed)type).getAuthor() != null) {
                usePublisher = false;
            } else if (type instanceof INews && ((INews)type).getAuthor() != null) {
                usePublisher = false;
            }
            if (usePublisher) {
                IPerson person = Owl.getModelFactory().createPerson(null, type);
                person.setName(element.getText());
            }
        } else if ("language".equals(name) && type instanceof IFeed) {
            ((IFeed)type).setLanguage(element.getText());
        } else if ("rights".equals(name) && type instanceof IFeed) {
            ((IFeed)type).setCopyright(element.getText());
        } else if ("subject".equals(name) && type instanceof IEntity) {
            ICategory category = Owl.getModelFactory().createCategory(null, (IEntity)type);
            category.setName(element.getText());
        } else if ("identifier".equals(name) && type instanceof INews) {
            Owl.getModelFactory().createGuid((INews)type, element.getText(), null);
        } else if ("source".equals(name) && type instanceof INews) {
            ISource source = Owl.getModelFactory().createSource((INews)type);
            source.setLink(URIUtils.createURI(element.getText()));
        }
    }

    public void processAttribute(Attribute attribute, IPersistable type) {
    }
}

