/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.connection;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.net.proxy.IProxyService;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.security.storage.EncodingUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.rssowl.core.Owl;
import org.rssowl.core.connection.CredentialsException;
import org.rssowl.core.connection.ICredentials;
import org.rssowl.core.connection.ICredentialsProvider;
import org.rssowl.core.connection.IProxyCredentials;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.core.util.Pair;
import org.rssowl.core.util.StringUtils;
import org.rssowl.core.util.URIUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlatformCredentialsProvider
implements ICredentialsProvider {
    private static final String SECURE_FEED_NODE = "rssowl/feeds";
    private static final String SECURE_STORAGE_FILE = ".credentials";
    private static final String WIN_PW_PROVIDER_ID = "org.eclipse.equinox.security.WindowsPasswordProvider";
    private static final String RSSOWL_PW_PROVIDER_ID = "org.rssowl.ui.RSSOwlPasswordProvider";
    private static final String MACOS_PW_PROVIDER_ID = "org.eclipse.equinox.security.OSXKeystoreIntegration";
    private static final String USERNAME = "org.rssowl.core.connection.auth.Username";
    private static final String PASSWORD = "org.rssowl.core.connection.auth.Password";
    private static final String DOMAIN = "org.rssowl.core.connection.auth.Domain";
    private static final String DOMAIN_SEPARATOR = "\\";
    private static final String ENABLE_NTLM_PROXY = "enableNtlmProxy";
    private static final boolean NTLM_PROXY_ENABLED = System.getProperty("enableNtlmProxy") != null;
    private static final String REALM = "";
    private final Set<String> fUnprotectedLinksCache = Collections.synchronizedSet(new HashSet());
    private final Map<String, ICredentials> fInMemoryStore = Collections.synchronizedMap(new HashMap());

    @Override
    public ICredentials getPersistedAuthCredentials(URI link, String realm) throws CredentialsException {
        return this.internalGetAuthCredentials(link, realm, true);
    }

    @Override
    public synchronized ICredentials getAuthCredentials(URI link, String realm) throws CredentialsException {
        return this.internalGetAuthCredentials(link, realm, false);
    }

    private synchronized ICredentials internalGetAuthCredentials(URI link, String realm, boolean persistedOnly) throws CredentialsException {
        ICredentials inMemoryCredentials;
        if (this.isUnprotected(link, realm)) {
            return null;
        }
        if (!persistedOnly && (inMemoryCredentials = this.fInMemoryStore.get(this.toCacheKey(link, realm))) != null) {
            return inMemoryCredentials;
        }
        ICredentials authorizationInfo = this.getAuthorizationInfo(link, realm);
        if (authorizationInfo != null) {
            return authorizationInfo;
        }
        if (!persistedOnly || !this.fInMemoryStore.containsKey(this.toCacheKey(link, realm))) {
            this.addUnprotected(link, realm);
        }
        return null;
    }

    private ISecurePreferences getSecurePreferences() {
        Activator activator;
        boolean useOSPasswordProvider;
        block11: {
            IPreferenceScope prefs = Owl.getPreferenceService().getGlobalScope();
            useOSPasswordProvider = prefs.getBoolean(DefaultPreferences.USE_OS_PASSWORD);
            if (prefs.getBoolean(DefaultPreferences.USE_MASTER_PASSWORD)) {
                useOSPasswordProvider = false;
            }
            activator = Activator.getDefault();
            if (activator != null) break block11;
            return null;
        }
        try {
            IPath stateLocation = activator.getStateLocation();
            stateLocation = stateLocation.append(SECURE_STORAGE_FILE);
            URL location = stateLocation.toFile().toURL();
            HashMap<String, String> options = null;
            if (useOSPasswordProvider) {
                if ("win32".equals(Platform.getOS())) {
                    options = new HashMap();
                    options.put("org.eclipse.equinox.security.storage.requiredID", WIN_PW_PROVIDER_ID);
                } else if ("macosx".equals(Platform.getOS())) {
                    options = new HashMap();
                    options.put("org.eclipse.equinox.security.storage.requiredID", MACOS_PW_PROVIDER_ID);
                }
            } else {
                options = new HashMap<String, String>();
                options.put("org.eclipse.equinox.security.storage.requiredID", RSSOWL_PW_PROVIDER_ID);
            }
            return SecurePreferencesFactory.open((URL)location, options);
        }
        catch (MalformedURLException e) {
            Activator.safeLogError(e.getMessage(), e);
        }
        catch (IllegalStateException e1) {
            Activator.safeLogError(e1.getMessage(), e1);
        }
        catch (IOException e2) {
            Activator.safeLogError(e2.getMessage(), e2);
        }
        return SecurePreferencesFactory.getDefault();
    }

    private ICredentials getAuthorizationInfo(URI link, String realm) throws CredentialsException {
        ISecurePreferences feedPreferences;
        ISecurePreferences allFeedsPreferences;
        ISecurePreferences securePreferences = this.getSecurePreferences();
        if (securePreferences == null) {
            return null;
        }
        if (securePreferences.nodeExists(SECURE_FEED_NODE) && (allFeedsPreferences = securePreferences.node(SECURE_FEED_NODE)).nodeExists(EncodingUtils.encodeSlashes((String)link.toString())) && (feedPreferences = allFeedsPreferences.node(EncodingUtils.encodeSlashes((String)link.toString()))).nodeExists(EncodingUtils.encodeSlashes((String)(realm != null ? realm : REALM)))) {
            ISecurePreferences realmPreferences = feedPreferences.node(EncodingUtils.encodeSlashes((String)(realm != null ? realm : REALM)));
            try {
                String username = realmPreferences.get(USERNAME, null);
                String password = realmPreferences.get(PASSWORD, null);
                String domain = realmPreferences.get(DOMAIN, null);
                if (username != null && password != null) {
                    return new Credentials(username, password, domain);
                }
            }
            catch (StorageException e) {
                throw new CredentialsException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
        return null;
    }

    @Override
    public IProxyCredentials getProxyCredentials(URI link) {
        boolean isSSL;
        Activator activator = Activator.getDefault();
        if (activator == null) {
            return null;
        }
        IProxyService proxyService = activator.getProxyService();
        if (!proxyService.isProxiesEnabled()) {
            return null;
        }
        String host = URIUtils.safeGetHost(link);
        IProxyData proxyData = proxyService.getProxyDataForHost(host, (isSSL = "https".equals(link.getScheme())) ? "HTTPS" : "HTTP");
        if (proxyData != null) {
            final String proxyHost = proxyData.getHost();
            final int proxyPort = proxyData.getPort();
            final Pair<String, String> proxyUserAndDomain = this.splitUserAndDomain(proxyData.getUserId());
            final String proxyPassword = proxyData.getPassword();
            return new IProxyCredentials(){

                public String getHost() {
                    return proxyHost;
                }

                public int getPort() {
                    return proxyPort;
                }

                public String getUsername() {
                    return (String)proxyUserAndDomain.getFirst();
                }

                public String getPassword() {
                    return proxyPassword;
                }

                public String getDomain() {
                    return (String)proxyUserAndDomain.getSecond();
                }
            };
        }
        return null;
    }

    private Pair<String, String> splitUserAndDomain(String username) {
        if (NTLM_PROXY_ENABLED && StringUtils.isSet(username) && username.contains(DOMAIN_SEPARATOR)) {
            String user = null;
            String domain = null;
            StringTokenizer tokenizer = new StringTokenizer(username, DOMAIN_SEPARATOR);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!StringUtils.isSet(token)) continue;
                if (domain == null) {
                    domain = token;
                    continue;
                }
                if (user != null) continue;
                user = token;
            }
            if (StringUtils.isSet(user) && StringUtils.isSet(domain)) {
                return Pair.create(user, domain);
            }
        }
        return Pair.create(username, null);
    }

    @Override
    public void setAuthCredentials(ICredentials credentials, URI link, String realm) throws CredentialsException {
        this.internalSetAuthCredentials(credentials, link, realm, true);
    }

    @Override
    public void setInMemoryAuthCredentials(ICredentials credentials, URI link, String realm) throws CredentialsException {
        this.internalSetAuthCredentials(credentials, link, realm, false);
    }

    private void internalSetAuthCredentials(ICredentials credentials, URI link, String realm, boolean persist) throws CredentialsException {
        if (!persist) {
            this.fInMemoryStore.put(this.toCacheKey(link, realm), credentials);
        } else {
            ISecurePreferences securePreferences = this.getSecurePreferences();
            if (securePreferences == null) {
                return;
            }
            ISecurePreferences allFeedsPreferences = securePreferences.node(SECURE_FEED_NODE);
            ISecurePreferences feedPreferences = allFeedsPreferences.node(EncodingUtils.encodeSlashes((String)link.toString()));
            ISecurePreferences realmPreference = feedPreferences.node(EncodingUtils.encodeSlashes((String)(realm != null ? realm : REALM)));
            IPreferenceScope globalScope = Owl.getPreferenceService().getGlobalScope();
            boolean useOSPassword = globalScope.getBoolean(DefaultPreferences.USE_OS_PASSWORD);
            if (!"win32".equals(Platform.getOS()) && !"macosx".equals(Platform.getOS())) {
                useOSPassword = false;
            }
            boolean encryptPW = useOSPassword || globalScope.getBoolean(DefaultPreferences.USE_MASTER_PASSWORD);
            try {
                if (credentials.getUsername() != null) {
                    realmPreference.put(USERNAME, credentials.getUsername(), encryptPW);
                }
                if (credentials.getPassword() != null) {
                    realmPreference.put(PASSWORD, credentials.getPassword(), encryptPW);
                }
                if (credentials.getDomain() != null) {
                    realmPreference.put(DOMAIN, credentials.getDomain(), encryptPW);
                }
                realmPreference.flush();
            }
            catch (StorageException e) {
                throw new CredentialsException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
            catch (IOException e) {
                throw new CredentialsException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
        this.removeUnprotected(link, realm);
    }

    @Override
    public void setProxyCredentials(IProxyCredentials credentials, URI link) {
        IProxyService proxyService = Activator.getDefault().getProxyService();
        proxyService.setProxiesEnabled(true);
        boolean isSSL = "https".equals(link.getScheme());
        IProxyData proxyData = proxyService.getProxyData(isSSL ? "HTTPS" : "HTTP");
        if (proxyData != null) {
            proxyData.setHost(credentials.getHost());
            proxyData.setPort(credentials.getPort());
            proxyData.setUserid(credentials.getUsername());
            proxyData.setPassword(credentials.getPassword());
        }
    }

    @Override
    public synchronized void deleteAuthCredentials(URI link, String realm) throws CredentialsException {
        ISecurePreferences feedPreferences;
        ISecurePreferences allFeedsPreferences;
        this.fInMemoryStore.remove(this.toCacheKey(link, realm));
        this.removeUnprotected(link, realm);
        ISecurePreferences securePreferences = this.getSecurePreferences();
        if (securePreferences == null) {
            return;
        }
        if (securePreferences.nodeExists(SECURE_FEED_NODE) && (allFeedsPreferences = securePreferences.node(SECURE_FEED_NODE)).nodeExists(EncodingUtils.encodeSlashes((String)link.toString())) && (feedPreferences = allFeedsPreferences.node(EncodingUtils.encodeSlashes((String)link.toString()))).nodeExists(EncodingUtils.encodeSlashes((String)(realm != null ? realm : REALM)))) {
            ISecurePreferences realmPreferences = feedPreferences.node(EncodingUtils.encodeSlashes((String)(realm != null ? realm : REALM)));
            realmPreferences.clear();
            realmPreferences.removeNode();
            try {
                feedPreferences.flush();
            }
            catch (IOException e) {
                throw new CredentialsException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
            }
        }
    }

    @Override
    public void deleteProxyCredentials(URI link) {
        IProxyService proxyService = Activator.getDefault().getProxyService();
        proxyService.setProxiesEnabled(false);
    }

    public void clear() {
        String[] childrenNames;
        this.fInMemoryStore.clear();
        this.fUnprotectedLinksCache.clear();
        InternalExchangeUtils.passwordProvidersReset();
        ISecurePreferences secureRoot = this.getSecurePreferences();
        if (secureRoot == null) {
            return;
        }
        String[] stringArray = childrenNames = secureRoot.childrenNames();
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            secureRoot.node(child).removeNode();
            ++n2;
        }
        try {
            secureRoot.flush();
        }
        catch (IOException e) {
            Activator.getDefault().logError(e.getMessage(), e);
        }
    }

    private boolean isUnprotected(URI link, String realm) {
        return this.fUnprotectedLinksCache.contains(this.toCacheKey(link, realm));
    }

    private void addUnprotected(URI link, String realm) {
        this.fUnprotectedLinksCache.add(this.toCacheKey(link, realm));
    }

    private void removeUnprotected(URI link, String realm) {
        this.fUnprotectedLinksCache.remove(this.toCacheKey(link, realm));
    }

    private String toCacheKey(URI link, String realm) {
        if (realm == null) {
            realm = REALM;
        }
        return String.valueOf(link.toString()) + realm;
    }

    private static class Credentials
    implements ICredentials {
        private String fUsername;
        private String fPassword;
        private String fDomain;

        Credentials(String username, String password, String domain) {
            this.fUsername = username;
            this.fPassword = password;
            this.fDomain = domain;
        }

        public String getUsername() {
            return this.fUsername;
        }

        public String getPassword() {
            return this.fPassword;
        }

        public String getDomain() {
            return this.fDomain;
        }
    }
}

