/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.config.Configuration;
import com.db4o.ext.MemoryFile;
import com.db4o.internal.Buffer;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.ObjectContainerBase;
import java.io.IOException;

public class InMemoryObjectContainer
extends LocalObjectContainer {
    private boolean _closed = false;
    private final MemoryFile _memoryFile;
    private int _length = 0;

    protected InMemoryObjectContainer(Configuration configuration, ObjectContainerBase objectContainerBase, MemoryFile memoryFile) {
        super(configuration, objectContainerBase);
        this._memoryFile = memoryFile;
        try {
            this.open();
        }
        catch (Exception exception) {
            Exceptions4.throwRuntimeException(22, exception);
        }
        this.initialize3();
    }

    public InMemoryObjectContainer(Configuration configuration, MemoryFile memoryFile) {
        this(configuration, null, memoryFile);
    }

    public void backup(String string) throws IOException {
        Exceptions4.throwRuntimeException(60);
    }

    public void blockSize(int n) {
    }

    protected boolean close2() {
        try {
            this.write(true);
        }
        catch (Throwable throwable) {
            this.fatalException(throwable);
        }
        super.close2();
        if (!this._closed) {
            byte[] byArray = new byte[this._length];
            System.arraycopy(this._memoryFile.getBytes(), 0, byArray, 0, this._length);
            this._memoryFile.setBytes(byArray);
        }
        this._closed = true;
        return true;
    }

    public void copy(int n, int n2, int n3, int n4, int n5) {
        int n6 = n3 + n4;
        this.ensureMemoryFileSize(n6 + n5);
        byte[] byArray = this._memoryFile.getBytes();
        System.arraycopy(byArray, n + n2, byArray, n6, n5);
    }

    void emergencyClose() {
        super.emergencyClose();
        this._closed = true;
    }

    public long fileLength() {
        return this._length;
    }

    public String fileName() {
        return "Memory File";
    }

    protected boolean hasShutDownHook() {
        return false;
    }

    public final boolean needsLockFileThread() {
        return false;
    }

    private void open() throws IOException {
        byte[] byArray = this._memoryFile.getBytes();
        if (byArray == null || byArray.length == 0) {
            this._memoryFile.setBytes(new byte[this._memoryFile.getInitialSize()]);
            this.configureNewFile();
            this.write(false);
            this.writeHeader(false, false);
        } else {
            this._length = byArray.length;
            this.readThis();
        }
    }

    public void readBytes(byte[] byArray, int n, int n2) {
        try {
            System.arraycopy(this._memoryFile.getBytes(), n, byArray, 0, n2);
        }
        catch (Exception exception) {
            Exceptions4.throwRuntimeException(13, exception);
        }
    }

    public void readBytes(byte[] byArray, int n, int n2, int n3) {
        this.readBytes(byArray, n + n2, n3);
    }

    public void syncFiles() {
    }

    public void writeBytes(Buffer buffer, int n, int n2) {
        int n3 = n + n2;
        int n4 = buffer.getLength();
        this.ensureMemoryFileSize(n3 + n4);
        System.arraycopy(buffer._buffer, 0, this._memoryFile.getBytes(), n3, n4);
    }

    private void ensureMemoryFileSize(int n) {
        int n2;
        if (n < this._length) {
            return;
        }
        byte[] byArray = this._memoryFile.getBytes();
        if (n < byArray.length) {
            this._length = n;
            return;
        }
        for (n2 = this._memoryFile.getIncrementSizeBy(); n > n2; n2 <<= 1) {
        }
        byte[] byArray2 = new byte[byArray.length + n2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        this._memoryFile.setBytes(byArray2);
        this._length = byArray2.length;
    }

    public void overwriteDeletedBytes(int n, int n2) {
    }
}

