// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.platform');
goog.require('cljs.core');
goog.require('lt.util.dom');
goog.require('lt.util.dom');
goog.require('lt.object');
goog.require('lt.object');
lt.objs.platform.electron = true;
lt.objs.platform.fs = require("fs");
lt.objs.platform.clipboard = require("clipboard");
lt.objs.platform.shell = require("shell");
lt.objs.platform.get_data_path = (function get_data_path(){return require("remote").require("app").getDataPath();
});
lt.objs.platform.normalize = (function normalize(plat){var pred__10946 = cljs.core._EQ_;var expr__10947 = plat;if(cljs.core.truth_(pred__10946.call(null,"win32",expr__10947)))
{return new cljs.core.Keyword(null,"windows","windows",2363397621);
} else
{if(cljs.core.truth_(pred__10946.call(null,"linux",expr__10947)))
{return new cljs.core.Keyword(null,"linux","linux",1116882022);
} else
{if(cljs.core.truth_(pred__10946.call(null,"darwin",expr__10947)))
{return new cljs.core.Keyword(null,"mac","mac",1014012097);
} else
{throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(expr__10947)].join('')));
}
}
}
});
lt.objs.platform.open_url = (function open_url(path){return lt.objs.platform.shell.openExternal(path);
});
/**
* If the given path exists, open it with the desktop's default manner.
* Otherwise, open it as an external protocol e.g. a url.
*/
lt.objs.platform.open = (function open(path){if(cljs.core.truth_(lt.objs.platform.fs.existsSync(path)))
{return lt.objs.platform.shell.openItem(path);
} else
{return lt.objs.platform.open_url.call(null,path);
}
});
lt.objs.platform.show_item = (function show_item(path){return lt.objs.platform.shell.showItemInFolder(path);
});
/**
* Copies given text to platform's clipboard
*/
lt.objs.platform.copy = (function copy(text){return lt.objs.platform.clipboard.writeText(text);
});
/**
* Returns text of last copy to platform's clipboard
*/
lt.objs.platform.paste = (function paste(){return lt.objs.platform.clipboard.readText();
});
lt.objs.platform.platform = lt.objs.platform.normalize.call(null,process.platform);
lt.objs.platform.mac_QMARK_ = (function mac_QMARK_(){return cljs.core._EQ_.call(null,lt.objs.platform.platform,new cljs.core.Keyword(null,"mac","mac",1014012097));
});
lt.objs.platform.win_QMARK_ = (function win_QMARK_(){return cljs.core._EQ_.call(null,lt.objs.platform.platform,new cljs.core.Keyword(null,"windows","windows",2363397621));
});
lt.objs.platform.linux_QMARK_ = (function linux_QMARK_(){return cljs.core._EQ_.call(null,lt.objs.platform.platform,new cljs.core.Keyword(null,"linux","linux",1116882022));
});
