// Compiled by ClojureScript 0.0-2138
goog.provide('lt.objs.app');
goog.require('cljs.core');
goog.require('lt.util.js');
goog.require('lt.util.dom');
goog.require('lt.util.js');
goog.require('lt.util.dom');
goog.require('lt.objs.context');
goog.require('lt.objs.platform');
goog.require('lt.objs.context');
goog.require('lt.util.dom');
goog.require('clojure.string');
goog.require('lt.objs.command');
goog.require('lt.objs.platform');
goog.require('clojure.string');
goog.require('lt.object');
goog.require('lt.object');
goog.require('lt.util.ipc');
goog.require('lt.util.ipc');
goog.require('lt.objs.command');
lt.objs.app.remote = require("remote");
lt.objs.app.win = lt.objs.app.remote.getCurrentWindow();
lt.objs.app.frame = require("web-frame");
lt.objs.app.closing = true;
lt.objs.app.default_zoom = 1;
lt.objs.app.app_url = (function app_url(){return window.location.href;
});
lt.objs.app.window_number = (function window_number(){return lt.objs.app.win.id;
});
lt.objs.app.first_window_QMARK_ = (function first_window_QMARK_(){return cljs.core._EQ_.call(null,1,lt.objs.app.window_number.call(null));
});
lt.objs.app.prevent_close = (function prevent_close(){return lt.objs.app.closing = false;
});
lt.objs.app.close = (function() {
var close = null;
var close__0 = (function (){return close.call(null,false);
});
var close__1 = (function (force_QMARK_){if(cljs.core.truth_(force_QMARK_))
{lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"closing","closing",1880444967));
lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"closed","closed",3951351006));
return lt.objs.app.win.destroy();
} else
{return lt.objs.app.win.close();
}
});
close = function(force_QMARK_){
switch(arguments.length){
case 0:
return close__0.call(this);
case 1:
return close__1.call(this,force_QMARK_);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
close.cljs$core$IFn$_invoke$arity$0 = close__0;
close.cljs$core$IFn$_invoke$arity$1 = close__1;
return close;
})()
;
lt.objs.app.refresh = (function refresh(){return window.location.reload(true);
});
lt.objs.app.init = (function init(){lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"deploy","deploy",3973538905));
lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"pre-init","pre-init",3967677804));
lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"init","init",1017141378));
lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"post-init","post-init",2970371471));
return lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"show","show",1017433711));
});
lt.objs.app.fetch = (function fetch__$1(k){var temp__4092__auto__ = (localStorage[cljs.core.name.call(null,k)]);if(cljs.core.truth_(temp__4092__auto__))
{var v = temp__4092__auto__;if(cljs.core.not_EQ_.call(null,"null",v))
{return JSON.parse(v);
} else
{return null;
}
} else
{return null;
}
});
/**
* Store key and value in localStorage. If value is a string, fetch must be used
* to get back the original value from localStorage.
*/
lt.objs.app.store_BANG_ = (function store_BANG_(k,v){return (localStorage[cljs.core.name.call(null,k)] = ((typeof v === 'string')?cljs.core.pr_str.call(null,v):v));
});
lt.objs.app.store_swap_BANG_ = (function store_swap_BANG_(k,f){var neue = f.call(null,lt.objs.app.fetch.call(null,k));lt.objs.app.store_BANG_.call(null,k,neue);
return neue;
});
lt.objs.app.ensure_greater = (function ensure_greater(x,cap){var x__$1 = ((typeof x === 'string')?parseInt(x):x);var x__3827__auto__ = x__$1;var y__3828__auto__ = cap;return ((x__3827__auto__ > y__3828__auto__) ? x__3827__auto__ : y__3828__auto__);
});
lt.objs.app.zoom_level = (function zoom_level(){if(cljs.core.not_EQ_.call(null,lt.objs.app.frame.getZoomFactor(),0))
{return lt.objs.app.frame.getZoomFactor();
} else
{return null;
}
});
lt.objs.app.open_window = (function open_window(){return lt.util.ipc.send.call(null,"createWindow");
});
lt.objs.app.__BEH__refresh = (function __BEH__refresh(obj){lt.objs.app.closing = true;
lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"reload","reload",4374230283));
if(cljs.core.truth_(lt.objs.app.closing))
{return lt.objs.app.refresh.call(null);
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","refresh","lt.objs.app/refresh",2086834125),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__refresh,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"refresh","refresh",2099349069),null], null), null));
lt.objs.app.__BEH__close_BANG_ = (function __BEH__close_BANG_(this$){lt.objs.app.closing = true;
lt.object.raise.call(null,this$,new cljs.core.Keyword(null,"close","close",1108660586));
if(cljs.core.truth_(lt.objs.app.closing))
{return lt.objs.app.close.call(null,true);
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","close!","lt.objs.app/close!",3934658067),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__close_BANG_,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"close!","close!",3951350939),null], null), null));
lt.objs.app.__BEH__notify_init_window = (function __BEH__notify_init_window(this$){return lt.util.ipc.send.call(null,"initWindow",lt.objs.app.window_number.call(null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","notify-init-window","lt.objs.app/notify-init-window",4741533683),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__notify_init_window,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"init","init",1017141378),null], null), null));
lt.objs.app.__BEH__store_position_on_close = (function __BEH__store_position_on_close(this$){if(cljs.core.truth_(lt.objs.app.win.isFullScreen()))
{} else
{var vec__11436_11438 = lt.objs.app.win.getSize();var width_11439 = cljs.core.nth.call(null,vec__11436_11438,0,null);var height_11440 = cljs.core.nth.call(null,vec__11436_11438,1,null);lt.objs.app.store_BANG_.call(null,new cljs.core.Keyword(null,"width","width",1127031096),width_11439);
lt.objs.app.store_BANG_.call(null,new cljs.core.Keyword(null,"height","height",4087841945),height_11440);
var vec__11437_11441 = lt.objs.app.win.getPosition();var x_11442 = cljs.core.nth.call(null,vec__11437_11441,0,null);var y_11443 = cljs.core.nth.call(null,vec__11437_11441,1,null);lt.objs.app.store_BANG_.call(null,new cljs.core.Keyword(null,"x","x",1013904362),x_11442);
lt.objs.app.store_BANG_.call(null,new cljs.core.Keyword(null,"y","y",1013904363),y_11443);
}
return localStorage.fullscreen = lt.objs.app.win.isFullScreen();
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","store-position-on-close","lt.objs.app/store-position-on-close",4276509686),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__store_position_on_close,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"refresh","refresh",2099349069),null,new cljs.core.Keyword(null,"closed","closed",3951351006),null], null), null));
lt.objs.app.__BEH__restore_fullscreen = (function __BEH__restore_fullscreen(this$){if(cljs.core._EQ_.call(null,localStorage.fullscreen,"true"))
{return lt.objs.app.win.setFullScreen(true);
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","restore-fullscreen","lt.objs.app/restore-fullscreen",4105867086),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__restore_fullscreen,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"show","show",1017433711),null], null), null));
lt.objs.app.__BEH__restore_position_on_init = (function __BEH__restore_position_on_init(this$){if(cljs.core.truth_(localStorage.width))
{lt.objs.app.win.setSize(lt.objs.app.ensure_greater.call(null,localStorage.width,400),lt.objs.app.ensure_greater.call(null,localStorage.height,400));
return lt.objs.app.win.setPosition(lt.objs.app.ensure_greater.call(null,localStorage.x,0),lt.objs.app.ensure_greater.call(null,localStorage.y,0));
} else
{return null;
}
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","restore-position-on-init","lt.objs.app/restore-position-on-init",2792598979),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__restore_position_on_init,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"show","show",1017433711),null], null), null));
lt.objs.app.__BEH__on_show_bind_navigate = (function __BEH__on_show_bind_navigate(this$){return lt.util.dom.on.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"#canvas","#canvas",644055725)),new cljs.core.Keyword(null,"click","click",1108654330),(function (e){if((cljs.core._EQ_.call(null,e.target.nodeName,"A")) && (cljs.core.not.call(null,e.defaultPrevented)))
{lt.util.dom.prevent.call(null,e);
var temp__4092__auto__ = e.target.href;if(cljs.core.truth_(temp__4092__auto__))
{var href = temp__4092__auto__;lt.objs.platform.open_url.call(null,href);
return lt.objs.app.win.focus();
} else
{return null;
}
} else
{return null;
}
}));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","on-show-bind-navigate","lt.objs.app/on-show-bind-navigate",1419254217),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__on_show_bind_navigate,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"show","show",1017433711),null], null), null));
lt.objs.app.__BEH__track_focus = (function __BEH__track_focus(this$){return lt.objs.app.store_BANG_.call(null,new cljs.core.Keyword(null,"focusedWindow","focusedWindow",2946535865),lt.objs.app.window_number.call(null));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","track-focus","lt.objs.app/track-focus",886975714),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__track_focus,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"focus","focus",1111509066),null,new cljs.core.Keyword(null,"show","show",1017433711),null], null), null));
lt.objs.app.__BEH__focus_class = (function __BEH__focus_class(this$){lt.util.dom.add_class.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"body","body",1016933652)),new cljs.core.Keyword(null,"active","active",3885920888));
return lt.util.dom.remove_class.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"body","body",1016933652)),new cljs.core.Keyword(null,"inactive","inactive",1038569437));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","focus-class","lt.objs.app/focus-class",2565082997),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__focus_class,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"focus","focus",1111509066),null,new cljs.core.Keyword(null,"show","show",1017433711),null], null), null));
lt.objs.app.__BEH__blur_class = (function __BEH__blur_class(this$){lt.util.dom.remove_class.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"body","body",1016933652)),new cljs.core.Keyword(null,"active","active",3885920888));
return lt.util.dom.add_class.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"body","body",1016933652)),new cljs.core.Keyword(null,"inactive","inactive",1038569437));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","blur-class","lt.objs.app/blur-class",3477879718),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__blur_class,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"blur","blur",1016931289),null], null), null));
/**
* @param {...*} var_args
*/
lt.objs.app.run_commands = (function() { 
var run_commands__delegate = function (this$,commands){if(cljs.core.seq.call(null,commands))
{var commands__$1 = ((cljs.core.vector_QMARK_.call(null,cljs.core.first.call(null,commands)))?cljs.core.first.call(null,commands):commands);var seq__11448 = cljs.core.seq.call(null,commands__$1);var chunk__11449 = null;var count__11450 = 0;var i__11451 = 0;while(true){
if((i__11451 < count__11450))
{var c = cljs.core._nth.call(null,chunk__11449,i__11451);if(cljs.core.coll_QMARK_.call(null,c))
{cljs.core.apply.call(null,lt.objs.command.exec_BANG_,c);
} else
{lt.objs.command.exec_BANG_.call(null,c);
}
{
var G__11452 = seq__11448;
var G__11453 = chunk__11449;
var G__11454 = count__11450;
var G__11455 = (i__11451 + 1);
seq__11448 = G__11452;
chunk__11449 = G__11453;
count__11450 = G__11454;
i__11451 = G__11455;
continue;
}
} else
{var temp__4092__auto__ = cljs.core.seq.call(null,seq__11448);if(temp__4092__auto__)
{var seq__11448__$1 = temp__4092__auto__;if(cljs.core.chunked_seq_QMARK_.call(null,seq__11448__$1))
{var c__4262__auto__ = cljs.core.chunk_first.call(null,seq__11448__$1);{
var G__11456 = cljs.core.chunk_rest.call(null,seq__11448__$1);
var G__11457 = c__4262__auto__;
var G__11458 = cljs.core.count.call(null,c__4262__auto__);
var G__11459 = 0;
seq__11448 = G__11456;
chunk__11449 = G__11457;
count__11450 = G__11458;
i__11451 = G__11459;
continue;
}
} else
{var c = cljs.core.first.call(null,seq__11448__$1);if(cljs.core.coll_QMARK_.call(null,c))
{cljs.core.apply.call(null,lt.objs.command.exec_BANG_,c);
} else
{lt.objs.command.exec_BANG_.call(null,c);
}
{
var G__11460 = cljs.core.next.call(null,seq__11448__$1);
var G__11461 = null;
var G__11462 = 0;
var G__11463 = 0;
seq__11448 = G__11460;
chunk__11449 = G__11461;
count__11450 = G__11462;
i__11451 = G__11463;
continue;
}
}
} else
{return null;
}
}
break;
}
} else
{return null;
}
};
var run_commands = function (this$,var_args){
var commands = null;if (arguments.length > 1) {
  commands = cljs.core.array_seq(Array.prototype.slice.call(arguments, 1),0);} 
return run_commands__delegate.call(this,this$,commands);};
run_commands.cljs$lang$maxFixedArity = 1;
run_commands.cljs$lang$applyTo = (function (arglist__11464){
var this$ = cljs.core.first(arglist__11464);
var commands = cljs.core.rest(arglist__11464);
return run_commands__delegate(this$,commands);
});
run_commands.cljs$core$IFn$_invoke$arity$variadic = run_commands__delegate;
return run_commands;
})()
;
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","run-pre-init","lt.objs.app/run-pre-init",1828105264),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.run_commands,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Run commands before init",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1116631654),"commands",new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"list","list",1017226256),new cljs.core.Keyword(null,"items","items",1114430258),lt.objs.command.completions], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"pre-init","pre-init",3967677804),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","run-on-init","lt.objs.app/run-on-init",4379501616),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.run_commands,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Run commands on init",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1116631654),"commands",new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"list","list",1017226256),new cljs.core.Keyword(null,"items","items",1114430258),lt.objs.command.completions], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"init","init",1017141378),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","run-post-init","lt.objs.app/run-post-init",2244260429),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.run_commands,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Run commands after init",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"label","label",1116631654),"commands",new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"list","list",1017226256),new cljs.core.Keyword(null,"items","items",1114430258),lt.objs.command.completions], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"post-init","post-init",2970371471),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.app.__BEH__set_default_zoom_level = (function __BEH__set_default_zoom_level(this$,default$){lt.objs.app.default_zoom = default$;
return lt.objs.command.exec_BANG_.call(null,new cljs.core.Keyword(null,"window.zoom-reset","window.zoom-reset",1865763589));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","set-default-zoom-level","lt.objs.app/set-default-zoom-level",2566845515),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__set_default_zoom_level,new cljs.core.Keyword(null,"desc","desc",1016984067),"App: Set the default zoom level",new cljs.core.Keyword(null,"params","params",4313443576),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"label","label",1116631654),"default-zoom-level",new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"number","number",4274507451)], null)], null),new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"init","init",1017141378),null], null), null),new cljs.core.Keyword(null,"type","type",1017479852),new cljs.core.Keyword(null,"user","user",1017503549));
lt.objs.app.__BEH__add_platform_class = (function __BEH__add_platform_class(this$){return lt.util.dom.add_class.call(null,lt.util.dom.$.call(null,new cljs.core.Keyword(null,"body","body",1016933652)),cljs.core.name.call(null,lt.objs.platform.platform));
});
lt.object.behavior_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","add-platform-class","lt.objs.app/add-platform-class",2911469918),new cljs.core.Keyword(null,"reaction","reaction",4441361819),lt.objs.app.__BEH__add_platform_class,new cljs.core.Keyword(null,"triggers","triggers",2516997421),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"init","init",1017141378),null], null), null));
lt.object.object_STAR_.call(null,new cljs.core.Keyword("lt.objs.app","app","lt.objs.app/app",1001502987),new cljs.core.Keyword(null,"tags","tags",1017456523),new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"app","app",1014001043),null,new cljs.core.Keyword(null,"window","window",4521119586),null], null), null),new cljs.core.Keyword(null,"delays","delays",3973409474),0,new cljs.core.Keyword(null,"init","init",1017141378),(function (this$){return lt.objs.context.in_BANG_.call(null,new cljs.core.Keyword(null,"app","app",1014001043),this$);
}));
lt.objs.app.app = lt.object.create.call(null,new cljs.core.Keyword("lt.objs.app","app","lt.objs.app/app",1001502987));
lt.util.ipc.on.call(null,"app",(function (p1__11465_SHARP_){return lt.object.raise.call(null,lt.objs.app.app,cljs.core.keyword.call(null,p1__11465_SHARP_));
}));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"window.new","window.new",2875320852),new cljs.core.Keyword(null,"desc","desc",1016984067),"Window: Open new window",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){var w = lt.objs.app.open_window.call(null);return null;
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"window.close","window.close",3118917100),new cljs.core.Keyword(null,"desc","desc",1016984067),"Window: Close window",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){return lt.object.raise.call(null,lt.objs.app.app,new cljs.core.Keyword(null,"close!","close!",3951350939));
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"window.zoom-in","window.zoom-in",4320038099),new cljs.core.Keyword(null,"desc","desc",1016984067),"Window: Zoom in",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){return lt.objs.app.frame.setZoomFactor((lt.objs.app.frame.getZoomFactor() + 0.2));
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"window.zoom-out","window.zoom-out",4719812100),new cljs.core.Keyword(null,"desc","desc",1016984067),"Window: Zoom out",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){if((lt.objs.app.frame.getZoomFactor() > 0))
{return lt.objs.app.frame.setZoomFactor((lt.objs.app.frame.getZoomFactor() - 0.2));
} else
{return null;
}
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"window.zoom-reset","window.zoom-reset",1865763589),new cljs.core.Keyword(null,"desc","desc",1016984067),"Window: Zoom reset",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){return lt.objs.app.frame.setZoomFactor(lt.objs.app.default_zoom);
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"window.fullscreen","window.fullscreen",3710835691),new cljs.core.Keyword(null,"desc","desc",1016984067),"Window: Toggle fullscreen",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){return lt.objs.app.win.setFullScreen(cljs.core.not.call(null,lt.objs.app.win.isFullScreen()));
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"window.minimize","window.minimize",2477637198),new cljs.core.Keyword(null,"desc","desc",1016984067),"Window: Minimize",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){return lt.objs.app.win.minimize();
})], null));
lt.objs.command.command.call(null,new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"command","command",1964298941),new cljs.core.Keyword(null,"window.maximize","window.maximize",4253833852),new cljs.core.Keyword(null,"desc","desc",1016984067),"Window: Maximize",new cljs.core.Keyword(null,"exec","exec",1017031683),(function (){return lt.objs.app.win.maximize();
})], null));
