#!/bin/bash

#################################################################
# For KDE-Services. 2013-2017.					#
# By Geovani Barzaga Rodriguez <igeo.cu@gmail.com>		#
#################################################################

PATH=/usr/local/bin:/usr/bin:/bin:/usr/local/sbin:/usr/sbin:/sbin:/home/$USER/bin
VERSION=$(head -n1 /usr/share/doc/kde-services*/ChangeLog |awk '{print $10}')

cat > /tmp/about_kde-services << EOF

                                                                      KDE-Services, version $VERSION, (C) 2011-2017.
                                                                      http://sourceforge.net/projects/kde-services/

            Description:
                    Enables the following functionalities on the Dolphin's (File Manager) right click contextual menu on KDE [4.x|5.x].

                    Submenu "Actions" => "KDE-Services" (it is shown when clicked any file/dir)
                                 - "Add Timestamp Prefix to [File|Dir]name"
                                 - "Change Timestamp to [File|Directory]"
                                 - "Send by Email"
                                 - "[Audio|Video] Info" (it is shown only when clicked any audio/video file)
                                 - "Show [File|Directory] Status"
                                 - "Change Owner Here" (owner and permission of file/dir)
                                 - "Text Replace" (it is shown only when clicked any text file)
                                 - "Compressed File Integrity Check" (it is shown only when clicked any compressed file)
                                 - "MKV Extract Subtitle" (it is shown only when clicked MKV video file)
                                 - "Multiplex Subtitle" (only support MPEG-2 video file)(it is shown only when clicked MPG video file)
                                 - "[File|Dir]name Whitespace Replace" (by underscore ASCII)(it is shown when clicked an directory)

                    Submenu "AVI Tools" (it is shown only when clicked AVI video file)
                                 - "Split (to size)"
                                 - "Split (by time range)"

                    Submenu "Android Tools" (it is shown when clicked an directory)
                                 - "Android Backup Manager" (backup or restore all device applications and data)
                                 - "Android File Manager" (copy file/dir from/to device)
                                 - "Android Package Manager" (install/uninstall *.apk applications)
                                 - "Android Reboot Manager" (reboots the device, optionally into the bootloader or recovery program)

                    Submenu "Backup Tools" (it is shown when clicked an directory)
                                 - "Standards" (backup/restore directories /etc/ and /root/ or GnuPG, FileZilla, Firefox, Chrome,
                                 KDE, KDE-Services, Pidgin, SSH, Thunderbird, Wine and X-Moto user configurations)

                    Submenu "CheckSum Tools" (it is shown when clicked any file)
                                 - "MD5 (strong)"
                                 - "SHA1 (good strong)"
                                 - "SHA256 (very strong)"
                                 - "SHA512 (high strong)"
                                 - "Verify CheckSum" (checksum file *.md5/*.sha1/*.sha256/*.sha512)

                    Submenu "Dolphin Tools" (it is shown when clicked an directory)
                                 - "Connect to" (FTP/SFTP/SMB protocol)
                                 - "Registered Servers" (show or edit IP/Hostname previously connected)
                                 - "Disk Space Used"

                    Submenu "Dropbox Tools" (it is shown when clicked an directory)
                                 - "Copy to Dropbox"
                                 - "Move to Dropbox"
                                 - "Copy to Public Dropbox and get URL"
                                 - "Move to Public Dropbox and get URL"
                                 - "Get public URL"
                                 - "Install Dropbox service"
                                 - "Update Dropbox service"
                                 - "Start Dropbox service"
                                 - "Stop Dropbox service"
                                 - "Enable autostart Dropbox service"

                    Submenu "Graphic Tools" (it is shown only when clicked any image file)
                                 - "The Converter" (from several image file formats to BMP, EPS, GIF, ICO, JPEG, JPEG 2000, PBM,
                                 PDF, PGM,PNG,PPM,PSD,SGI,TGA,TIFF or XPM)
                                 - "The Sizer" (resize custom image frame width)
                                 - "16x16 (icon)"
                                 - "32x32 (icon)"
                                 - "48x48 (icon)"
                                 - "64x64 (icon)"
                                 - "128x128 (icon)"
                                 - "256x256 (icon)"
                                 - "300x300 (carnet)"
                                 - "320x240 (qvga)"
                                 - "352x288 (cif)"
                                 - "414x532 (visa)"
                                 - "480x320 (hvga)"
                                 - "512x512 (icon)"
                                 - "532x532 (passport)"
                                 - "640x480 (vga)"
                                 - "720x480 (ntsc)"
                                 - "800x600 (svga)"
                                 - "960x540 (qhd)"
                                 - "1024x768 (xga)"
                                 - "1280x1024 (sxga)"
                                 - "1366x768 (wxga)"
                                 - "1440x900 (wxga)"
                                 - "1600x1200 (uxga)"
                                 - "1920x1200 (wuxga)"
                                 - "2048x1080 (2k)"
                                 - "2560x2048 (qsxga)"
                                 - "3200x2048 (wqsxga)"
                                 - "3840x2400 (wquxga)"
                                 - "4096x2160 (4k)"
                                 - "5120x4096 (hsxga)"
                                 - "6400x4096 (whsxga)"
                                 - "7680x4800 (whuxga)"
                                 - "8192x4320 (8k)"

                    Submenu "ISO-9660 Image Tools" (it is shown only when clicked ISO-9660 image file)
                                 - "Mount ISO-9660 Image"
                                 - "Unmount ISO-9660 Image"
                                 - "Integrity Check"
                                 - "Insert MD5sum"
                                 - "Show MD5sum ISO-9660 Image"
                                 - "Show SHA1sum ISO-9660 Image"
                                 - "Show SHA256sum ISO-9660 Image"
                                 - "Show SHA512sum ISO-9660 Image"
                                 - "Burn ISO-9660 Image"
                                 - "Show ISO-9660 Image Info"
                                 - "Show Optical Drive Info"

                    Submenu "Midnight Tools" (it is shown when clicked an directory)
                                 - "[Root ~]# mc" (shell file manager GNU Midnight Commander with superuser privileges)
                                 - "[Root ~]# mcedit" (internal file editor of GNU Midnight Commander with superuser privileges)
                                 - "[User ~]$ mc" (shell file manager GNU Midnight Commander with user privileges)
                                 - "[User ~]$ mcedit" (internal file editor of GNU Midnight Commander with user privileges)

                    Submenu "Multimedia Tools" (it is shown when clicked an directory)
                                 - "DVD Assembler" (with menu)
                                 - "Convert Video Files" (from several video file formats to MPEG-1, MPEG-2, MPEG-4, AVI,
                                 VCD, SVCD, DVD, 3GP, FLV or WebM)
                                 - "Add Subtitle to MP4 Files"
                                 - "Volume Normalize of MP3 Files"
                                 - "[Extract|Convert] Audio Track" (from several audio file formats to MP3, MP3(432Hz),
                                 FLAC, FLAC 432Hz, OGG or OGG 432Hz)
                                 - "Rotate Video Files"
                                 - "Edit Time from Media Files"
                                 - "Attach Cover to MP3 Files"
                                 - "Clean Metadata from Media Files"
                                 - "Concatenate Media Files with Same Codec"
                                 - "Build ISO-9660 Image from Here" (from selected directory)
                                 - "DiskCloner" (binary copy from selected optical disk device to ISO-9660 image file)
                                 - "Record My Desktop" (record video screen)
                                 - "Play Video from Here" (play video files list from selected directory)

                    Submenu "Network Tools" (it is shown when clicked an directory)
                                 - "Connect Sentry" (show every established connection to previously selected ports)
                                 - "HTTP Server" (from selected directory)
                                 - "Listening Sockets"

                    Submenu "PDF Tools" (it is shown only when clicked PDF file)
                                 - "Apply Owner Password (DRM)"
                                 - "Apply User Password (Encrypt)"
                                 - "Apply DRM + Encrypt"
                                 - "Decrypt (DRM)"
                                 - "Fixer (if possible)"
                                 - "Extract Select Pages"
                                 - "Extract All Pages"
                                 - "Extract All Images"
                                 - "Optimize"
                                 - "Compress"
                                 - "View Metadata"
                                 - "Edit Metadata"
                                 - "Merge Selected Files"
                                 - "Split in Single Page per File"
                                 - "Information"

                    Submenu "Package Tools" (it is shown only when clicked SRPM/RPM file)
                                 - "Show Changelog"
                                 - "Show Info"
                                 - "List Content"
                                 - "List Configuration Files"
                                 - "List Dependencies"
                                 - "List [Ins|Unins]tallation Scripts"
                                 - "Extract Files Here"
                                 - "Integrity Check"

                    Submenu "SSH Tools" (it is shown when clicked an directory)
                                 - "Public Key Generation" (1st mandatory step before connect to remote server)
                                 - "Install Public Key" (2nd mandatory step before connect to remote server)
                                 - "Connect to Remote Server"
                                 - "Send to Remote Server" (only file support)
                                 - "Mount point to Remote Directory" (mount/unmount remote directory over SSH protocol
                                 in local filesystem)
                                 - "Registered Servers" (show or edit IP/Hostname previously connected)

                    Submenu "SaMBa Tools" (it is shown when clicked an directory)
                                 - "SaMBa Shares Mounter" (mount/unmount remote shared directory over SMB protocol
                                 in local filesystem)

                    Submenu "Search Tools" (it is shown when clicked an directory)
                                 - "Search Here" (recursively starting from the selected directory)
                                 - "Search by Name" (file/dir name on all filesystem)
                                 - "Search by String" (recursively starting from the selected directory into file content)
                                 - "Statistics Search DataBase"
                                 - "Update Search DataBase"
                                 - "Modified Files Here" (recursively starting from the selected directory
                                 showing all modified files for the 2nd time that is executed)

                    Submenu "Security Tools" (it is shown when clicked an directory)
                                 - "Mount Encrypted Directory" (mount an encrypted virtual filesystem
                                 from the selected directory)
                                 - "Unmount Encrypted Directory" (unmount an encrypted virtual filesystem
                                 from the selected mountpoint directory)
                                 - "Encrypt Directory" (create an encrypted virtual filesystem in the selected directory)

                    Submenu "Security Tools" (it is shown when clicked any file)
                                 - "Secure Send to Mailx" (file as email attachment; need SMTP service running in localhost)
                                 - "Encrypt"
                                 - "Decrypt"
                                 - "Paranoid Shredder" (delete files in a very safe way)

                    Submenu "System Tools" (it is shown when clicked an directory)
                                 - "Build Custom Kernel" (customize the system kernel easily, increasing the system performance
                                 and/or adding more hardware support, only for distros based on RHEL)
                                 - "Check Kernel Update" (only for distros based on RHEL)
                                 - "Rebuild RPM Package" (customize applications easily, increasing the application performance
                                 and/or adding more support, only for distros based on RHEL)
                                 - "System Information"
                                 - "System Monitor" (show system log fail/error events when they happen)
                                 - "Process Viewer"
                                 - "Xorg Configure" (create a configuration file for X11R7 X server)

                    Submenu "Terminal Tools" (it is shown only when clicked shell scripts/apps file)
                                 - "Run Application"
                                 - "Run Application (Root)"

                    Submenu "YouTube Tools" (it is shown when clicked an directory)
                                 - "Video Downloader"
                                 - "Video List Code Collector"

            Required dependencies:
                    - android-tools
                    - bash
                    - bc
                    - bzip2
                    - cifs-utils
                    - coreutils
                    - diffutils
                    - dmidecode
                    - dvdauthor
                    - festival
                    - ffmpeg
                    - file
                    - findutils
                    - fuse
                    - fuseiso
                    - fuse-encfs
                    - fuse-sshfs
                    - gawk
                    - genisoimage
                    - ghostscript
                    - gnupg
                    - htop
                    - ImageMagick
                    - iproute
                    - isomd5sum
                    - kde-baseapps
                    - kde-runtime
                    - kernel-tools
                    - konsole
                    - libcdio
                    - liberation-sans-fonts
                    - lynx
                    - mailx
                    - mc
                    - mkvtoolnix
                    - mlocate
                    - mp3gain
                    - net-tools
                    - openssh-askpass
                    - pdftk
                    - perl
                    - perl-Image-ExifTool
                    - poppler
                    - poppler-utils
                    - procps
                    - psmisc
                    - pv
                    - recode
                    - samba-client
                    - sed
                    - shared-mime-info
                    - sox
                    - tar
                    - transcode
                    - unar
                    - util-linux
                    - vlc
                    - wget
                    - wodim
                    - xdg-utils
                    - xorg-x11-server-utils
                    - xorg-x11-server-Xorg
                    - xterm
                    - youtube-dl
                    - zip

            Author: 
                    Geovani Barzaga Rodriguez (geobarrod) <igeo.cu@gmail.com>, Developer and Fedora RPM Maintainer.

            Language support:
                    - Chinese
                    - French
                    - German
                    - Italian
                    - Japanese
                    - Korean
                    - Portuguese
                    - Russian
                    - Spanish
                    - Ukrainian

            Contributors:
                    - Sylvain Vidal <garion@mailoo.org> (Author of service menu PDFktools).
                    - David Baum <david.baum@naraesk.eu> (Service menu PDFktools bugfixer and author of the good idea
                    of integrating PDFktools on "PDF Tools").
                    - Victor Guardiola <victor.guardiola@gmail.com> (Improved source code for "Mount ISO Image"
                    and "Umount ISO Image" services menu; fixed the problem of [dir|file]name with whitespaces).
                    - Vasyl V. Vercynskyj <fuckel@ukr.net> (Translations to Russian and Ukrainian languages).
                    - Pawan Yadav <pawanyadav@gmail.com> (Research for KF5 support).
                    - Bruce Zhang <zttt183525594@gmail.com> (Translations to Chinese language).

            License:
                    GPLv3+ (GNU GENERAL PUBLIC LICENSE, Version 3, 29 June 2007)

EOF

kdialog --icon=ks-menu --title="About KDE-Services" --textbox /tmp/about_kde-services 900 600 2> /dev/null
rm -f /tmp/about_kde-services
exit 0
